/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imagepipeline.producers.DownsampleUtil;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class SimpleImageTranscoder
implements ImageTranscoder {
    private static final String TAG = "SimpleImageTranscoder";
    private final boolean mResizingEnabled;
    private final int mMaxBitmapSize;
    private final PlatformDecoder mPlatformDecoder;
    private final PlatformBitmapFactory mPlatformBitmapFactory;

    SimpleImageTranscoder(boolean resizingEnabled, int maxBitmapSize, PlatformDecoder platformDecoder, PlatformBitmapFactory platformBitmapFactory) {
        this.mResizingEnabled = resizingEnabled;
        this.mMaxBitmapSize = maxBitmapSize;
        this.mPlatformDecoder = platformDecoder;
        this.mPlatformBitmapFactory = platformBitmapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageTranscodeResult transcode(EncodedImage encodedImage, OutputStream outputStream, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @Nullable ImageFormat outputFormat, @Nullable Integer quality) {
        ImageTranscodeResult imageTranscodeResult;
        if (quality == null) {
            quality = 85;
        }
        if (rotationOptions == null) {
            rotationOptions = RotationOptions.autoRotate();
        }
        int oldSampleSize = encodedImage.getSampleSize();
        int sampleSize = this.getSampleSize(encodedImage, rotationOptions, resizeOptions);
        encodedImage.setSampleSize(sampleSize);
        CloseableReference<Bitmap> resizedBitmapRef = this.mPlatformDecoder.decodeFromEncodedImageWithColorSpace(encodedImage, Bitmap.Config.ARGB_8888, null, true);
        encodedImage.setSampleSize(oldSampleSize);
        if (resizedBitmapRef == null || !resizedBitmapRef.isValid()) {
            FLog.e((String)TAG, (String)"Couldn't decode the EncodedImage InputStream ! ");
            return new ImageTranscodeResult(2);
        }
        Matrix transformationMatrix = JpegTranscoderUtils.getTransformationMatrix(encodedImage, rotationOptions);
        CloseableReference rotatedBitmapRef = null;
        Bitmap srcBitmap = (Bitmap)resizedBitmapRef.get();
        try {
            if (transformationMatrix != null) {
                rotatedBitmapRef = this.mPlatformBitmapFactory.createBitmap(srcBitmap, 0, 0, srcBitmap.getWidth(), srcBitmap.getHeight(), transformationMatrix, false);
                srcBitmap = (Bitmap)rotatedBitmapRef.get();
            }
            srcBitmap.compress(SimpleImageTranscoder.getOutputFormat(outputFormat), quality.intValue(), outputStream);
            imageTranscodeResult = new ImageTranscodeResult(sampleSize > 1 ? 0 : 1);
        }
        catch (OutOfMemoryError oom) {
            ImageTranscodeResult imageTranscodeResult2;
            try {
                FLog.e((String)TAG, (String)"Out-Of-Memory during transcode", (Throwable)oom);
                imageTranscodeResult2 = new ImageTranscodeResult(2);
            }
            catch (Throwable throwable) {
                CloseableReference.closeSafely(resizedBitmapRef);
                CloseableReference.closeSafely(rotatedBitmapRef);
                throw throwable;
            }
            CloseableReference.closeSafely(resizedBitmapRef);
            CloseableReference.closeSafely((CloseableReference)rotatedBitmapRef);
            return imageTranscodeResult2;
        }
        CloseableReference.closeSafely(resizedBitmapRef);
        CloseableReference.closeSafely((CloseableReference)rotatedBitmapRef);
        return imageTranscodeResult;
    }

    @Override
    public boolean canResize(EncodedImage encodedImage, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        if (rotationOptions == null) {
            rotationOptions = RotationOptions.autoRotate();
        }
        return this.mResizingEnabled && DownsampleUtil.determineSampleSize(rotationOptions, resizeOptions, encodedImage, this.mMaxBitmapSize) > 1;
    }

    @Override
    public String getIdentifier() {
        return TAG;
    }

    private int getSampleSize(EncodedImage encodedImage, RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        int sampleSize = !this.mResizingEnabled ? 1 : DownsampleUtil.determineSampleSize(rotationOptions, resizeOptions, encodedImage, this.mMaxBitmapSize);
        return sampleSize;
    }

    private static Bitmap.CompressFormat getOutputFormat(@Nullable ImageFormat format) {
        if (format == null) {
            return Bitmap.CompressFormat.JPEG;
        }
        if (format == DefaultImageFormats.JPEG) {
            return Bitmap.CompressFormat.JPEG;
        }
        if (format == DefaultImageFormats.PNG) {
            return Bitmap.CompressFormat.PNG;
        }
        if (Build.VERSION.SDK_INT >= 14 && DefaultImageFormats.isStaticWebpFormat((ImageFormat)format)) {
            return Bitmap.CompressFormat.WEBP;
        }
        return Bitmap.CompressFormat.JPEG;
    }
}

