/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Objects;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.BytesRange;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageRequest {
    private final CacheChoice mCacheChoice;
    private final Uri mSourceUri;
    private final int mSourceUriType;
    private File mSourceFile;
    private final boolean mProgressiveRenderingEnabled;
    private final boolean mLocalThumbnailPreviewsEnabled;
    private final ImageDecodeOptions mImageDecodeOptions;
    @Nullable
    private final ResizeOptions mResizeOptions;
    private final RotationOptions mRotationOptions;
    @Nullable
    private final BytesRange mBytesRange;
    private final Priority mRequestPriority;
    private final RequestLevel mLowestPermittedRequestLevel;
    private final boolean mIsDiskCacheEnabled;
    private final boolean mIsMemoryCacheEnabled;
    @Nullable
    private final Postprocessor mPostprocessor;
    @Nullable
    private final RequestListener mRequestListener;

    public static ImageRequest fromFile(@Nullable File file) {
        return file == null ? null : ImageRequest.fromUri(UriUtil.getUriForFile((File)file));
    }

    public static ImageRequest fromUri(@Nullable Uri uri) {
        return uri == null ? null : ImageRequestBuilder.newBuilderWithSource(uri).build();
    }

    public static ImageRequest fromUri(@Nullable String uriString) {
        return uriString == null || uriString.length() == 0 ? null : ImageRequest.fromUri(Uri.parse((String)uriString));
    }

    protected ImageRequest(ImageRequestBuilder builder) {
        this.mCacheChoice = builder.getCacheChoice();
        this.mSourceUri = builder.getSourceUri();
        this.mSourceUriType = ImageRequest.getSourceUriType(this.mSourceUri);
        this.mProgressiveRenderingEnabled = builder.isProgressiveRenderingEnabled();
        this.mLocalThumbnailPreviewsEnabled = builder.isLocalThumbnailPreviewsEnabled();
        this.mImageDecodeOptions = builder.getImageDecodeOptions();
        this.mResizeOptions = builder.getResizeOptions();
        this.mRotationOptions = builder.getRotationOptions() == null ? RotationOptions.autoRotate() : builder.getRotationOptions();
        this.mBytesRange = builder.getBytesRange();
        this.mRequestPriority = builder.getRequestPriority();
        this.mLowestPermittedRequestLevel = builder.getLowestPermittedRequestLevel();
        this.mIsDiskCacheEnabled = builder.isDiskCacheEnabled();
        this.mIsMemoryCacheEnabled = builder.isMemoryCacheEnabled();
        this.mPostprocessor = builder.getPostprocessor();
        this.mRequestListener = builder.getRequestListener();
    }

    public CacheChoice getCacheChoice() {
        return this.mCacheChoice;
    }

    public Uri getSourceUri() {
        return this.mSourceUri;
    }

    public int getSourceUriType() {
        return this.mSourceUriType;
    }

    public int getPreferredWidth() {
        return this.mResizeOptions != null ? this.mResizeOptions.width : 2048;
    }

    public int getPreferredHeight() {
        return this.mResizeOptions != null ? this.mResizeOptions.height : 2048;
    }

    @Nullable
    public ResizeOptions getResizeOptions() {
        return this.mResizeOptions;
    }

    public RotationOptions getRotationOptions() {
        return this.mRotationOptions;
    }

    @Deprecated
    public boolean getAutoRotateEnabled() {
        return this.mRotationOptions.useImageMetadata();
    }

    @Nullable
    public BytesRange getBytesRange() {
        return this.mBytesRange;
    }

    public ImageDecodeOptions getImageDecodeOptions() {
        return this.mImageDecodeOptions;
    }

    public boolean getProgressiveRenderingEnabled() {
        return this.mProgressiveRenderingEnabled;
    }

    public boolean getLocalThumbnailPreviewsEnabled() {
        return this.mLocalThumbnailPreviewsEnabled;
    }

    public Priority getPriority() {
        return this.mRequestPriority;
    }

    public RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    public boolean isDiskCacheEnabled() {
        return this.mIsDiskCacheEnabled;
    }

    public boolean isMemoryCacheEnabled() {
        return this.mIsMemoryCacheEnabled;
    }

    public synchronized File getSourceFile() {
        if (this.mSourceFile == null) {
            this.mSourceFile = new File(this.mSourceUri.getPath());
        }
        return this.mSourceFile;
    }

    @Nullable
    public Postprocessor getPostprocessor() {
        return this.mPostprocessor;
    }

    @Nullable
    public RequestListener getRequestListener() {
        return this.mRequestListener;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImageRequest)) {
            return false;
        }
        ImageRequest request = (ImageRequest)o;
        if (!(Objects.equal((Object)this.mSourceUri, (Object)request.mSourceUri) && Objects.equal((Object)((Object)this.mCacheChoice), (Object)((Object)request.mCacheChoice)) && Objects.equal((Object)this.mSourceFile, (Object)request.mSourceFile) && Objects.equal((Object)this.mBytesRange, (Object)request.mBytesRange) && Objects.equal((Object)this.mImageDecodeOptions, (Object)request.mImageDecodeOptions) && Objects.equal((Object)this.mResizeOptions, (Object)request.mResizeOptions) && Objects.equal((Object)this.mRotationOptions, (Object)request.mRotationOptions))) {
            return false;
        }
        CacheKey thisPostprocessorKey = this.mPostprocessor != null ? this.mPostprocessor.getPostprocessorCacheKey() : null;
        CacheKey thatPostprocessorKey = request.mPostprocessor != null ? request.mPostprocessor.getPostprocessorCacheKey() : null;
        return Objects.equal((Object)thisPostprocessorKey, (Object)thatPostprocessorKey);
    }

    public int hashCode() {
        CacheKey postprocessorCacheKey = this.mPostprocessor != null ? this.mPostprocessor.getPostprocessorCacheKey() : null;
        return Objects.hashCode((Object[])new Object[]{this.mCacheChoice, this.mSourceUri, this.mSourceFile, this.mBytesRange, this.mImageDecodeOptions, this.mResizeOptions, this.mRotationOptions, postprocessorCacheKey});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uri", (Object)this.mSourceUri).add("cacheChoice", (Object)this.mCacheChoice).add("decodeOptions", (Object)this.mImageDecodeOptions).add("postprocessor", (Object)this.mPostprocessor).add("priority", (Object)this.mRequestPriority).add("resizeOptions", (Object)this.mResizeOptions).add("rotationOptions", (Object)this.mRotationOptions).add("bytesRange", (Object)this.mBytesRange).toString();
    }

    private static int getSourceUriType(Uri uri) {
        if (uri == null) {
            return -1;
        }
        if (UriUtil.isNetworkUri((Uri)uri)) {
            return 0;
        }
        if (UriUtil.isEmbeddedUri((Uri)uri)) {
            return 9;
        }
        if (UriUtil.isLocalFileUri((Uri)uri)) {
            if (MediaUtils.isVideo((String)MediaUtils.extractMime((String)uri.getPath()))) {
                return 2;
            }
            return 3;
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            return 4;
        }
        if (UriUtil.isLocalAssetUri((Uri)uri)) {
            return 5;
        }
        if (UriUtil.isLocalResourceUri((Uri)uri)) {
            return 6;
        }
        if (UriUtil.isDataUri((Uri)uri)) {
            return 7;
        }
        if (UriUtil.isQualifiedResourceUri((Uri)uri)) {
            return 8;
        }
        return -1;
    }

    public static enum RequestLevel {
        FULL_FETCH(1),
        DISK_CACHE(2),
        ENCODED_MEMORY_CACHE(3),
        BITMAP_MEMORY_CACHE(4);

        private int mValue;

        private RequestLevel(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RequestLevel getMax(RequestLevel requestLevel1, RequestLevel requestLevel2) {
            return requestLevel1.getValue() > requestLevel2.getValue() ? requestLevel1 : requestLevel2;
        }
    }

    public static enum CacheChoice {
        SMALL,
        DEFAULT;

    }
}

