/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class ResizeAndRotateProducer
implements Producer<EncodedImage> {
    private static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    private static final String ORIGINAL_SIZE_KEY = "Original size";
    private static final String REQUESTED_SIZE_KEY = "Requested size";
    private static final String TRANSCODING_RESULT = "Transcoding result";
    private static final String TRANSCODER_ID = "Transcoder id";
    @VisibleForTesting
    static final int MIN_TRANSFORM_INTERVAL_MS = 100;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<EncodedImage> mInputProducer;
    private final ImageTranscoder mImageTranscoder;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<EncodedImage> inputProducer, ImageTranscoder imageTranscoder) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mImageTranscoder = (ImageTranscoder)Preconditions.checkNotNull((Object)imageTranscoder);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mInputProducer.produceResults(new TransformingConsumer(consumer, context, this.mImageTranscoder), context);
    }

    private static TriState shouldTransform(ImageRequest request, EncodedImage encodedImage, ImageTranscoder imageTranscoder) {
        if (encodedImage == null || encodedImage.getImageFormat() == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG) {
            return TriState.NO;
        }
        return TriState.valueOf((ResizeAndRotateProducer.shouldRotate(request.getRotationOptions(), encodedImage) || imageTranscoder.canResize(encodedImage, request.getRotationOptions(), request.getResizeOptions()) ? 1 : 0) != 0);
    }

    private static boolean shouldRotate(RotationOptions rotationOptions, EncodedImage encodedImage) {
        return !rotationOptions.canDeferUntilRendered() && (JpegTranscoderUtils.getRotationAngle(rotationOptions, encodedImage) != 0 || ResizeAndRotateProducer.shouldRotateUsingExifOrientation(rotationOptions, encodedImage));
    }

    private static boolean shouldRotateUsingExifOrientation(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.rotationEnabled() || rotationOptions.canDeferUntilRendered()) {
            encodedImage.setExifOrientation(0);
            return false;
        }
        return JpegTranscoderUtils.INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation());
    }

    private class TransformingConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ImageTranscoder mImageTranscoder;
        private final ProducerContext mProducerContext;
        private boolean mIsCancelled;
        private final JobScheduler mJobScheduler;

        public TransformingConsumer(final Consumer<EncodedImage> consumer, ProducerContext producerContext, ImageTranscoder imageTranscoder) {
            super(consumer);
            this.mIsCancelled = false;
            this.mProducerContext = producerContext;
            this.mImageTranscoder = imageTranscoder;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(EncodedImage encodedImage, int status) {
                    TransformingConsumer.this.doTransform(encodedImage, status);
                }
            };
            this.mJobScheduler = new JobScheduler(ResizeAndRotateProducer.this.mExecutor, job, 100);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (TransformingConsumer.this.mProducerContext.isIntermediateResultExpected()) {
                        TransformingConsumer.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    TransformingConsumer.this.mJobScheduler.clearJob();
                    TransformingConsumer.this.mIsCancelled = true;
                    consumer.onCancellation();
                }
            });
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            if (this.mIsCancelled) {
                return;
            }
            boolean isLast = TransformingConsumer.isLast(status);
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, 1);
                }
                return;
            }
            TriState shouldTransform = ResizeAndRotateProducer.shouldTransform(this.mProducerContext.getImageRequest(), newResult, this.mImageTranscoder);
            if (!isLast && shouldTransform == TriState.UNSET) {
                return;
            }
            if (shouldTransform != TriState.YES) {
                if (!this.mProducerContext.getImageRequest().getRotationOptions().canDeferUntilRendered() && newResult.getRotationAngle() != 0 && newResult.getRotationAngle() != -1) {
                    newResult = this.moveImage(newResult);
                    newResult.setRotationAngle(0);
                }
                this.getConsumer().onNewResult(newResult, status);
                return;
            }
            if (!this.mJobScheduler.updateJob(newResult, status)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        private EncodedImage moveImage(EncodedImage newResult) {
            EncodedImage cloned = EncodedImage.cloneOrNull((EncodedImage)newResult);
            newResult.close();
            return cloned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTransform(EncodedImage encodedImage, int status) {
            this.mProducerContext.getListener().onProducerStart(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME);
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            Map<String, String> extraMap = null;
            try (PooledByteBufferOutputStream outputStream = ResizeAndRotateProducer.this.mPooledByteBufferFactory.newOutputStream();){
                ImageTranscodeResult result = this.mImageTranscoder.transcode(encodedImage, (OutputStream)outputStream, imageRequest.getRotationOptions(), imageRequest.getResizeOptions(), null, 85);
                extraMap = this.getExtraMap(encodedImage, imageRequest.getResizeOptions(), result, this.mImageTranscoder.getIdentifier());
                CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                try {
                    EncodedImage ret = new EncodedImage(ref);
                    ret.setImageFormat(DefaultImageFormats.JPEG);
                    try {
                        ret.parseMetaData();
                        this.mProducerContext.getListener().onProducerFinishWithSuccess(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, extraMap);
                        if (result.getTranscodeStatus() != 1) {
                            status |= 0x10;
                        }
                        this.getConsumer().onNewResult(ret, status);
                    }
                    finally {
                        EncodedImage.closeSafely((EncodedImage)ret);
                    }
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
            }
        }

        private Map<String, String> getExtraMap(EncodedImage encodedImage, @Nullable ResizeOptions resizeOptions, @Nullable ImageTranscodeResult transcodeResult, @Nullable String transcoderId) {
            if (!this.mProducerContext.getListener().requiresExtraMap(this.mProducerContext.getId())) {
                return null;
            }
            String originalSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String requestedSize = resizeOptions != null ? resizeOptions.width + "x" + resizeOptions.height : "Unspecified";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ResizeAndRotateProducer.ORIGINAL_SIZE_KEY, originalSize);
            map.put(ResizeAndRotateProducer.REQUESTED_SIZE_KEY, requestedSize);
            map.put("queueTime", String.valueOf(this.mJobScheduler.getQueuedTime()));
            map.put(ResizeAndRotateProducer.TRANSCODER_ID, transcoderId);
            map.put(ResizeAndRotateProducer.TRANSCODING_RESULT, String.valueOf(transcodeResult));
            return ImmutableMap.copyOf(map);
        }
    }
}

