/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;

public class EmbeddedProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "EmbeddedProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final ContentResolver mContentResolver;

    public EmbeddedProducer(Executor executor, ContentResolver contentResolver) {
        this.mExecutor = executor;
        this.mContentResolver = contentResolver;
    }

    @Override
    @TargetApi(value=10)
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        final ProducerListener listener = producerContext.getListener();
        final String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<CloseableReference<CloseableImage>> cancellableProducerRunnable = new StatefulProducerRunnable<CloseableReference<CloseableImage>>(consumer, listener, PRODUCER_NAME, requestId){

            @Override
            protected void onSuccess(CloseableReference<CloseableImage> result) {
                super.onSuccess(result);
                listener.onUltimateProducerReached(requestId, EmbeddedProducer.PRODUCER_NAME, result != null);
            }

            @Override
            protected void onFailure(Exception e) {
                super.onFailure(e);
                listener.onUltimateProducerReached(requestId, EmbeddedProducer.PRODUCER_NAME, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CloseableReference<CloseableImage> getResult() throws Exception {
                byte[] bitmapData;
                String path = EmbeddedProducer.this.getLocalFilePath(imageRequest);
                if (path == null) {
                    return null;
                }
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                try {
                    retriever.setDataSource(path);
                    bitmapData = retriever.getEmbeddedPicture();
                }
                finally {
                    retriever.release();
                }
                if (bitmapData == null) {
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapData, (int)0, (int)bitmapData.length);
                if (bitmap == null) {
                    return null;
                }
                return CloseableReference.of((Closeable)new CloseableStaticBitmap(bitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance(), ImmutableQualityInfo.FULL_QUALITY, 0));
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(CloseableReference<CloseableImage> result) {
                return ImmutableMap.of((Object)EmbeddedProducer.CREATED_THUMBNAIL, (Object)String.valueOf(result != null));
            }

            @Override
            protected void disposeResult(CloseableReference<CloseableImage> result) {
                CloseableReference.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    @Nullable
    private String getLocalFilePath(ImageRequest imageRequest) {
        Uri uri = imageRequest.getSourceUri();
        return uri != null ? uri.getPath() : null;
    }
}

