/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.nativecode.NativeRoundingFilter;
import com.facebook.imagepipeline.request.BasePostprocessor;
import javax.annotation.Nullable;

public class RoundAsCirclePostprocessor
extends BasePostprocessor {
    private static final boolean ENABLE_ANTI_ALIASING = true;
    @Nullable
    private CacheKey mCacheKey;
    private final boolean mEnableAntiAliasing;

    public RoundAsCirclePostprocessor() {
        this(true);
    }

    public RoundAsCirclePostprocessor(boolean enableAntiAliasing) {
        this.mEnableAntiAliasing = enableAntiAliasing;
    }

    @Override
    public void process(Bitmap bitmap) {
        NativeRoundingFilter.toCircle(bitmap, this.mEnableAntiAliasing);
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        if (this.mCacheKey == null) {
            this.mCacheKey = this.mEnableAntiAliasing ? new SimpleCacheKey("RoundAsCirclePostprocessor#AntiAliased") : new SimpleCacheKey("RoundAsCirclePostprocessor");
        }
        return this.mCacheKey;
    }
}

