/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.BitmapPoolBackend;
import com.facebook.imagepipeline.memory.PoolBackend;
import com.facebook.imagepipeline.memory.PoolStatsTracker;

public class LruBitmapPool
implements BitmapPool {
    protected final PoolBackend<Bitmap> mStrategy = new BitmapPoolBackend();
    private final int mMaxSize;
    private final PoolStatsTracker mPoolStatsTracker;
    private int mCurrentSize;

    public LruBitmapPool(int maxSize, PoolStatsTracker poolStatsTracker) {
        this.mMaxSize = maxSize;
        this.mPoolStatsTracker = poolStatsTracker;
    }

    public void trim(MemoryTrimType trimType) {
        this.trimTo((int)((double)this.mMaxSize * (1.0 - trimType.getSuggestedTrimRatio())));
    }

    private synchronized void trimTo(int maxSize) {
        Bitmap removed;
        while (this.mCurrentSize > maxSize && (removed = this.mStrategy.pop()) != null) {
            int size = this.mStrategy.getSize(removed);
            this.mCurrentSize -= size;
            this.mPoolStatsTracker.onFree(size);
        }
    }

    public synchronized Bitmap get(int size) {
        Bitmap cached = this.mStrategy.get(size);
        if (cached != null) {
            int reusedSize = this.mStrategy.getSize(cached);
            this.mCurrentSize -= reusedSize;
            this.mPoolStatsTracker.onValueReuse(reusedSize);
            return cached;
        }
        return this.alloc(size);
    }

    @VisibleForTesting
    private Bitmap alloc(int size) {
        this.mPoolStatsTracker.onAlloc(size);
        return Bitmap.createBitmap((int)1, (int)size, (Bitmap.Config)Bitmap.Config.ALPHA_8);
    }

    public synchronized void release(Bitmap value) {
        int size = this.mStrategy.getSize(value);
        this.mPoolStatsTracker.onValueRelease(size);
        this.mStrategy.put(value);
        this.mCurrentSize += size;
        if (this.mCurrentSize > this.mMaxSize) {
            this.trimTo(this.mMaxSize);
        }
    }
}

