/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imageutils.BitmapUtil;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=21)
@ThreadSafe
public class ArtBitmapFactory
extends PlatformBitmapFactory {
    private final BitmapPool mBitmapPool;

    public ArtBitmapFactory(BitmapPool bitmapPool) {
        this.mBitmapPool = bitmapPool;
    }

    public CloseableReference<Bitmap> createBitmapInternal(int width, int height, Bitmap.Config bitmapConfig) {
        int sizeInBytes = BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig);
        Bitmap bitmap = (Bitmap)this.mBitmapPool.get(sizeInBytes);
        Preconditions.checkArgument((bitmap.getAllocationByteCount() >= width * height * BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)bitmapConfig) ? 1 : 0) != 0);
        bitmap.reconfigure(width, height, bitmapConfig);
        return CloseableReference.of((Object)bitmap, (ResourceReleaser)this.mBitmapPool);
    }
}

