/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.internal.Supplier;
import com.facebook.datasource.AbstractDataSource;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RetainingDataSourceSupplier<T>
implements Supplier<DataSource<T>> {
    private final Set<RetainingDataSource> mDataSources = Collections.newSetFromMap(new WeakHashMap());
    @Nullable
    private Supplier<DataSource<T>> mCurrentDataSourceSupplier = null;

    @Override
    public DataSource<T> get() {
        RetainingDataSource<T> dataSource = new RetainingDataSource<T>();
        dataSource.setSupplier(this.mCurrentDataSourceSupplier);
        this.mDataSources.add(dataSource);
        return dataSource;
    }

    public void replaceSupplier(Supplier<DataSource<T>> supplier) {
        this.mCurrentDataSourceSupplier = supplier;
        for (RetainingDataSource dataSource : this.mDataSources) {
            if (dataSource.isClosed()) continue;
            dataSource.setSupplier(supplier);
        }
    }

    private static class RetainingDataSource<T>
    extends AbstractDataSource<T> {
        @Nullable
        @GuardedBy(value="RetainingDataSource.this")
        private DataSource<T> mDataSource = null;

        private RetainingDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSupplier(@Nullable Supplier<DataSource<T>> supplier) {
            DataSource<T> oldDataSource;
            if (this.isClosed()) {
                return;
            }
            DataSource<T> newDataSource = supplier != null ? supplier.get() : null;
            RetainingDataSource retainingDataSource = this;
            synchronized (retainingDataSource) {
                if (this.isClosed()) {
                    RetainingDataSource.closeSafely(newDataSource);
                    return;
                }
                oldDataSource = this.mDataSource;
                this.mDataSource = newDataSource;
            }
            if (newDataSource != null) {
                newDataSource.subscribe(new InternalDataSubscriber(), CallerThreadExecutor.getInstance());
            }
            RetainingDataSource.closeSafely(oldDataSource);
        }

        @Override
        @Nullable
        public synchronized T getResult() {
            return this.mDataSource != null ? (T)this.mDataSource.getResult() : null;
        }

        @Override
        public synchronized boolean hasResult() {
            return this.mDataSource != null && this.mDataSource.hasResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            DataSource<T> dataSource;
            RetainingDataSource retainingDataSource = this;
            synchronized (retainingDataSource) {
                if (!super.close()) {
                    return false;
                }
                dataSource = this.mDataSource;
                this.mDataSource = null;
            }
            RetainingDataSource.closeSafely(dataSource);
            return true;
        }

        private void onDataSourceNewResult(DataSource<T> dataSource) {
            if (dataSource == this.mDataSource) {
                this.setResult(null, false);
            }
        }

        private void onDataSourceFailed(DataSource<T> dataSource) {
        }

        private void onDatasourceProgress(DataSource<T> dataSource) {
            if (dataSource == this.mDataSource) {
                this.setProgress(dataSource.getProgress());
            }
        }

        private static <T> void closeSafely(DataSource<T> dataSource) {
            if (dataSource != null) {
                dataSource.close();
            }
        }

        @Override
        public boolean hasMultipleResults() {
            return true;
        }

        private class InternalDataSubscriber
        implements DataSubscriber<T> {
            private InternalDataSubscriber() {
            }

            @Override
            public void onNewResult(DataSource<T> dataSource) {
                if (dataSource.hasResult()) {
                    RetainingDataSource.this.onDataSourceNewResult(dataSource);
                } else if (dataSource.isFinished()) {
                    RetainingDataSource.this.onDataSourceFailed(dataSource);
                }
            }

            @Override
            public void onFailure(DataSource<T> dataSource) {
                RetainingDataSource.this.onDataSourceFailed(dataSource);
            }

            @Override
            public void onCancellation(DataSource<T> dataSource) {
            }

            @Override
            public void onProgressUpdate(DataSource<T> dataSource) {
                RetainingDataSource.this.onDatasourceProgress(dataSource);
            }
        }
    }
}

