/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.util;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;

public class UriUtil {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String EMBEDDED_SCHEME = "embedded";
    public static final String LOCAL_FILE_SCHEME = "file";
    public static final String LOCAL_CONTENT_SCHEME = "content";
    private static final Uri LOCAL_CONTACT_IMAGE_URI = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"display_photo");
    public static final String LOCAL_ASSET_SCHEME = "asset";
    public static final String LOCAL_RESOURCE_SCHEME = "res";
    public static final String QUALIFIED_RESOURCE_SCHEME = "android.resource";
    public static final String DATA_SCHEME = "data";

    @Nullable
    public static URL uriToUrl(@Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEmbeddedUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return EMBEDDED_SCHEME.equals(scheme);
    }

    public static boolean isNetworkUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return HTTPS_SCHEME.equals(scheme) || HTTP_SCHEME.equals(scheme);
    }

    public static boolean isLocalFileUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_FILE_SCHEME.equals(scheme);
    }

    public static boolean isLocalContentUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_CONTENT_SCHEME.equals(scheme);
    }

    public static boolean isLocalContactUri(Uri uri) {
        return UriUtil.isLocalContentUri(uri) && "com.android.contacts".equals(uri.getAuthority()) && !uri.getPath().startsWith(LOCAL_CONTACT_IMAGE_URI.getPath());
    }

    public static boolean isLocalCameraUri(Uri uri) {
        String uriString = uri.toString();
        return uriString.startsWith(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString()) || uriString.startsWith(MediaStore.Images.Media.INTERNAL_CONTENT_URI.toString());
    }

    public static boolean isLocalAssetUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_ASSET_SCHEME.equals(scheme);
    }

    public static boolean isLocalResourceUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isQualifiedResourceUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return QUALIFIED_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isDataUri(@Nullable Uri uri) {
        return DATA_SCHEME.equals(UriUtil.getSchemeOrNull(uri));
    }

    @Nullable
    public static String getSchemeOrNull(@Nullable Uri uri) {
        return uri == null ? null : uri.getScheme();
    }

    public static Uri parseUriOrNull(@Nullable String uriAsString) {
        return uriAsString != null ? Uri.parse((String)uriAsString) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getRealPathFromUri(ContentResolver contentResolver, Uri srcUri) {
        String result = null;
        if (UriUtil.isLocalContentUri(srcUri)) {
            try (Cursor cursor = null;){
                cursor = contentResolver.query(srcUri, null, null, null, null);
                if (cursor == null) return result;
                if (!cursor.moveToFirst()) return result;
                int idx = cursor.getColumnIndex("_data");
                if (idx == -1) return result;
                result = cursor.getString(idx);
                return result;
            }
        } else {
            if (!UriUtil.isLocalFileUri(srcUri)) return result;
            return srcUri.getPath();
        }
    }

    public static Uri getUriForFile(File file) {
        return Uri.fromFile((File)file);
    }

    public static Uri getUriForResourceId(int resourceId) {
        return new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resourceId)).build();
    }

    public static Uri getUriForQualifiedResource(String packageName, int resourceId) {
        return new Uri.Builder().scheme(QUALIFIED_RESOURCE_SCHEME).authority(packageName).path(String.valueOf(resourceId)).build();
    }
}

