/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import com.facebook.infer.annotation.PropagatesNullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class CloseableReference<T>
implements Cloneable,
Closeable {
    private static Class<CloseableReference> TAG = CloseableReference.class;
    @GuardedBy(value="this")
    private boolean mIsClosed = false;
    private final SharedReference<T> mSharedReference;
    private static final ResourceReleaser<Closeable> DEFAULT_CLOSEABLE_RELEASER = new ResourceReleaser<Closeable>(){

        @Override
        public void release(Closeable value) {
            try {
                Closeables.close(value, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    private CloseableReference(SharedReference<T> sharedReference) {
        this.mSharedReference = Preconditions.checkNotNull(sharedReference);
        sharedReference.addReference();
    }

    private CloseableReference(T t, ResourceReleaser<T> resourceReleaser) {
        this.mSharedReference = new SharedReference<T>(t, resourceReleaser);
    }

    public static <T extends Closeable> CloseableReference<T> of(@PropagatesNullable T t) {
        if (t == null) {
            return null;
        }
        return new CloseableReference<Closeable>(t, DEFAULT_CLOSEABLE_RELEASER);
    }

    public static <T> CloseableReference<T> of(@PropagatesNullable T t, ResourceReleaser<T> resourceReleaser) {
        if (t == null) {
            return null;
        }
        return new CloseableReference<T>(t, resourceReleaser);
    }

    public synchronized T get() {
        Preconditions.checkState(!this.mIsClosed);
        return this.mSharedReference.get();
    }

    public synchronized CloseableReference<T> clone() {
        Preconditions.checkState(this.isValid());
        return new CloseableReference<T>(this.mSharedReference);
    }

    @Nullable
    public synchronized CloseableReference<T> cloneOrNull() {
        if (this.isValid()) {
            return this.clone();
        }
        return null;
    }

    public synchronized boolean isValid() {
        return !this.mIsClosed;
    }

    @VisibleForTesting
    public synchronized SharedReference<T> getUnderlyingReferenceTestOnly() {
        return this.mSharedReference;
    }

    public int getValueHash() {
        return this.isValid() ? System.identityHashCode(this.mSharedReference.get()) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CloseableReference closeableReference = this;
        synchronized (closeableReference) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
        }
        this.mSharedReference.deleteReference();
    }

    public static boolean isValid(@Nullable CloseableReference<?> ref) {
        return ref != null && ref.isValid();
    }

    @Nullable
    public static <T> CloseableReference<T> cloneOrNull(@Nullable CloseableReference<T> ref) {
        return ref != null ? ref.cloneOrNull() : null;
    }

    public static <T> List<CloseableReference<T>> cloneOrNull(@PropagatesNullable Collection<CloseableReference<T>> refs) {
        if (refs == null) {
            return null;
        }
        ArrayList<CloseableReference<T>> ret = new ArrayList<CloseableReference<T>>(refs.size());
        for (CloseableReference<T> ref : refs) {
            ret.add(CloseableReference.cloneOrNull(ref));
        }
        return ret;
    }

    public static void closeSafely(@Nullable CloseableReference<?> ref) {
        if (ref != null) {
            ref.close();
        }
    }

    public static void closeSafely(@Nullable Iterable<? extends CloseableReference<?>> references) {
        if (references != null) {
            for (CloseableReference<?> ref : references) {
                CloseableReference.closeSafely(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            CloseableReference closeableReference = this;
            synchronized (closeableReference) {
                if (this.mIsClosed) {
                    return;
                }
            }
            FLog.w(TAG, "Finalized without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(this.mSharedReference), this.mSharedReference.get().getClass().getName());
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }
}

