/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.pruner;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import java.util.Collection;
import java.util.List;
import org.finos.rune.mapper.processor.pruner.PruningStrategy;

public class PreSerializationPruner
implements BuilderProcessor {
    private final List<PruningStrategy> pruningStrategies;

    public PreSerializationPruner(PruningStrategy ... pruningStrategies) {
        this.pruningStrategies = Lists.newArrayList((Object[])pruningStrategies);
    }

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
        if (builder != null) {
            for (PruningStrategy pruningStrategy : this.pruningStrategies) {
                pruningStrategy.prune(builder);
            }
            return true;
        }
        return false;
    }

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
        if (builders == null) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < builders.size(); ++i) {
            RosettaModelObjectBuilder builder = builders.get(i);
            path = path.withIndex(i);
            result &= this.processRosetta(path, rosettaType, builder, parent, metas);
        }
        return result;
    }

    public <T> void processBasic(RosettaPath path, Class<T> rosettaType, T instance, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
    }

    public <T> void processBasic(RosettaPath path, Class<T> rosettaType, Collection<? extends T> instances, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
        if (instances == null) {
            return;
        }
        for (T instance : instances) {
            this.processBasic(path, rosettaType, instance, parent, metas);
        }
    }

    public BuilderProcessor.Report report() {
        throw new UnsupportedOperationException("PreSerializationPruner report not supported");
    }
}

