/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.variance.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.CalculatedAmount;
import fpml.consolidated.eq.shared.DividendsModel;
import fpml.consolidated.eq.shared.Variance;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.AdjustableRelativeOrPeriodicDates;
import fpml.consolidated.variance.swaps.meta.VarianceAmountMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VarianceAmount", builder=VarianceAmountBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VarianceAmount", model="fpml", builder=VarianceAmountBuilderImpl.class, version="1.2.2")
public interface VarianceAmount
extends CalculatedAmount {
    public static final VarianceAmountMeta metaData = new VarianceAmountMeta();

    public Variance getVariance();

    @Override
    public VarianceAmount build();

    @Override
    public VarianceAmountBuilder toBuilder();

    public static VarianceAmountBuilder builder() {
        return new VarianceAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends VarianceAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VarianceAmount> getType() {
        return VarianceAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.class, this.getCalculationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.class, this.getObservationStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.class, this.getDividendsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("variance"), processor, Variance.class, this.getVariance(), new AttributeMeta[0]);
    }

    public static class VarianceAmountBuilderImpl
    extends CalculatedAmount.CalculatedAmountBuilderImpl
    implements VarianceAmountBuilder {
        protected Variance.VarianceBuilder variance;

        @Override
        @RosettaAttribute(value="variance", isRequired=true)
        @RuneAttribute(value="variance", isRequired=true)
        public Variance.VarianceBuilder getVariance() {
            return this.variance;
        }

        @Override
        public Variance.VarianceBuilder getOrCreateVariance() {
            Variance.VarianceBuilder result = this.variance != null ? this.variance : (this.variance = Variance.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDates")
        @RuneAttribute(value="calculationDates")
        public VarianceAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates _calculationDates) {
            this.calculationDates = _calculationDates == null ? null : _calculationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationStartDate")
        @RuneAttribute(value="observationStartDate")
        public VarianceAmountBuilder setObservationStartDate(AdjustableOrRelativeDate _observationStartDate) {
            this.observationStartDate = _observationStartDate == null ? null : _observationStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendsModel", isRequired=true)
        @RuneAttribute(value="dividendsModel", isRequired=true)
        public VarianceAmountBuilder setDividendsModel(DividendsModel _dividendsModel) {
            this.dividendsModel = _dividendsModel == null ? null : _dividendsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="variance", isRequired=true)
        @RuneAttribute(value="variance", isRequired=true)
        public VarianceAmountBuilder setVariance(Variance _variance) {
            this.variance = _variance == null ? null : _variance.toBuilder();
            return this;
        }

        @Override
        public VarianceAmount build() {
            return new VarianceAmountImpl(this);
        }

        @Override
        public VarianceAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public VarianceAmountBuilder prune() {
            super.prune();
            if (this.variance != null && !this.variance.prune().hasData()) {
                this.variance = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getVariance() != null && this.getVariance().hasData();
        }

        @Override
        public VarianceAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VarianceAmountBuilder o = (VarianceAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVariance(), (RosettaModelObjectBuilder)o.getVariance(), this::setVariance);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceAmount _that = (VarianceAmount)this.getType().cast(o);
            return Objects.equals(this.variance, _that.getVariance());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.variance != null ? this.variance.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceAmountBuilder {variance=" + String.valueOf(this.variance) + "} " + super.toString();
        }
    }

    public static interface VarianceAmountBuilder
    extends VarianceAmount,
    CalculatedAmount.CalculatedAmountBuilder {
        public Variance.VarianceBuilder getOrCreateVariance();

        @Override
        public Variance.VarianceBuilder getVariance();

        @Override
        public VarianceAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates var1);

        @Override
        public VarianceAmountBuilder setObservationStartDate(AdjustableOrRelativeDate var1);

        @Override
        public VarianceAmountBuilder setDividendsModel(DividendsModel var1);

        public VarianceAmountBuilder setVariance(Variance var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, (RosettaModelObjectBuilder)this.getCalculationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getObservationStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.DividendsModelBuilder.class, (RosettaModelObjectBuilder)this.getDividendsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("variance"), processor, Variance.VarianceBuilder.class, this.getVariance(), new AttributeMeta[0]);
        }

        @Override
        public VarianceAmountBuilder prune();
    }

    public static class VarianceAmountImpl
    extends CalculatedAmount.CalculatedAmountImpl
    implements VarianceAmount {
        private final Variance variance;

        protected VarianceAmountImpl(VarianceAmountBuilder builder) {
            super(builder);
            this.variance = Optional.ofNullable(builder.getVariance()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="variance", isRequired=true)
        @RuneAttribute(value="variance", isRequired=true)
        public Variance getVariance() {
            return this.variance;
        }

        @Override
        public VarianceAmount build() {
            return this;
        }

        @Override
        public VarianceAmountBuilder toBuilder() {
            VarianceAmountBuilder builder = VarianceAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VarianceAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVariance()).ifPresent(builder::setVariance);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceAmount _that = (VarianceAmount)this.getType().cast(o);
            return Objects.equals(this.variance, _that.getVariance());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.variance != null ? this.variance.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceAmount {variance=" + String.valueOf(this.variance) + "} " + super.toString();
        }
    }
}

