/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ReportingRegimeIdentifier;
import fpml.consolidated.doc.TradeCategory;
import fpml.consolidated.shared.AccountReference;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.ProductType;
import fpml.consolidated.valuation.fpmlreporting.QueryPortfolio;
import fpml.consolidated.valuation.fpmlreporting.ReportContentsSequence;
import fpml.consolidated.valuation.fpmlreporting.meta.ReportContentsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportContents", builder=ReportContentsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ReportContents", model="fpml", builder=ReportContentsBuilderImpl.class, version="1.2.2")
public interface ReportContents
extends RosettaModelObject {
    public static final ReportContentsMeta metaData = new ReportContentsMeta();

    public PartyReference getPartyReference();

    public AccountReference getAccountReference();

    public List<? extends TradeCategory> getCategory();

    public ReportContentsSequence getReportContentsSequence();

    public List<? extends ProductType> getProductType();

    public QueryPortfolio getQueryPortfolio();

    public List<? extends ReportingRegimeIdentifier> getReportingRegime();

    public ReportContents build();

    public ReportContentsBuilder toBuilder();

    public static ReportContentsBuilder builder() {
        return new ReportContentsBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportContents> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportContents> getType() {
        return ReportContents.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountReference"), processor, AccountReference.class, this.getAccountReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("category"), processor, TradeCategory.class, this.getCategory(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportContentsSequence"), processor, ReportContentsSequence.class, this.getReportContentsSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productType"), processor, ProductType.class, this.getProductType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("queryPortfolio"), processor, QueryPortfolio.class, this.getQueryPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegimeIdentifier.class, this.getReportingRegime(), new AttributeMeta[0]);
    }

    public static class ReportContentsBuilderImpl
    implements ReportContentsBuilder {
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected AccountReference.AccountReferenceBuilder accountReference;
        protected List<TradeCategory.TradeCategoryBuilder> category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
        protected ReportContentsSequence.ReportContentsSequenceBuilder reportContentsSequence;
        protected List<ProductType.ProductTypeBuilder> productType = new ArrayList<ProductType.ProductTypeBuilder>();
        protected QueryPortfolio.QueryPortfolioBuilder queryPortfolio;
        protected List<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> reportingRegime = new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public AccountReference.AccountReferenceBuilder getAccountReference() {
            return this.accountReference;
        }

        @Override
        public AccountReference.AccountReferenceBuilder getOrCreateAccountReference() {
            AccountReference.AccountReferenceBuilder result = this.accountReference != null ? this.accountReference : (this.accountReference = AccountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory() {
            return this.category;
        }

        @Override
        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int index) {
            if (this.category == null) {
                this.category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
            }
            return (TradeCategory.TradeCategoryBuilder)this.getIndex(this.category, index, () -> {
                TradeCategory.TradeCategoryBuilder newCategory = TradeCategory.builder();
                return newCategory;
            });
        }

        @Override
        @RosettaAttribute(value="reportContentsSequence")
        @RuneAttribute(value="reportContentsSequence")
        public ReportContentsSequence.ReportContentsSequenceBuilder getReportContentsSequence() {
            return this.reportContentsSequence;
        }

        @Override
        public ReportContentsSequence.ReportContentsSequenceBuilder getOrCreateReportContentsSequence() {
            ReportContentsSequence.ReportContentsSequenceBuilder result = this.reportContentsSequence != null ? this.reportContentsSequence : (this.reportContentsSequence = ReportContentsSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public List<? extends ProductType.ProductTypeBuilder> getProductType() {
            return this.productType;
        }

        @Override
        public ProductType.ProductTypeBuilder getOrCreateProductType(int index) {
            if (this.productType == null) {
                this.productType = new ArrayList<ProductType.ProductTypeBuilder>();
            }
            return (ProductType.ProductTypeBuilder)this.getIndex(this.productType, index, () -> {
                ProductType.ProductTypeBuilder newProductType = ProductType.builder();
                return newProductType;
            });
        }

        @Override
        @RosettaAttribute(value="queryPortfolio")
        @RuneAttribute(value="queryPortfolio")
        public QueryPortfolio.QueryPortfolioBuilder getQueryPortfolio() {
            return this.queryPortfolio;
        }

        @Override
        public QueryPortfolio.QueryPortfolioBuilder getOrCreateQueryPortfolio() {
            QueryPortfolio.QueryPortfolioBuilder result = this.queryPortfolio != null ? this.queryPortfolio : (this.queryPortfolio = QueryPortfolio.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        public ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder getOrCreateReportingRegime(int index) {
            if (this.reportingRegime == null) {
                this.reportingRegime = new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>();
            }
            return (ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder)this.getIndex(this.reportingRegime, index, () -> {
                ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder newReportingRegime = ReportingRegimeIdentifier.builder();
                return newReportingRegime;
            });
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public ReportContentsBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public ReportContentsBuilder setAccountReference(AccountReference _accountReference) {
            this.accountReference = _accountReference == null ? null : _accountReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public ReportContentsBuilder addCategory(TradeCategory _category) {
            if (_category != null) {
                this.category.add(_category.toBuilder());
            }
            return this;
        }

        @Override
        public ReportContentsBuilder addCategory(TradeCategory _category, int idx) {
            this.getIndex(this.category, idx, () -> _category.toBuilder());
            return this;
        }

        @Override
        public ReportContentsBuilder addCategory(List<? extends TradeCategory> categorys) {
            if (categorys != null) {
                for (TradeCategory tradeCategory : categorys) {
                    this.category.add(tradeCategory.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="category")
        public ReportContentsBuilder setCategory(List<? extends TradeCategory> categorys) {
            this.category = categorys == null ? new ArrayList<TradeCategory.TradeCategoryBuilder>() : (List)categorys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportContentsSequence")
        @RuneAttribute(value="reportContentsSequence")
        public ReportContentsBuilder setReportContentsSequence(ReportContentsSequence _reportContentsSequence) {
            this.reportContentsSequence = _reportContentsSequence == null ? null : _reportContentsSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public ReportContentsBuilder addProductType(ProductType _productType) {
            if (_productType != null) {
                this.productType.add(_productType.toBuilder());
            }
            return this;
        }

        @Override
        public ReportContentsBuilder addProductType(ProductType _productType, int idx) {
            this.getIndex(this.productType, idx, () -> _productType.toBuilder());
            return this;
        }

        @Override
        public ReportContentsBuilder addProductType(List<? extends ProductType> productTypes) {
            if (productTypes != null) {
                for (ProductType productType : productTypes) {
                    this.productType.add(productType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productType")
        public ReportContentsBuilder setProductType(List<? extends ProductType> productTypes) {
            this.productType = productTypes == null ? new ArrayList<ProductType.ProductTypeBuilder>() : (List)productTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="queryPortfolio")
        @RuneAttribute(value="queryPortfolio")
        public ReportContentsBuilder setQueryPortfolio(QueryPortfolio _queryPortfolio) {
            this.queryPortfolio = _queryPortfolio == null ? null : _queryPortfolio.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public ReportContentsBuilder addReportingRegime(ReportingRegimeIdentifier _reportingRegime) {
            if (_reportingRegime != null) {
                this.reportingRegime.add(_reportingRegime.toBuilder());
            }
            return this;
        }

        @Override
        public ReportContentsBuilder addReportingRegime(ReportingRegimeIdentifier _reportingRegime, int idx) {
            this.getIndex(this.reportingRegime, idx, () -> _reportingRegime.toBuilder());
            return this;
        }

        @Override
        public ReportContentsBuilder addReportingRegime(List<? extends ReportingRegimeIdentifier> reportingRegimes) {
            if (reportingRegimes != null) {
                for (ReportingRegimeIdentifier reportingRegimeIdentifier : reportingRegimes) {
                    this.reportingRegime.add(reportingRegimeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingRegime")
        public ReportContentsBuilder setReportingRegime(List<? extends ReportingRegimeIdentifier> reportingRegimes) {
            this.reportingRegime = reportingRegimes == null ? new ArrayList<ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder>() : (List)reportingRegimes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReportContents build() {
            return new ReportContentsImpl(this);
        }

        @Override
        public ReportContentsBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportContentsBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            if (this.accountReference != null && !this.accountReference.prune().hasData()) {
                this.accountReference = null;
            }
            this.category = this.category.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.reportContentsSequence != null && !this.reportContentsSequence.prune().hasData()) {
                this.reportContentsSequence = null;
            }
            this.productType = this.productType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.queryPortfolio != null && !this.queryPortfolio.prune().hasData()) {
                this.queryPortfolio = null;
            }
            this.reportingRegime = this.reportingRegime.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getAccountReference() != null && this.getAccountReference().hasData()) {
                return true;
            }
            if (this.getCategory() != null && this.getCategory().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReportContentsSequence() != null && this.getReportContentsSequence().hasData()) {
                return true;
            }
            if (this.getProductType() != null && this.getProductType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getQueryPortfolio() != null && this.getQueryPortfolio().hasData()) {
                return true;
            }
            return this.getReportingRegime() != null && this.getReportingRegime().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReportContentsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportContentsBuilder o = (ReportContentsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountReference(), (RosettaModelObjectBuilder)o.getAccountReference(), this::setAccountReference);
            merger.mergeRosetta(this.getCategory(), o.getCategory(), this::getOrCreateCategory);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportContentsSequence(), (RosettaModelObjectBuilder)o.getReportContentsSequence(), this::setReportContentsSequence);
            merger.mergeRosetta(this.getProductType(), o.getProductType(), this::getOrCreateProductType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQueryPortfolio(), (RosettaModelObjectBuilder)o.getQueryPortfolio(), this::setQueryPortfolio);
            merger.mergeRosetta(this.getReportingRegime(), o.getReportingRegime(), this::getOrCreateReportingRegime);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportContents _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.accountReference, _that.getAccountReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.reportContentsSequence, _that.getReportContentsSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            if (!Objects.equals(this.queryPortfolio, _that.getQueryPortfolio())) {
                return false;
            }
            return ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.reportContentsSequence != null ? this.reportContentsSequence.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.queryPortfolio != null ? this.queryPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportContentsBuilder {partyReference=" + String.valueOf(this.partyReference) + ", accountReference=" + String.valueOf(this.accountReference) + ", category=" + String.valueOf(this.category) + ", reportContentsSequence=" + String.valueOf(this.reportContentsSequence) + ", productType=" + String.valueOf(this.productType) + ", queryPortfolio=" + String.valueOf(this.queryPortfolio) + ", reportingRegime=" + String.valueOf(this.reportingRegime) + "}";
        }
    }

    public static interface ReportContentsBuilder
    extends ReportContents,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public AccountReference.AccountReferenceBuilder getOrCreateAccountReference();

        @Override
        public AccountReference.AccountReferenceBuilder getAccountReference();

        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int var1);

        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory();

        public ReportContentsSequence.ReportContentsSequenceBuilder getOrCreateReportContentsSequence();

        @Override
        public ReportContentsSequence.ReportContentsSequenceBuilder getReportContentsSequence();

        public ProductType.ProductTypeBuilder getOrCreateProductType(int var1);

        public List<? extends ProductType.ProductTypeBuilder> getProductType();

        public QueryPortfolio.QueryPortfolioBuilder getOrCreateQueryPortfolio();

        @Override
        public QueryPortfolio.QueryPortfolioBuilder getQueryPortfolio();

        public ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder getOrCreateReportingRegime(int var1);

        public List<? extends ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder> getReportingRegime();

        public ReportContentsBuilder setPartyReference(PartyReference var1);

        public ReportContentsBuilder setAccountReference(AccountReference var1);

        public ReportContentsBuilder addCategory(TradeCategory var1);

        public ReportContentsBuilder addCategory(TradeCategory var1, int var2);

        public ReportContentsBuilder addCategory(List<? extends TradeCategory> var1);

        public ReportContentsBuilder setCategory(List<? extends TradeCategory> var1);

        public ReportContentsBuilder setReportContentsSequence(ReportContentsSequence var1);

        public ReportContentsBuilder addProductType(ProductType var1);

        public ReportContentsBuilder addProductType(ProductType var1, int var2);

        public ReportContentsBuilder addProductType(List<? extends ProductType> var1);

        public ReportContentsBuilder setProductType(List<? extends ProductType> var1);

        public ReportContentsBuilder setQueryPortfolio(QueryPortfolio var1);

        public ReportContentsBuilder addReportingRegime(ReportingRegimeIdentifier var1);

        public ReportContentsBuilder addReportingRegime(ReportingRegimeIdentifier var1, int var2);

        public ReportContentsBuilder addReportingRegime(List<? extends ReportingRegimeIdentifier> var1);

        public ReportContentsBuilder setReportingRegime(List<? extends ReportingRegimeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountReference"), processor, AccountReference.AccountReferenceBuilder.class, this.getAccountReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("category"), processor, TradeCategory.TradeCategoryBuilder.class, this.getCategory(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportContentsSequence"), processor, ReportContentsSequence.ReportContentsSequenceBuilder.class, this.getReportContentsSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productType"), processor, ProductType.ProductTypeBuilder.class, this.getProductType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("queryPortfolio"), processor, QueryPortfolio.QueryPortfolioBuilder.class, this.getQueryPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegimeIdentifier.ReportingRegimeIdentifierBuilder.class, this.getReportingRegime(), new AttributeMeta[0]);
        }

        public ReportContentsBuilder prune();
    }

    public static class ReportContentsImpl
    implements ReportContents {
        private final PartyReference partyReference;
        private final AccountReference accountReference;
        private final List<? extends TradeCategory> category;
        private final ReportContentsSequence reportContentsSequence;
        private final List<? extends ProductType> productType;
        private final QueryPortfolio queryPortfolio;
        private final List<? extends ReportingRegimeIdentifier> reportingRegime;

        protected ReportContentsImpl(ReportContentsBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.accountReference = Optional.ofNullable(builder.getAccountReference()).map(f -> f.build()).orElse(null);
            this.category = Optional.ofNullable(builder.getCategory()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reportContentsSequence = Optional.ofNullable(builder.getReportContentsSequence()).map(f -> f.build()).orElse(null);
            this.productType = Optional.ofNullable(builder.getProductType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.queryPortfolio = Optional.ofNullable(builder.getQueryPortfolio()).map(f -> f.build()).orElse(null);
            this.reportingRegime = Optional.ofNullable(builder.getReportingRegime()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyReference")
        @RuneAttribute(value="partyReference")
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="accountReference")
        @RuneAttribute(value="accountReference")
        public AccountReference getAccountReference() {
            return this.accountReference;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory> getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="reportContentsSequence")
        @RuneAttribute(value="reportContentsSequence")
        public ReportContentsSequence getReportContentsSequence() {
            return this.reportContentsSequence;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public List<? extends ProductType> getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="queryPortfolio")
        @RuneAttribute(value="queryPortfolio")
        public QueryPortfolio getQueryPortfolio() {
            return this.queryPortfolio;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegimeIdentifier> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        public ReportContents build() {
            return this;
        }

        @Override
        public ReportContentsBuilder toBuilder() {
            ReportContentsBuilder builder = ReportContents.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportContentsBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getAccountReference()).ifPresent(builder::setAccountReference);
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getReportContentsSequence()).ifPresent(builder::setReportContentsSequence);
            Optional.ofNullable(this.getProductType()).ifPresent(builder::setProductType);
            Optional.ofNullable(this.getQueryPortfolio()).ifPresent(builder::setQueryPortfolio);
            Optional.ofNullable(this.getReportingRegime()).ifPresent(builder::setReportingRegime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportContents _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.accountReference, _that.getAccountReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.reportContentsSequence, _that.getReportContentsSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            if (!Objects.equals(this.queryPortfolio, _that.getQueryPortfolio())) {
                return false;
            }
            return ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.accountReference != null ? this.accountReference.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.reportContentsSequence != null ? this.reportContentsSequence.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.queryPortfolio != null ? this.queryPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportContents {partyReference=" + String.valueOf(this.partyReference) + ", accountReference=" + String.valueOf(this.accountReference) + ", category=" + String.valueOf(this.category) + ", reportContentsSequence=" + String.valueOf(this.reportContentsSequence) + ", productType=" + String.valueOf(this.productType) + ", queryPortfolio=" + String.valueOf(this.queryPortfolio) + ", reportingRegime=" + String.valueOf(this.reportingRegime) + "}";
        }
    }
}

