/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.Party;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PartyChoice")
@ImplementedBy(value=Default.class)
public interface PartyChoice
extends Validator<Party> {
    public static final String NAME = "PartyChoice";
    public static final String DEFINITION = "required choice partyModel, partySequence";

    public static class NoOp
    implements PartyChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Party party) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PartyChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Party party) {
            ComparisonResult result = this.executeDataRule(party);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PartyChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Party", (RosettaPath)path, (String)PartyChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PartyChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Party", (RosettaPath)path, (String)PartyChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Party party) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)party), Arrays.asList("partyModel", "partySequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

