/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.Step;
import fpml.consolidated.shared.meta.ScheduleMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Schedule", builder=ScheduleBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Schedule", model="fpml", builder=ScheduleBuilderImpl.class, version="1.2.2")
public interface Schedule
extends RosettaModelObject {
    public static final ScheduleMeta metaData = new ScheduleMeta();

    public BigDecimal getInitialValue();

    public List<? extends Step> getStep();

    public String getId();

    public Schedule build();

    public ScheduleBuilder toBuilder();

    public static ScheduleBuilder builder() {
        return new ScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends Schedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Schedule> getType() {
        return Schedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("step"), processor, Step.class, this.getStep(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ScheduleBuilderImpl
    implements ScheduleBuilder {
        protected BigDecimal initialValue;
        protected List<Step.StepBuilder> step = new ArrayList<Step.StepBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public BigDecimal getInitialValue() {
            return this.initialValue;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends Step.StepBuilder> getStep() {
            return this.step;
        }

        @Override
        public Step.StepBuilder getOrCreateStep(int index) {
            if (this.step == null) {
                this.step = new ArrayList<Step.StepBuilder>();
            }
            return (Step.StepBuilder)this.getIndex(this.step, index, () -> {
                Step.StepBuilder newStep = Step.builder();
                return newStep;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public ScheduleBuilder setInitialValue(BigDecimal _initialValue) {
            this.initialValue = _initialValue == null ? null : _initialValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public ScheduleBuilder addStep(Step _step) {
            if (_step != null) {
                this.step.add(_step.toBuilder());
            }
            return this;
        }

        @Override
        public ScheduleBuilder addStep(Step _step, int idx) {
            this.getIndex(this.step, idx, () -> _step.toBuilder());
            return this;
        }

        @Override
        public ScheduleBuilder addStep(List<? extends Step> steps) {
            if (steps != null) {
                for (Step step : steps) {
                    this.step.add(step.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="step")
        public ScheduleBuilder setStep(List<? extends Step> steps) {
            this.step = steps == null ? new ArrayList<Step.StepBuilder>() : (List)steps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ScheduleBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Schedule build() {
            return new ScheduleImpl(this);
        }

        @Override
        public ScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public ScheduleBuilder prune() {
            this.step = this.step.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getInitialValue() != null) {
                return true;
            }
            if (this.getStep() != null && this.getStep().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public ScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ScheduleBuilder o = (ScheduleBuilder)other;
            merger.mergeRosetta(this.getStep(), o.getStep(), this::getOrCreateStep);
            merger.mergeBasic((Object)this.getInitialValue(), (Object)o.getInitialValue(), this::setInitialValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Schedule _that = this.getType().cast(o);
            if (!Objects.equals(this.initialValue, _that.getInitialValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.step, _that.getStep())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialValue != null ? this.initialValue.hashCode() : 0);
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ScheduleBuilder {initialValue=" + String.valueOf(this.initialValue) + ", step=" + String.valueOf(this.step) + ", id=" + this.id + "}";
        }
    }

    public static interface ScheduleBuilder
    extends Schedule,
    RosettaModelObjectBuilder {
        public Step.StepBuilder getOrCreateStep(int var1);

        public List<? extends Step.StepBuilder> getStep();

        public ScheduleBuilder setInitialValue(BigDecimal var1);

        public ScheduleBuilder addStep(Step var1);

        public ScheduleBuilder addStep(Step var1, int var2);

        public ScheduleBuilder addStep(List<? extends Step> var1);

        public ScheduleBuilder setStep(List<? extends Step> var1);

        public ScheduleBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("step"), processor, Step.StepBuilder.class, this.getStep(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ScheduleBuilder prune();
    }

    public static class ScheduleImpl
    implements Schedule {
        private final BigDecimal initialValue;
        private final List<? extends Step> step;
        private final String id;

        protected ScheduleImpl(ScheduleBuilder builder) {
            this.initialValue = builder.getInitialValue();
            this.step = Optional.ofNullable(builder.getStep()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public BigDecimal getInitialValue() {
            return this.initialValue;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends Step> getStep() {
            return this.step;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public Schedule build() {
            return this;
        }

        @Override
        public ScheduleBuilder toBuilder() {
            ScheduleBuilder builder = Schedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ScheduleBuilder builder) {
            Optional.ofNullable(this.getInitialValue()).ifPresent(builder::setInitialValue);
            Optional.ofNullable(this.getStep()).ifPresent(builder::setStep);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Schedule _that = this.getType().cast(o);
            if (!Objects.equals(this.initialValue, _that.getInitialValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.step, _that.getStep())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialValue != null ? this.initialValue.hashCode() : 0);
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Schedule {initialValue=" + String.valueOf(this.initialValue) + ", step=" + String.valueOf(this.step) + ", id=" + this.id + "}";
        }
    }
}

