/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.meta.PaymentDiscountingModelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PaymentDiscountingModel", builder=PaymentDiscountingModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PaymentDiscountingModel", model="fpml", builder=PaymentDiscountingModelBuilderImpl.class, version="1.2.2")
public interface PaymentDiscountingModel
extends RosettaModelObject {
    public static final PaymentDiscountingModelMeta metaData = new PaymentDiscountingModelMeta();

    public BigDecimal getDiscountFactor();

    public Money getPresentValueAmount();

    public PaymentDiscountingModel build();

    public PaymentDiscountingModelBuilder toBuilder();

    public static PaymentDiscountingModelBuilder builder() {
        return new PaymentDiscountingModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentDiscountingModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentDiscountingModel> getType() {
        return PaymentDiscountingModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
    }

    public static class PaymentDiscountingModelBuilderImpl
    implements PaymentDiscountingModelBuilder {
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder presentValueAmount;

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PaymentDiscountingModelBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public PaymentDiscountingModelBuilder setPresentValueAmount(Money _presentValueAmount) {
            this.presentValueAmount = _presentValueAmount == null ? null : _presentValueAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentDiscountingModel build() {
            return new PaymentDiscountingModelImpl(this);
        }

        @Override
        public PaymentDiscountingModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDiscountingModelBuilder prune() {
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDiscountFactor() != null) {
                return true;
            }
            return this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData();
        }

        public PaymentDiscountingModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDiscountingModelBuilder o = (PaymentDiscountingModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDiscountingModel _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            return Objects.equals(this.presentValueAmount, _that.getPresentValueAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDiscountingModelBuilder {discountFactor=" + String.valueOf(this.discountFactor) + ", presentValueAmount=" + String.valueOf(this.presentValueAmount) + "}";
        }
    }

    public static interface PaymentDiscountingModelBuilder
    extends PaymentDiscountingModel,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public PaymentDiscountingModelBuilder setDiscountFactor(BigDecimal var1);

        public PaymentDiscountingModelBuilder setPresentValueAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        }

        public PaymentDiscountingModelBuilder prune();
    }

    public static class PaymentDiscountingModelImpl
    implements PaymentDiscountingModel {
        private final BigDecimal discountFactor;
        private final Money presentValueAmount;

        protected PaymentDiscountingModelImpl(PaymentDiscountingModelBuilder builder) {
            this.discountFactor = builder.getDiscountFactor();
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public PaymentDiscountingModel build() {
            return this;
        }

        @Override
        public PaymentDiscountingModelBuilder toBuilder() {
            PaymentDiscountingModelBuilder builder = PaymentDiscountingModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDiscountingModelBuilder builder) {
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDiscountingModel _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            return Objects.equals(this.presentValueAmount, _that.getPresentValueAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDiscountingModel {discountFactor=" + String.valueOf(this.discountFactor) + ", presentValueAmount=" + String.valueOf(this.presentValueAmount) + "}";
        }
    }
}

