/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.CountryCode;
import fpml.consolidated.shared.CreditRating;
import fpml.consolidated.shared.GoverningLaw;
import fpml.consolidated.shared.IndustryClassification;
import fpml.consolidated.shared.OrganizationType;
import fpml.consolidated.shared.Region;
import fpml.consolidated.shared.meta.PartyInformationModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyInformationModel", builder=PartyInformationModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PartyInformationModel", model="fpml", builder=PartyInformationModelBuilderImpl.class, version="1.2.2")
public interface PartyInformationModel
extends RosettaModelObject {
    public static final PartyInformationModelMeta metaData = new PartyInformationModelMeta();

    public List<? extends IndustryClassification> getClassification();

    public List<? extends CreditRating> getCreditRating();

    public CountryCode getCountry();

    public List<? extends Region> getRegion();

    public List<? extends GoverningLaw> getJurisdiction();

    public List<? extends OrganizationType> getOrganizationType();

    public PartyInformationModel build();

    public PartyInformationModelBuilder toBuilder();

    public static PartyInformationModelBuilder builder() {
        return new PartyInformationModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyInformationModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyInformationModel> getType() {
        return PartyInformationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("classification"), processor, IndustryClassification.class, this.getClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditRating"), processor, CreditRating.class, this.getCreditRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("country"), processor, CountryCode.class, this.getCountry(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("region"), processor, Region.class, this.getRegion(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("jurisdiction"), processor, GoverningLaw.class, this.getJurisdiction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("organizationType"), processor, OrganizationType.class, this.getOrganizationType(), new AttributeMeta[0]);
    }

    public static class PartyInformationModelBuilderImpl
    implements PartyInformationModelBuilder {
        protected List<IndustryClassification.IndustryClassificationBuilder> classification = new ArrayList<IndustryClassification.IndustryClassificationBuilder>();
        protected List<CreditRating.CreditRatingBuilder> creditRating = new ArrayList<CreditRating.CreditRatingBuilder>();
        protected CountryCode.CountryCodeBuilder country;
        protected List<Region.RegionBuilder> region = new ArrayList<Region.RegionBuilder>();
        protected List<GoverningLaw.GoverningLawBuilder> jurisdiction = new ArrayList<GoverningLaw.GoverningLawBuilder>();
        protected List<OrganizationType.OrganizationTypeBuilder> organizationType = new ArrayList<OrganizationType.OrganizationTypeBuilder>();

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public List<? extends IndustryClassification.IndustryClassificationBuilder> getClassification() {
            return this.classification;
        }

        @Override
        public IndustryClassification.IndustryClassificationBuilder getOrCreateClassification(int index) {
            if (this.classification == null) {
                this.classification = new ArrayList<IndustryClassification.IndustryClassificationBuilder>();
            }
            return (IndustryClassification.IndustryClassificationBuilder)this.getIndex(this.classification, index, () -> {
                IndustryClassification.IndustryClassificationBuilder newClassification = IndustryClassification.builder();
                return newClassification;
            });
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public List<? extends CreditRating.CreditRatingBuilder> getCreditRating() {
            return this.creditRating;
        }

        @Override
        public CreditRating.CreditRatingBuilder getOrCreateCreditRating(int index) {
            if (this.creditRating == null) {
                this.creditRating = new ArrayList<CreditRating.CreditRatingBuilder>();
            }
            return (CreditRating.CreditRatingBuilder)this.getIndex(this.creditRating, index, () -> {
                CreditRating.CreditRatingBuilder newCreditRating = CreditRating.builder();
                return newCreditRating;
            });
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode.CountryCodeBuilder getCountry() {
            return this.country;
        }

        @Override
        public CountryCode.CountryCodeBuilder getOrCreateCountry() {
            CountryCode.CountryCodeBuilder result = this.country != null ? this.country : (this.country = CountryCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="region")
        @RuneAttribute(value="region")
        public List<? extends Region.RegionBuilder> getRegion() {
            return this.region;
        }

        @Override
        public Region.RegionBuilder getOrCreateRegion(int index) {
            if (this.region == null) {
                this.region = new ArrayList<Region.RegionBuilder>();
            }
            return (Region.RegionBuilder)this.getIndex(this.region, index, () -> {
                Region.RegionBuilder newRegion = Region.builder();
                return newRegion;
            });
        }

        @Override
        @RosettaAttribute(value="jurisdiction")
        @RuneAttribute(value="jurisdiction")
        public List<? extends GoverningLaw.GoverningLawBuilder> getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        public GoverningLaw.GoverningLawBuilder getOrCreateJurisdiction(int index) {
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<GoverningLaw.GoverningLawBuilder>();
            }
            return (GoverningLaw.GoverningLawBuilder)this.getIndex(this.jurisdiction, index, () -> {
                GoverningLaw.GoverningLawBuilder newJurisdiction = GoverningLaw.builder();
                return newJurisdiction;
            });
        }

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public List<? extends OrganizationType.OrganizationTypeBuilder> getOrganizationType() {
            return this.organizationType;
        }

        @Override
        public OrganizationType.OrganizationTypeBuilder getOrCreateOrganizationType(int index) {
            if (this.organizationType == null) {
                this.organizationType = new ArrayList<OrganizationType.OrganizationTypeBuilder>();
            }
            return (OrganizationType.OrganizationTypeBuilder)this.getIndex(this.organizationType, index, () -> {
                OrganizationType.OrganizationTypeBuilder newOrganizationType = OrganizationType.builder();
                return newOrganizationType;
            });
        }

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public PartyInformationModelBuilder addClassification(IndustryClassification _classification) {
            if (_classification != null) {
                this.classification.add(_classification.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationModelBuilder addClassification(IndustryClassification _classification, int idx) {
            this.getIndex(this.classification, idx, () -> _classification.toBuilder());
            return this;
        }

        @Override
        public PartyInformationModelBuilder addClassification(List<? extends IndustryClassification> classifications) {
            if (classifications != null) {
                for (IndustryClassification industryClassification : classifications) {
                    this.classification.add(industryClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="classification")
        public PartyInformationModelBuilder setClassification(List<? extends IndustryClassification> classifications) {
            this.classification = classifications == null ? new ArrayList<IndustryClassification.IndustryClassificationBuilder>() : (List)classifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public PartyInformationModelBuilder addCreditRating(CreditRating _creditRating) {
            if (_creditRating != null) {
                this.creditRating.add(_creditRating.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationModelBuilder addCreditRating(CreditRating _creditRating, int idx) {
            this.getIndex(this.creditRating, idx, () -> _creditRating.toBuilder());
            return this;
        }

        @Override
        public PartyInformationModelBuilder addCreditRating(List<? extends CreditRating> creditRatings) {
            if (creditRatings != null) {
                for (CreditRating creditRating : creditRatings) {
                    this.creditRating.add(creditRating.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditRating")
        public PartyInformationModelBuilder setCreditRating(List<? extends CreditRating> creditRatings) {
            this.creditRating = creditRatings == null ? new ArrayList<CreditRating.CreditRatingBuilder>() : (List)creditRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public PartyInformationModelBuilder setCountry(CountryCode _country) {
            this.country = _country == null ? null : _country.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="region")
        @RuneAttribute(value="region")
        public PartyInformationModelBuilder addRegion(Region _region) {
            if (_region != null) {
                this.region.add(_region.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationModelBuilder addRegion(Region _region, int idx) {
            this.getIndex(this.region, idx, () -> _region.toBuilder());
            return this;
        }

        @Override
        public PartyInformationModelBuilder addRegion(List<? extends Region> regions) {
            if (regions != null) {
                for (Region region : regions) {
                    this.region.add(region.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="region")
        public PartyInformationModelBuilder setRegion(List<? extends Region> regions) {
            this.region = regions == null ? new ArrayList<Region.RegionBuilder>() : (List)regions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="jurisdiction")
        @RuneAttribute(value="jurisdiction")
        public PartyInformationModelBuilder addJurisdiction(GoverningLaw _jurisdiction) {
            if (_jurisdiction != null) {
                this.jurisdiction.add(_jurisdiction.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationModelBuilder addJurisdiction(GoverningLaw _jurisdiction, int idx) {
            this.getIndex(this.jurisdiction, idx, () -> _jurisdiction.toBuilder());
            return this;
        }

        @Override
        public PartyInformationModelBuilder addJurisdiction(List<? extends GoverningLaw> jurisdictions) {
            if (jurisdictions != null) {
                for (GoverningLaw governingLaw : jurisdictions) {
                    this.jurisdiction.add(governingLaw.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="jurisdiction")
        public PartyInformationModelBuilder setJurisdiction(List<? extends GoverningLaw> jurisdictions) {
            this.jurisdiction = jurisdictions == null ? new ArrayList<GoverningLaw.GoverningLawBuilder>() : (List)jurisdictions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public PartyInformationModelBuilder addOrganizationType(OrganizationType _organizationType) {
            if (_organizationType != null) {
                this.organizationType.add(_organizationType.toBuilder());
            }
            return this;
        }

        @Override
        public PartyInformationModelBuilder addOrganizationType(OrganizationType _organizationType, int idx) {
            this.getIndex(this.organizationType, idx, () -> _organizationType.toBuilder());
            return this;
        }

        @Override
        public PartyInformationModelBuilder addOrganizationType(List<? extends OrganizationType> organizationTypes) {
            if (organizationTypes != null) {
                for (OrganizationType organizationType : organizationTypes) {
                    this.organizationType.add(organizationType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="organizationType")
        public PartyInformationModelBuilder setOrganizationType(List<? extends OrganizationType> organizationTypes) {
            this.organizationType = organizationTypes == null ? new ArrayList<OrganizationType.OrganizationTypeBuilder>() : (List)organizationTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyInformationModel build() {
            return new PartyInformationModelImpl(this);
        }

        @Override
        public PartyInformationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyInformationModelBuilder prune() {
            this.classification = this.classification.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.creditRating = this.creditRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.country != null && !this.country.prune().hasData()) {
                this.country = null;
            }
            this.region = this.region.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.jurisdiction = this.jurisdiction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.organizationType = this.organizationType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getClassification() != null && this.getClassification().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreditRating() != null && this.getCreditRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCountry() != null && this.getCountry().hasData()) {
                return true;
            }
            if (this.getRegion() != null && this.getRegion().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getJurisdiction() != null && this.getJurisdiction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getOrganizationType() != null && this.getOrganizationType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyInformationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyInformationModelBuilder o = (PartyInformationModelBuilder)other;
            merger.mergeRosetta(this.getClassification(), o.getClassification(), this::getOrCreateClassification);
            merger.mergeRosetta(this.getCreditRating(), o.getCreditRating(), this::getOrCreateCreditRating);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCountry(), (RosettaModelObjectBuilder)o.getCountry(), this::setCountry);
            merger.mergeRosetta(this.getRegion(), o.getRegion(), this::getOrCreateRegion);
            merger.mergeRosetta(this.getJurisdiction(), o.getJurisdiction(), this::getOrCreateJurisdiction);
            merger.mergeRosetta(this.getOrganizationType(), o.getOrganizationType(), this::getOrCreateOrganizationType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyInformationModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.classification, _that.getClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditRating, _that.getCreditRating())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            if (!ListEquals.listEquals(this.region, _that.getRegion())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdiction, _that.getJurisdiction())) {
                return false;
            }
            return ListEquals.listEquals(this.organizationType, _that.getOrganizationType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.classification != null ? this.classification.hashCode() : 0);
            _result = 31 * _result + (this.creditRating != null ? this.creditRating.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.region != null ? this.region.hashCode() : 0);
            _result = 31 * _result + (this.jurisdiction != null ? this.jurisdiction.hashCode() : 0);
            _result = 31 * _result + (this.organizationType != null ? this.organizationType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyInformationModelBuilder {classification=" + String.valueOf(this.classification) + ", creditRating=" + String.valueOf(this.creditRating) + ", country=" + String.valueOf(this.country) + ", region=" + String.valueOf(this.region) + ", jurisdiction=" + String.valueOf(this.jurisdiction) + ", organizationType=" + String.valueOf(this.organizationType) + "}";
        }
    }

    public static interface PartyInformationModelBuilder
    extends PartyInformationModel,
    RosettaModelObjectBuilder {
        public IndustryClassification.IndustryClassificationBuilder getOrCreateClassification(int var1);

        public List<? extends IndustryClassification.IndustryClassificationBuilder> getClassification();

        public CreditRating.CreditRatingBuilder getOrCreateCreditRating(int var1);

        public List<? extends CreditRating.CreditRatingBuilder> getCreditRating();

        public CountryCode.CountryCodeBuilder getOrCreateCountry();

        @Override
        public CountryCode.CountryCodeBuilder getCountry();

        public Region.RegionBuilder getOrCreateRegion(int var1);

        public List<? extends Region.RegionBuilder> getRegion();

        public GoverningLaw.GoverningLawBuilder getOrCreateJurisdiction(int var1);

        public List<? extends GoverningLaw.GoverningLawBuilder> getJurisdiction();

        public OrganizationType.OrganizationTypeBuilder getOrCreateOrganizationType(int var1);

        public List<? extends OrganizationType.OrganizationTypeBuilder> getOrganizationType();

        public PartyInformationModelBuilder addClassification(IndustryClassification var1);

        public PartyInformationModelBuilder addClassification(IndustryClassification var1, int var2);

        public PartyInformationModelBuilder addClassification(List<? extends IndustryClassification> var1);

        public PartyInformationModelBuilder setClassification(List<? extends IndustryClassification> var1);

        public PartyInformationModelBuilder addCreditRating(CreditRating var1);

        public PartyInformationModelBuilder addCreditRating(CreditRating var1, int var2);

        public PartyInformationModelBuilder addCreditRating(List<? extends CreditRating> var1);

        public PartyInformationModelBuilder setCreditRating(List<? extends CreditRating> var1);

        public PartyInformationModelBuilder setCountry(CountryCode var1);

        public PartyInformationModelBuilder addRegion(Region var1);

        public PartyInformationModelBuilder addRegion(Region var1, int var2);

        public PartyInformationModelBuilder addRegion(List<? extends Region> var1);

        public PartyInformationModelBuilder setRegion(List<? extends Region> var1);

        public PartyInformationModelBuilder addJurisdiction(GoverningLaw var1);

        public PartyInformationModelBuilder addJurisdiction(GoverningLaw var1, int var2);

        public PartyInformationModelBuilder addJurisdiction(List<? extends GoverningLaw> var1);

        public PartyInformationModelBuilder setJurisdiction(List<? extends GoverningLaw> var1);

        public PartyInformationModelBuilder addOrganizationType(OrganizationType var1);

        public PartyInformationModelBuilder addOrganizationType(OrganizationType var1, int var2);

        public PartyInformationModelBuilder addOrganizationType(List<? extends OrganizationType> var1);

        public PartyInformationModelBuilder setOrganizationType(List<? extends OrganizationType> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("classification"), processor, IndustryClassification.IndustryClassificationBuilder.class, this.getClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditRating"), processor, CreditRating.CreditRatingBuilder.class, this.getCreditRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("country"), processor, CountryCode.CountryCodeBuilder.class, this.getCountry(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("region"), processor, Region.RegionBuilder.class, this.getRegion(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("jurisdiction"), processor, GoverningLaw.GoverningLawBuilder.class, this.getJurisdiction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("organizationType"), processor, OrganizationType.OrganizationTypeBuilder.class, this.getOrganizationType(), new AttributeMeta[0]);
        }

        public PartyInformationModelBuilder prune();
    }

    public static class PartyInformationModelImpl
    implements PartyInformationModel {
        private final List<? extends IndustryClassification> classification;
        private final List<? extends CreditRating> creditRating;
        private final CountryCode country;
        private final List<? extends Region> region;
        private final List<? extends GoverningLaw> jurisdiction;
        private final List<? extends OrganizationType> organizationType;

        protected PartyInformationModelImpl(PartyInformationModelBuilder builder) {
            this.classification = Optional.ofNullable(builder.getClassification()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creditRating = Optional.ofNullable(builder.getCreditRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.country = Optional.ofNullable(builder.getCountry()).map(f -> f.build()).orElse(null);
            this.region = Optional.ofNullable(builder.getRegion()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.jurisdiction = Optional.ofNullable(builder.getJurisdiction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.organizationType = Optional.ofNullable(builder.getOrganizationType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="classification")
        @RuneAttribute(value="classification")
        public List<? extends IndustryClassification> getClassification() {
            return this.classification;
        }

        @Override
        @RosettaAttribute(value="creditRating")
        @RuneAttribute(value="creditRating")
        public List<? extends CreditRating> getCreditRating() {
            return this.creditRating;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode getCountry() {
            return this.country;
        }

        @Override
        @RosettaAttribute(value="region")
        @RuneAttribute(value="region")
        public List<? extends Region> getRegion() {
            return this.region;
        }

        @Override
        @RosettaAttribute(value="jurisdiction")
        @RuneAttribute(value="jurisdiction")
        public List<? extends GoverningLaw> getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public List<? extends OrganizationType> getOrganizationType() {
            return this.organizationType;
        }

        @Override
        public PartyInformationModel build() {
            return this;
        }

        @Override
        public PartyInformationModelBuilder toBuilder() {
            PartyInformationModelBuilder builder = PartyInformationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyInformationModelBuilder builder) {
            Optional.ofNullable(this.getClassification()).ifPresent(builder::setClassification);
            Optional.ofNullable(this.getCreditRating()).ifPresent(builder::setCreditRating);
            Optional.ofNullable(this.getCountry()).ifPresent(builder::setCountry);
            Optional.ofNullable(this.getRegion()).ifPresent(builder::setRegion);
            Optional.ofNullable(this.getJurisdiction()).ifPresent(builder::setJurisdiction);
            Optional.ofNullable(this.getOrganizationType()).ifPresent(builder::setOrganizationType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyInformationModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.classification, _that.getClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditRating, _that.getCreditRating())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            if (!ListEquals.listEquals(this.region, _that.getRegion())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdiction, _that.getJurisdiction())) {
                return false;
            }
            return ListEquals.listEquals(this.organizationType, _that.getOrganizationType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.classification != null ? this.classification.hashCode() : 0);
            _result = 31 * _result + (this.creditRating != null ? this.creditRating.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.region != null ? this.region.hashCode() : 0);
            _result = 31 * _result + (this.jurisdiction != null ? this.jurisdiction.hashCode() : 0);
            _result = 31 * _result + (this.organizationType != null ? this.organizationType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyInformationModel {classification=" + String.valueOf(this.classification) + ", creditRating=" + String.valueOf(this.creditRating) + ", country=" + String.valueOf(this.country) + ", region=" + String.valueOf(this.region) + ", jurisdiction=" + String.valueOf(this.jurisdiction) + ", organizationType=" + String.valueOf(this.organizationType) + "}";
        }
    }
}

