/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.MoneyBase;
import fpml.consolidated.shared.meta.MoneyMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Money", builder=MoneyBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Money", model="fpml", builder=MoneyBuilderImpl.class, version="1.2.2")
public interface Money
extends MoneyBase {
    public static final MoneyMeta metaData = new MoneyMeta();

    public BigDecimal getAmount();

    @Override
    public Money build();

    @Override
    public MoneyBuilder toBuilder();

    public static MoneyBuilder builder() {
        return new MoneyBuilderImpl();
    }

    default public RosettaMetaData<? extends Money> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Money> getType() {
        return Money.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MoneyBuilderImpl
    extends MoneyBase.MoneyBaseBuilderImpl
    implements MoneyBuilder {
        protected BigDecimal amount;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public MoneyBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public MoneyBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        public Money build() {
            return new MoneyImpl(this);
        }

        @Override
        public MoneyBuilder toBuilder() {
            return this;
        }

        @Override
        public MoneyBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getAmount() != null;
        }

        @Override
        public MoneyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MoneyBuilder o = (MoneyBuilder)other;
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MoneyBuilder {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }

    public static interface MoneyBuilder
    extends Money,
    MoneyBase.MoneyBaseBuilder {
        @Override
        public MoneyBuilder setCurrency(Currency var1);

        @Override
        public MoneyBuilder setId(String var1);

        public MoneyBuilder setAmount(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MoneyBuilder prune();
    }

    public static class MoneyImpl
    extends MoneyBase.MoneyBaseImpl
    implements Money {
        private final BigDecimal amount;

        protected MoneyImpl(MoneyBuilder builder) {
            super(builder);
            this.amount = builder.getAmount();
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public Money build() {
            return this;
        }

        @Override
        public MoneyBuilder toBuilder() {
            MoneyBuilder builder = Money.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MoneyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Money {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }
}

