/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.EntityId;
import fpml.consolidated.shared.LegalEntitySequence;
import fpml.consolidated.shared.meta.LegalEntityMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegalEntity", builder=LegalEntityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LegalEntity", model="fpml", builder=LegalEntityBuilderImpl.class, version="1.2.2")
public interface LegalEntity
extends RosettaModelObject {
    public static final LegalEntityMeta metaData = new LegalEntityMeta();

    public LegalEntitySequence getLegalEntitySequence();

    public List<? extends EntityId> getEntityId();

    public String getId();

    public LegalEntity build();

    public LegalEntityBuilder toBuilder();

    public static LegalEntityBuilder builder() {
        return new LegalEntityBuilderImpl();
    }

    default public RosettaMetaData<? extends LegalEntity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegalEntity> getType() {
        return LegalEntity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("legalEntitySequence"), processor, LegalEntitySequence.class, this.getLegalEntitySequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("entityId"), processor, EntityId.class, this.getEntityId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LegalEntityBuilderImpl
    implements LegalEntityBuilder {
        protected LegalEntitySequence.LegalEntitySequenceBuilder legalEntitySequence;
        protected List<EntityId.EntityIdBuilder> entityId = new ArrayList<EntityId.EntityIdBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="legalEntitySequence")
        @RuneAttribute(value="legalEntitySequence")
        public LegalEntitySequence.LegalEntitySequenceBuilder getLegalEntitySequence() {
            return this.legalEntitySequence;
        }

        @Override
        public LegalEntitySequence.LegalEntitySequenceBuilder getOrCreateLegalEntitySequence() {
            LegalEntitySequence.LegalEntitySequenceBuilder result = this.legalEntitySequence != null ? this.legalEntitySequence : (this.legalEntitySequence = LegalEntitySequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public List<? extends EntityId.EntityIdBuilder> getEntityId() {
            return this.entityId;
        }

        @Override
        public EntityId.EntityIdBuilder getOrCreateEntityId(int index) {
            if (this.entityId == null) {
                this.entityId = new ArrayList<EntityId.EntityIdBuilder>();
            }
            return (EntityId.EntityIdBuilder)this.getIndex(this.entityId, index, () -> {
                EntityId.EntityIdBuilder newEntityId = EntityId.builder();
                return newEntityId;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="legalEntitySequence")
        @RuneAttribute(value="legalEntitySequence")
        public LegalEntityBuilder setLegalEntitySequence(LegalEntitySequence _legalEntitySequence) {
            this.legalEntitySequence = _legalEntitySequence == null ? null : _legalEntitySequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public LegalEntityBuilder addEntityId(EntityId _entityId) {
            if (_entityId != null) {
                this.entityId.add(_entityId.toBuilder());
            }
            return this;
        }

        @Override
        public LegalEntityBuilder addEntityId(EntityId _entityId, int idx) {
            this.getIndex(this.entityId, idx, () -> _entityId.toBuilder());
            return this;
        }

        @Override
        public LegalEntityBuilder addEntityId(List<? extends EntityId> entityIds) {
            if (entityIds != null) {
                for (EntityId entityId : entityIds) {
                    this.entityId.add(entityId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="entityId")
        public LegalEntityBuilder setEntityId(List<? extends EntityId> entityIds) {
            this.entityId = entityIds == null ? new ArrayList<EntityId.EntityIdBuilder>() : (List)entityIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LegalEntityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public LegalEntity build() {
            return new LegalEntityImpl(this);
        }

        @Override
        public LegalEntityBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalEntityBuilder prune() {
            if (this.legalEntitySequence != null && !this.legalEntitySequence.prune().hasData()) {
                this.legalEntitySequence = null;
            }
            this.entityId = this.entityId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getLegalEntitySequence() != null && this.getLegalEntitySequence().hasData()) {
                return true;
            }
            if (this.getEntityId() != null && this.getEntityId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public LegalEntityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegalEntityBuilder o = (LegalEntityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalEntitySequence(), (RosettaModelObjectBuilder)o.getLegalEntitySequence(), this::setLegalEntitySequence);
            merger.mergeRosetta(this.getEntityId(), o.getEntityId(), this::getOrCreateEntityId);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.legalEntitySequence, _that.getLegalEntitySequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.entityId, _that.getEntityId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.legalEntitySequence != null ? this.legalEntitySequence.hashCode() : 0);
            _result = 31 * _result + (this.entityId != null ? this.entityId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalEntityBuilder {legalEntitySequence=" + String.valueOf(this.legalEntitySequence) + ", entityId=" + String.valueOf(this.entityId) + ", id=" + this.id + "}";
        }
    }

    public static interface LegalEntityBuilder
    extends LegalEntity,
    RosettaModelObjectBuilder {
        public LegalEntitySequence.LegalEntitySequenceBuilder getOrCreateLegalEntitySequence();

        @Override
        public LegalEntitySequence.LegalEntitySequenceBuilder getLegalEntitySequence();

        public EntityId.EntityIdBuilder getOrCreateEntityId(int var1);

        public List<? extends EntityId.EntityIdBuilder> getEntityId();

        public LegalEntityBuilder setLegalEntitySequence(LegalEntitySequence var1);

        public LegalEntityBuilder addEntityId(EntityId var1);

        public LegalEntityBuilder addEntityId(EntityId var1, int var2);

        public LegalEntityBuilder addEntityId(List<? extends EntityId> var1);

        public LegalEntityBuilder setEntityId(List<? extends EntityId> var1);

        public LegalEntityBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("legalEntitySequence"), processor, LegalEntitySequence.LegalEntitySequenceBuilder.class, this.getLegalEntitySequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("entityId"), processor, EntityId.EntityIdBuilder.class, this.getEntityId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public LegalEntityBuilder prune();
    }

    public static class LegalEntityImpl
    implements LegalEntity {
        private final LegalEntitySequence legalEntitySequence;
        private final List<? extends EntityId> entityId;
        private final String id;

        protected LegalEntityImpl(LegalEntityBuilder builder) {
            this.legalEntitySequence = Optional.ofNullable(builder.getLegalEntitySequence()).map(f -> f.build()).orElse(null);
            this.entityId = Optional.ofNullable(builder.getEntityId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="legalEntitySequence")
        @RuneAttribute(value="legalEntitySequence")
        public LegalEntitySequence getLegalEntitySequence() {
            return this.legalEntitySequence;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public List<? extends EntityId> getEntityId() {
            return this.entityId;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public LegalEntity build() {
            return this;
        }

        @Override
        public LegalEntityBuilder toBuilder() {
            LegalEntityBuilder builder = LegalEntity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalEntityBuilder builder) {
            Optional.ofNullable(this.getLegalEntitySequence()).ifPresent(builder::setLegalEntitySequence);
            Optional.ofNullable(this.getEntityId()).ifPresent(builder::setEntityId);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.legalEntitySequence, _that.getLegalEntitySequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.entityId, _that.getEntityId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.legalEntitySequence != null ? this.legalEntitySequence.hashCode() : 0);
            _result = 31 * _result + (this.entityId != null ? this.entityId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalEntity {legalEntitySequence=" + String.valueOf(this.legalEntitySequence) + ", entityId=" + String.valueOf(this.entityId) + ", id=" + this.id + "}";
        }
    }
}

