/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.RateTreatmentEnum;
import fpml.consolidated.shared.Schedule;
import fpml.consolidated.shared.SpreadSchedule;
import fpml.consolidated.shared.StrikeSchedule;
import fpml.consolidated.shared.meta.FloatingRateModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingRateModel", builder=FloatingRateModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FloatingRateModel", model="fpml", builder=FloatingRateModelBuilderImpl.class, version="1.2.2")
public interface FloatingRateModel
extends RosettaModelObject {
    public static final FloatingRateModelMeta metaData = new FloatingRateModelMeta();

    public Schedule getFloatingRateMultiplierSchedule();

    public List<? extends SpreadSchedule> getSpreadSchedule();

    public RateTreatmentEnum getRateTreatment();

    public List<? extends StrikeSchedule> getCapRateSchedule();

    public List<? extends StrikeSchedule> getFloorRateSchedule();

    public FloatingRateModel build();

    public FloatingRateModelBuilder toBuilder();

    public static FloatingRateModelBuilder builder() {
        return new FloatingRateModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateModel> getType() {
        return FloatingRateModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, Schedule.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.class, this.getCapRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
    }

    public static class FloatingRateModelBuilderImpl
    implements FloatingRateModelBuilder {
        protected Schedule.ScheduleBuilder floatingRateMultiplierSchedule;
        protected List<SpreadSchedule.SpreadScheduleBuilder> spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();
        protected RateTreatmentEnum rateTreatment;
        protected List<StrikeSchedule.StrikeScheduleBuilder> capRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
        protected List<StrikeSchedule.StrikeScheduleBuilder> floorRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public Schedule.ScheduleBuilder getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateFloatingRateMultiplierSchedule() {
            Schedule.ScheduleBuilder result = this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule : (this.floatingRateMultiplierSchedule = Schedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int index) {
            if (this.spreadSchedule == null) {
                this.spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();
            }
            return (SpreadSchedule.SpreadScheduleBuilder)this.getIndex(this.spreadSchedule, index, () -> {
                SpreadSchedule.SpreadScheduleBuilder newSpreadSchedule = SpreadSchedule.builder();
                return newSpreadSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getCapRateSchedule() {
            return this.capRateSchedule;
        }

        @Override
        public StrikeSchedule.StrikeScheduleBuilder getOrCreateCapRateSchedule(int index) {
            if (this.capRateSchedule == null) {
                this.capRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
            }
            return (StrikeSchedule.StrikeScheduleBuilder)this.getIndex(this.capRateSchedule, index, () -> {
                StrikeSchedule.StrikeScheduleBuilder newCapRateSchedule = StrikeSchedule.builder();
                return newCapRateSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getFloorRateSchedule() {
            return this.floorRateSchedule;
        }

        @Override
        public StrikeSchedule.StrikeScheduleBuilder getOrCreateFloorRateSchedule(int index) {
            if (this.floorRateSchedule == null) {
                this.floorRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
            }
            return (StrikeSchedule.StrikeScheduleBuilder)this.getIndex(this.floorRateSchedule, index, () -> {
                StrikeSchedule.StrikeScheduleBuilder newFloorRateSchedule = StrikeSchedule.builder();
                return newFloorRateSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public FloatingRateModelBuilder setFloatingRateMultiplierSchedule(Schedule _floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = _floatingRateMultiplierSchedule == null ? null : _floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public FloatingRateModelBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule) {
            if (_spreadSchedule != null) {
                this.spreadSchedule.add(_spreadSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateModelBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule, int idx) {
            this.getIndex(this.spreadSchedule, idx, () -> _spreadSchedule.toBuilder());
            return this;
        }

        @Override
        public FloatingRateModelBuilder addSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            if (spreadSchedules != null) {
                for (SpreadSchedule spreadSchedule : spreadSchedules) {
                    this.spreadSchedule.add(spreadSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadSchedule")
        public FloatingRateModelBuilder setSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            this.spreadSchedule = spreadSchedules == null ? new ArrayList<SpreadSchedule.SpreadScheduleBuilder>() : (List)spreadSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public FloatingRateModelBuilder setRateTreatment(RateTreatmentEnum _rateTreatment) {
            this.rateTreatment = _rateTreatment == null ? null : _rateTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public FloatingRateModelBuilder addCapRateSchedule(StrikeSchedule _capRateSchedule) {
            if (_capRateSchedule != null) {
                this.capRateSchedule.add(_capRateSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateModelBuilder addCapRateSchedule(StrikeSchedule _capRateSchedule, int idx) {
            this.getIndex(this.capRateSchedule, idx, () -> _capRateSchedule.toBuilder());
            return this;
        }

        @Override
        public FloatingRateModelBuilder addCapRateSchedule(List<? extends StrikeSchedule> capRateSchedules) {
            if (capRateSchedules != null) {
                for (StrikeSchedule strikeSchedule : capRateSchedules) {
                    this.capRateSchedule.add(strikeSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="capRateSchedule")
        public FloatingRateModelBuilder setCapRateSchedule(List<? extends StrikeSchedule> capRateSchedules) {
            this.capRateSchedule = capRateSchedules == null ? new ArrayList<StrikeSchedule.StrikeScheduleBuilder>() : (List)capRateSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public FloatingRateModelBuilder addFloorRateSchedule(StrikeSchedule _floorRateSchedule) {
            if (_floorRateSchedule != null) {
                this.floorRateSchedule.add(_floorRateSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateModelBuilder addFloorRateSchedule(StrikeSchedule _floorRateSchedule, int idx) {
            this.getIndex(this.floorRateSchedule, idx, () -> _floorRateSchedule.toBuilder());
            return this;
        }

        @Override
        public FloatingRateModelBuilder addFloorRateSchedule(List<? extends StrikeSchedule> floorRateSchedules) {
            if (floorRateSchedules != null) {
                for (StrikeSchedule strikeSchedule : floorRateSchedules) {
                    this.floorRateSchedule.add(strikeSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floorRateSchedule")
        public FloatingRateModelBuilder setFloorRateSchedule(List<? extends StrikeSchedule> floorRateSchedules) {
            this.floorRateSchedule = floorRateSchedules == null ? new ArrayList<StrikeSchedule.StrikeScheduleBuilder>() : (List)floorRateSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FloatingRateModel build() {
            return new FloatingRateModelImpl(this);
        }

        @Override
        public FloatingRateModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateModelBuilder prune() {
            if (this.floatingRateMultiplierSchedule != null && !this.floatingRateMultiplierSchedule.prune().hasData()) {
                this.floatingRateMultiplierSchedule = null;
            }
            this.spreadSchedule = this.spreadSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.capRateSchedule = this.capRateSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.floorRateSchedule = this.floorRateSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRateMultiplierSchedule() != null && this.getFloatingRateMultiplierSchedule().hasData()) {
                return true;
            }
            if (this.getSpreadSchedule() != null && this.getSpreadSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRateTreatment() != null) {
                return true;
            }
            if (this.getCapRateSchedule() != null && this.getCapRateSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFloorRateSchedule() != null && this.getFloorRateSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FloatingRateModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateModelBuilder o = (FloatingRateModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateMultiplierSchedule(), (RosettaModelObjectBuilder)o.getFloatingRateMultiplierSchedule(), this::setFloatingRateMultiplierSchedule);
            merger.mergeRosetta(this.getSpreadSchedule(), o.getSpreadSchedule(), this::getOrCreateSpreadSchedule);
            merger.mergeRosetta(this.getCapRateSchedule(), o.getCapRateSchedule(), this::getOrCreateCapRateSchedule);
            merger.mergeRosetta(this.getFloorRateSchedule(), o.getFloorRateSchedule(), this::getOrCreateFloorRateSchedule);
            merger.mergeBasic((Object)this.getRateTreatment(), (Object)o.getRateTreatment(), this::setRateTreatment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateModel _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRateSchedule, _that.getCapRateSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRateSchedule, _that.getFloorRateSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRateSchedule != null ? this.capRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.floorRateSchedule != null ? this.floorRateSchedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateModelBuilder {floatingRateMultiplierSchedule=" + String.valueOf(this.floatingRateMultiplierSchedule) + ", spreadSchedule=" + String.valueOf(this.spreadSchedule) + ", rateTreatment=" + String.valueOf((Object)this.rateTreatment) + ", capRateSchedule=" + String.valueOf(this.capRateSchedule) + ", floorRateSchedule=" + String.valueOf(this.floorRateSchedule) + "}";
        }
    }

    public static interface FloatingRateModelBuilder
    extends FloatingRateModel,
    RosettaModelObjectBuilder {
        public Schedule.ScheduleBuilder getOrCreateFloatingRateMultiplierSchedule();

        @Override
        public Schedule.ScheduleBuilder getFloatingRateMultiplierSchedule();

        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int var1);

        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule();

        public StrikeSchedule.StrikeScheduleBuilder getOrCreateCapRateSchedule(int var1);

        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getCapRateSchedule();

        public StrikeSchedule.StrikeScheduleBuilder getOrCreateFloorRateSchedule(int var1);

        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getFloorRateSchedule();

        public FloatingRateModelBuilder setFloatingRateMultiplierSchedule(Schedule var1);

        public FloatingRateModelBuilder addSpreadSchedule(SpreadSchedule var1);

        public FloatingRateModelBuilder addSpreadSchedule(SpreadSchedule var1, int var2);

        public FloatingRateModelBuilder addSpreadSchedule(List<? extends SpreadSchedule> var1);

        public FloatingRateModelBuilder setSpreadSchedule(List<? extends SpreadSchedule> var1);

        public FloatingRateModelBuilder setRateTreatment(RateTreatmentEnum var1);

        public FloatingRateModelBuilder addCapRateSchedule(StrikeSchedule var1);

        public FloatingRateModelBuilder addCapRateSchedule(StrikeSchedule var1, int var2);

        public FloatingRateModelBuilder addCapRateSchedule(List<? extends StrikeSchedule> var1);

        public FloatingRateModelBuilder setCapRateSchedule(List<? extends StrikeSchedule> var1);

        public FloatingRateModelBuilder addFloorRateSchedule(StrikeSchedule var1);

        public FloatingRateModelBuilder addFloorRateSchedule(StrikeSchedule var1, int var2);

        public FloatingRateModelBuilder addFloorRateSchedule(List<? extends StrikeSchedule> var1);

        public FloatingRateModelBuilder setFloorRateSchedule(List<? extends StrikeSchedule> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, Schedule.ScheduleBuilder.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.SpreadScheduleBuilder.class, this.getSpreadSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, this.getCapRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
        }

        public FloatingRateModelBuilder prune();
    }

    public static class FloatingRateModelImpl
    implements FloatingRateModel {
        private final Schedule floatingRateMultiplierSchedule;
        private final List<? extends SpreadSchedule> spreadSchedule;
        private final RateTreatmentEnum rateTreatment;
        private final List<? extends StrikeSchedule> capRateSchedule;
        private final List<? extends StrikeSchedule> floorRateSchedule;

        protected FloatingRateModelImpl(FloatingRateModelBuilder builder) {
            this.floatingRateMultiplierSchedule = Optional.ofNullable(builder.getFloatingRateMultiplierSchedule()).map(f -> f.build()).orElse(null);
            this.spreadSchedule = Optional.ofNullable(builder.getSpreadSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.rateTreatment = builder.getRateTreatment();
            this.capRateSchedule = Optional.ofNullable(builder.getCapRateSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.floorRateSchedule = Optional.ofNullable(builder.getFloorRateSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public Schedule getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public List<? extends StrikeSchedule> getCapRateSchedule() {
            return this.capRateSchedule;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public List<? extends StrikeSchedule> getFloorRateSchedule() {
            return this.floorRateSchedule;
        }

        @Override
        public FloatingRateModel build() {
            return this;
        }

        @Override
        public FloatingRateModelBuilder toBuilder() {
            FloatingRateModelBuilder builder = FloatingRateModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateModelBuilder builder) {
            Optional.ofNullable(this.getFloatingRateMultiplierSchedule()).ifPresent(builder::setFloatingRateMultiplierSchedule);
            Optional.ofNullable(this.getSpreadSchedule()).ifPresent(builder::setSpreadSchedule);
            Optional.ofNullable(this.getRateTreatment()).ifPresent(builder::setRateTreatment);
            Optional.ofNullable(this.getCapRateSchedule()).ifPresent(builder::setCapRateSchedule);
            Optional.ofNullable(this.getFloorRateSchedule()).ifPresent(builder::setFloorRateSchedule);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateModel _that = this.getType().cast(o);
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRateSchedule, _that.getCapRateSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRateSchedule, _that.getFloorRateSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRateSchedule != null ? this.capRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.floorRateSchedule != null ? this.floorRateSchedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateModel {floatingRateMultiplierSchedule=" + String.valueOf(this.floatingRateMultiplierSchedule) + ", spreadSchedule=" + String.valueOf(this.spreadSchedule) + ", rateTreatment=" + String.valueOf((Object)this.rateTreatment) + ", capRateSchedule=" + String.valueOf(this.capRateSchedule) + ", floorRateSchedule=" + String.valueOf(this.floorRateSchedule) + "}";
        }
    }
}

