/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.ContactInformation;
import fpml.consolidated.shared.CountryCode;
import fpml.consolidated.shared.Unit;
import fpml.consolidated.shared.meta.BusinessUnitMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BusinessUnit", builder=BusinessUnitBuilderImpl.class, version="1.2.2")
@RuneDataType(value="BusinessUnit", model="fpml", builder=BusinessUnitBuilderImpl.class, version="1.2.2")
public interface BusinessUnit
extends RosettaModelObject {
    public static final BusinessUnitMeta metaData = new BusinessUnitMeta();

    public String getName();

    public Unit getBusinessUnitId();

    public ContactInformation getContactInfo();

    public CountryCode getCountry();

    public String getId();

    public BusinessUnit build();

    public BusinessUnitBuilder toBuilder();

    public static BusinessUnitBuilder builder() {
        return new BusinessUnitBuilderImpl();
    }

    default public RosettaMetaData<? extends BusinessUnit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BusinessUnit> getType() {
        return BusinessUnit.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnitId"), processor, Unit.class, this.getBusinessUnitId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.class, this.getContactInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("country"), processor, CountryCode.class, this.getCountry(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BusinessUnitBuilderImpl
    implements BusinessUnitBuilder {
        protected String name;
        protected Unit.UnitBuilder businessUnitId;
        protected ContactInformation.ContactInformationBuilder contactInfo;
        protected CountryCode.CountryCodeBuilder country;
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="businessUnitId")
        @RuneAttribute(value="businessUnitId")
        public Unit.UnitBuilder getBusinessUnitId() {
            return this.businessUnitId;
        }

        @Override
        public Unit.UnitBuilder getOrCreateBusinessUnitId() {
            Unit.UnitBuilder result = this.businessUnitId != null ? this.businessUnitId : (this.businessUnitId = Unit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation.ContactInformationBuilder getContactInfo() {
            return this.contactInfo;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo() {
            ContactInformation.ContactInformationBuilder result = this.contactInfo != null ? this.contactInfo : (this.contactInfo = ContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode.CountryCodeBuilder getCountry() {
            return this.country;
        }

        @Override
        public CountryCode.CountryCodeBuilder getOrCreateCountry() {
            CountryCode.CountryCodeBuilder result = this.country != null ? this.country : (this.country = CountryCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public BusinessUnitBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessUnitId")
        @RuneAttribute(value="businessUnitId")
        public BusinessUnitBuilder setBusinessUnitId(Unit _businessUnitId) {
            this.businessUnitId = _businessUnitId == null ? null : _businessUnitId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public BusinessUnitBuilder setContactInfo(ContactInformation _contactInfo) {
            this.contactInfo = _contactInfo == null ? null : _contactInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public BusinessUnitBuilder setCountry(CountryCode _country) {
            this.country = _country == null ? null : _country.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BusinessUnitBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public BusinessUnit build() {
            return new BusinessUnitImpl(this);
        }

        @Override
        public BusinessUnitBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessUnitBuilder prune() {
            if (this.businessUnitId != null && !this.businessUnitId.prune().hasData()) {
                this.businessUnitId = null;
            }
            if (this.contactInfo != null && !this.contactInfo.prune().hasData()) {
                this.contactInfo = null;
            }
            if (this.country != null && !this.country.prune().hasData()) {
                this.country = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getBusinessUnitId() != null && this.getBusinessUnitId().hasData()) {
                return true;
            }
            if (this.getContactInfo() != null && this.getContactInfo().hasData()) {
                return true;
            }
            if (this.getCountry() != null && this.getCountry().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public BusinessUnitBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BusinessUnitBuilder o = (BusinessUnitBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessUnitId(), (RosettaModelObjectBuilder)o.getBusinessUnitId(), this::setBusinessUnitId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInfo(), (RosettaModelObjectBuilder)o.getContactInfo(), this::setContactInfo);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCountry(), (RosettaModelObjectBuilder)o.getCountry(), this::setCountry);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessUnit _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.businessUnitId, _that.getBusinessUnitId())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.businessUnitId != null ? this.businessUnitId.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessUnitBuilder {name=" + this.name + ", businessUnitId=" + String.valueOf(this.businessUnitId) + ", contactInfo=" + String.valueOf(this.contactInfo) + ", country=" + String.valueOf(this.country) + ", id=" + this.id + "}";
        }
    }

    public static interface BusinessUnitBuilder
    extends BusinessUnit,
    RosettaModelObjectBuilder {
        public Unit.UnitBuilder getOrCreateBusinessUnitId();

        @Override
        public Unit.UnitBuilder getBusinessUnitId();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInfo();

        public CountryCode.CountryCodeBuilder getOrCreateCountry();

        @Override
        public CountryCode.CountryCodeBuilder getCountry();

        public BusinessUnitBuilder setName(String var1);

        public BusinessUnitBuilder setBusinessUnitId(Unit var1);

        public BusinessUnitBuilder setContactInfo(ContactInformation var1);

        public BusinessUnitBuilder setCountry(CountryCode var1);

        public BusinessUnitBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnitId"), processor, Unit.UnitBuilder.class, this.getBusinessUnitId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("country"), processor, CountryCode.CountryCodeBuilder.class, this.getCountry(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public BusinessUnitBuilder prune();
    }

    public static class BusinessUnitImpl
    implements BusinessUnit {
        private final String name;
        private final Unit businessUnitId;
        private final ContactInformation contactInfo;
        private final CountryCode country;
        private final String id;

        protected BusinessUnitImpl(BusinessUnitBuilder builder) {
            this.name = builder.getName();
            this.businessUnitId = Optional.ofNullable(builder.getBusinessUnitId()).map(f -> f.build()).orElse(null);
            this.contactInfo = Optional.ofNullable(builder.getContactInfo()).map(f -> f.build()).orElse(null);
            this.country = Optional.ofNullable(builder.getCountry()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="businessUnitId")
        @RuneAttribute(value="businessUnitId")
        public Unit getBusinessUnitId() {
            return this.businessUnitId;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation getContactInfo() {
            return this.contactInfo;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode getCountry() {
            return this.country;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public BusinessUnit build() {
            return this;
        }

        @Override
        public BusinessUnitBuilder toBuilder() {
            BusinessUnitBuilder builder = BusinessUnit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessUnitBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getBusinessUnitId()).ifPresent(builder::setBusinessUnitId);
            Optional.ofNullable(this.getContactInfo()).ifPresent(builder::setContactInfo);
            Optional.ofNullable(this.getCountry()).ifPresent(builder::setCountry);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessUnit _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.businessUnitId, _that.getBusinessUnitId())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.businessUnitId != null ? this.businessUnitId.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessUnit {name=" + this.name + ", businessUnitId=" + String.valueOf(this.businessUnitId) + ", contactInfo=" + String.valueOf(this.contactInfo) + ", country=" + String.valueOf(this.country) + ", id=" + this.id + "}";
        }
    }
}

