/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.BusinessDayAdjustments;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.meta.AdjustableDatesMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AdjustableDates", builder=AdjustableDatesBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AdjustableDates", model="fpml", builder=AdjustableDatesBuilderImpl.class, version="1.2.2")
public interface AdjustableDates
extends RosettaModelObject {
    public static final AdjustableDatesMeta metaData = new AdjustableDatesMeta();

    public List<? extends IdentifiedDate> getUnadjustedDate();

    public BusinessDayAdjustments getDateAdjustments();

    public List<? extends IdentifiedDate> getAdjustedDate();

    public String getId();

    public AdjustableDates build();

    public AdjustableDatesBuilder toBuilder();

    public static AdjustableDatesBuilder builder() {
        return new AdjustableDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends AdjustableDates> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AdjustableDates> getType() {
        return AdjustableDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("unadjustedDate"), processor, IdentifiedDate.class, this.getUnadjustedDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustedDate"), processor, IdentifiedDate.class, this.getAdjustedDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AdjustableDatesBuilderImpl
    implements AdjustableDatesBuilder {
        protected List<IdentifiedDate.IdentifiedDateBuilder> unadjustedDate = new ArrayList<IdentifiedDate.IdentifiedDateBuilder>();
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected List<IdentifiedDate.IdentifiedDateBuilder> adjustedDate = new ArrayList<IdentifiedDate.IdentifiedDateBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public List<? extends IdentifiedDate.IdentifiedDateBuilder> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateUnadjustedDate(int index) {
            if (this.unadjustedDate == null) {
                this.unadjustedDate = new ArrayList<IdentifiedDate.IdentifiedDateBuilder>();
            }
            return (IdentifiedDate.IdentifiedDateBuilder)this.getIndex(this.unadjustedDate, index, () -> {
                IdentifiedDate.IdentifiedDateBuilder newUnadjustedDate = IdentifiedDate.builder();
                return newUnadjustedDate;
            });
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public List<? extends IdentifiedDate.IdentifiedDateBuilder> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAdjustedDate(int index) {
            if (this.adjustedDate == null) {
                this.adjustedDate = new ArrayList<IdentifiedDate.IdentifiedDateBuilder>();
            }
            return (IdentifiedDate.IdentifiedDateBuilder)this.getIndex(this.adjustedDate, index, () -> {
                IdentifiedDate.IdentifiedDateBuilder newAdjustedDate = IdentifiedDate.builder();
                return newAdjustedDate;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public AdjustableDatesBuilder addUnadjustedDate(IdentifiedDate _unadjustedDate) {
            if (_unadjustedDate != null) {
                this.unadjustedDate.add(_unadjustedDate.toBuilder());
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(IdentifiedDate _unadjustedDate, int idx) {
            this.getIndex(this.unadjustedDate, idx, () -> _unadjustedDate.toBuilder());
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(List<? extends IdentifiedDate> unadjustedDates) {
            if (unadjustedDates != null) {
                for (IdentifiedDate identifiedDate : unadjustedDates) {
                    this.unadjustedDate.add(identifiedDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="unadjustedDate")
        public AdjustableDatesBuilder setUnadjustedDate(List<? extends IdentifiedDate> unadjustedDates) {
            this.unadjustedDate = unadjustedDates == null ? new ArrayList<IdentifiedDate.IdentifiedDateBuilder>() : (List)unadjustedDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public AdjustableDatesBuilder addAdjustedDate(IdentifiedDate _adjustedDate) {
            if (_adjustedDate != null) {
                this.adjustedDate.add(_adjustedDate.toBuilder());
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(IdentifiedDate _adjustedDate, int idx) {
            this.getIndex(this.adjustedDate, idx, () -> _adjustedDate.toBuilder());
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(List<? extends IdentifiedDate> adjustedDates) {
            if (adjustedDates != null) {
                for (IdentifiedDate identifiedDate : adjustedDates) {
                    this.adjustedDate.add(identifiedDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="adjustedDate")
        public AdjustableDatesBuilder setAdjustedDate(List<? extends IdentifiedDate> adjustedDates) {
            this.adjustedDate = adjustedDates == null ? new ArrayList<IdentifiedDate.IdentifiedDateBuilder>() : (List)adjustedDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AdjustableDatesBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public AdjustableDates build() {
            return new AdjustableDatesImpl(this);
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder prune() {
            this.unadjustedDate = this.unadjustedDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            this.adjustedDate = this.adjustedDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getUnadjustedDate() != null && this.getUnadjustedDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            if (this.getAdjustedDate() != null && this.getAdjustedDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public AdjustableDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustableDatesBuilder o = (AdjustableDatesBuilder)other;
            merger.mergeRosetta(this.getUnadjustedDate(), o.getUnadjustedDate(), this::getOrCreateUnadjustedDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta(this.getAdjustedDate(), o.getAdjustedDate(), this::getOrCreateAdjustedDate);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDatesBuilder {unadjustedDate=" + String.valueOf(this.unadjustedDate) + ", dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", adjustedDate=" + String.valueOf(this.adjustedDate) + ", id=" + this.id + "}";
        }
    }

    public static interface AdjustableDatesBuilder
    extends AdjustableDates,
    RosettaModelObjectBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateUnadjustedDate(int var1);

        public List<? extends IdentifiedDate.IdentifiedDateBuilder> getUnadjustedDate();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAdjustedDate(int var1);

        public List<? extends IdentifiedDate.IdentifiedDateBuilder> getAdjustedDate();

        public AdjustableDatesBuilder addUnadjustedDate(IdentifiedDate var1);

        public AdjustableDatesBuilder addUnadjustedDate(IdentifiedDate var1, int var2);

        public AdjustableDatesBuilder addUnadjustedDate(List<? extends IdentifiedDate> var1);

        public AdjustableDatesBuilder setUnadjustedDate(List<? extends IdentifiedDate> var1);

        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public AdjustableDatesBuilder addAdjustedDate(IdentifiedDate var1);

        public AdjustableDatesBuilder addAdjustedDate(IdentifiedDate var1, int var2);

        public AdjustableDatesBuilder addAdjustedDate(List<? extends IdentifiedDate> var1);

        public AdjustableDatesBuilder setAdjustedDate(List<? extends IdentifiedDate> var1);

        public AdjustableDatesBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("unadjustedDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getUnadjustedDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustedDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getAdjustedDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AdjustableDatesBuilder prune();
    }

    public static class AdjustableDatesImpl
    implements AdjustableDates {
        private final List<? extends IdentifiedDate> unadjustedDate;
        private final BusinessDayAdjustments dateAdjustments;
        private final List<? extends IdentifiedDate> adjustedDate;
        private final String id;

        protected AdjustableDatesImpl(AdjustableDatesBuilder builder) {
            this.unadjustedDate = Optional.ofNullable(builder.getUnadjustedDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.adjustedDate = Optional.ofNullable(builder.getAdjustedDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public List<? extends IdentifiedDate> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public List<? extends IdentifiedDate> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public AdjustableDates build() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            AdjustableDatesBuilder builder = AdjustableDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustableDatesBuilder builder) {
            Optional.ofNullable(this.getUnadjustedDate()).ifPresent(builder::setUnadjustedDate);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getAdjustedDate()).ifPresent(builder::setAdjustedDate);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDates {unadjustedDate=" + String.valueOf(this.unadjustedDate) + ", dateAdjustments=" + String.valueOf(this.dateAdjustments) + ", adjustedDate=" + String.valueOf(this.adjustedDate) + ", id=" + this.id + "}";
        }
    }
}

