/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.sec.lending;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.SecurityLendingDurationEnum;
import fpml.consolidated.repo.ExtensionPeriodModel;
import fpml.consolidated.repo.SecurityValuation;
import fpml.consolidated.sec.lending.DividendsAndPaymentModel;
import fpml.consolidated.sec.lending.LenderBorrowerModel;
import fpml.consolidated.sec.lending.SecLendCollateralProvisions;
import fpml.consolidated.sec.lending.SecLendInitiation;
import fpml.consolidated.sec.lending.SecLendRebateCalculation;
import fpml.consolidated.sec.lending.SecLendTermination;
import fpml.consolidated.sec.lending.SecurityLendingSequence0;
import fpml.consolidated.sec.lending.SecurityLendingSequence1;
import fpml.consolidated.sec.lending.meta.SecurityLendingMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SecurityLending", builder=SecurityLendingBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SecurityLending", model="fpml", builder=SecurityLendingBuilderImpl.class, version="1.2.2")
public interface SecurityLending
extends Product {
    public static final SecurityLendingMeta metaData = new SecurityLendingMeta();

    public LenderBorrowerModel getLenderBorrowerModel();

    public SecurityValuation getPrincipal();

    public SecLendInitiation getInitiation();

    public SecLendTermination getTermination();

    public SecurityLendingDurationEnum getDuration();

    public ExtensionPeriodModel getExtensionPeriodModel();

    public SecurityLendingSequence0 getSecurityLendingSequence0();

    public SecurityLendingSequence1 getSecurityLendingSequence1();

    public SecLendRebateCalculation getRebate();

    public DayCountFraction getDayCountFraction();

    public DividendsAndPaymentModel getDividendsAndPaymentModel();

    public SecLendCollateralProvisions getCollateralProvisions();

    @Override
    public SecurityLending build();

    @Override
    public SecurityLendingBuilder toBuilder();

    public static SecurityLendingBuilder builder() {
        return new SecurityLendingBuilderImpl();
    }

    default public RosettaMetaData<? extends SecurityLending> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SecurityLending> getType() {
        return SecurityLending.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderBorrowerModel"), processor, LenderBorrowerModel.class, this.getLenderBorrowerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principal"), processor, SecurityValuation.class, this.getPrincipal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initiation"), processor, SecLendInitiation.class, this.getInitiation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("termination"), processor, SecLendTermination.class, this.getTermination(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("duration"), SecurityLendingDurationEnum.class, (Object)this.getDuration(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extensionPeriodModel"), processor, ExtensionPeriodModel.class, this.getExtensionPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityLendingSequence0"), processor, SecurityLendingSequence0.class, this.getSecurityLendingSequence0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityLendingSequence1"), processor, SecurityLendingSequence1.class, this.getSecurityLendingSequence1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rebate"), processor, SecLendRebateCalculation.class, this.getRebate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendsAndPaymentModel"), processor, DividendsAndPaymentModel.class, this.getDividendsAndPaymentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralProvisions"), processor, SecLendCollateralProvisions.class, this.getCollateralProvisions(), new AttributeMeta[0]);
    }

    public static class SecurityLendingBuilderImpl
    extends Product.ProductBuilderImpl
    implements SecurityLendingBuilder {
        protected LenderBorrowerModel.LenderBorrowerModelBuilder lenderBorrowerModel;
        protected SecurityValuation.SecurityValuationBuilder principal;
        protected SecLendInitiation.SecLendInitiationBuilder initiation;
        protected SecLendTermination.SecLendTerminationBuilder termination;
        protected SecurityLendingDurationEnum duration;
        protected ExtensionPeriodModel.ExtensionPeriodModelBuilder extensionPeriodModel;
        protected SecurityLendingSequence0.SecurityLendingSequence0Builder securityLendingSequence0;
        protected SecurityLendingSequence1.SecurityLendingSequence1Builder securityLendingSequence1;
        protected SecLendRebateCalculation.SecLendRebateCalculationBuilder rebate;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected DividendsAndPaymentModel.DividendsAndPaymentModelBuilder dividendsAndPaymentModel;
        protected SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder collateralProvisions;

        @Override
        @RosettaAttribute(value="lenderBorrowerModel", isRequired=true)
        @RuneAttribute(value="lenderBorrowerModel", isRequired=true)
        public LenderBorrowerModel.LenderBorrowerModelBuilder getLenderBorrowerModel() {
            return this.lenderBorrowerModel;
        }

        @Override
        public LenderBorrowerModel.LenderBorrowerModelBuilder getOrCreateLenderBorrowerModel() {
            LenderBorrowerModel.LenderBorrowerModelBuilder result = this.lenderBorrowerModel != null ? this.lenderBorrowerModel : (this.lenderBorrowerModel = LenderBorrowerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public SecurityValuation.SecurityValuationBuilder getPrincipal() {
            return this.principal;
        }

        @Override
        public SecurityValuation.SecurityValuationBuilder getOrCreatePrincipal() {
            SecurityValuation.SecurityValuationBuilder result = this.principal != null ? this.principal : (this.principal = SecurityValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initiation", isRequired=true)
        @RuneAttribute(value="initiation", isRequired=true)
        public SecLendInitiation.SecLendInitiationBuilder getInitiation() {
            return this.initiation;
        }

        @Override
        public SecLendInitiation.SecLendInitiationBuilder getOrCreateInitiation() {
            SecLendInitiation.SecLendInitiationBuilder result = this.initiation != null ? this.initiation : (this.initiation = SecLendInitiation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="termination")
        @RuneAttribute(value="termination")
        public SecLendTermination.SecLendTerminationBuilder getTermination() {
            return this.termination;
        }

        @Override
        public SecLendTermination.SecLendTerminationBuilder getOrCreateTermination() {
            SecLendTermination.SecLendTerminationBuilder result = this.termination != null ? this.termination : (this.termination = SecLendTermination.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="duration", isRequired=true)
        @RuneAttribute(value="duration", isRequired=true)
        public SecurityLendingDurationEnum getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="extensionPeriodModel")
        @RuneAttribute(value="extensionPeriodModel")
        public ExtensionPeriodModel.ExtensionPeriodModelBuilder getExtensionPeriodModel() {
            return this.extensionPeriodModel;
        }

        @Override
        public ExtensionPeriodModel.ExtensionPeriodModelBuilder getOrCreateExtensionPeriodModel() {
            ExtensionPeriodModel.ExtensionPeriodModelBuilder result = this.extensionPeriodModel != null ? this.extensionPeriodModel : (this.extensionPeriodModel = ExtensionPeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence0")
        @RuneAttribute(value="securityLendingSequence0")
        public SecurityLendingSequence0.SecurityLendingSequence0Builder getSecurityLendingSequence0() {
            return this.securityLendingSequence0;
        }

        @Override
        public SecurityLendingSequence0.SecurityLendingSequence0Builder getOrCreateSecurityLendingSequence0() {
            SecurityLendingSequence0.SecurityLendingSequence0Builder result = this.securityLendingSequence0 != null ? this.securityLendingSequence0 : (this.securityLendingSequence0 = SecurityLendingSequence0.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence1")
        @RuneAttribute(value="securityLendingSequence1")
        public SecurityLendingSequence1.SecurityLendingSequence1Builder getSecurityLendingSequence1() {
            return this.securityLendingSequence1;
        }

        @Override
        public SecurityLendingSequence1.SecurityLendingSequence1Builder getOrCreateSecurityLendingSequence1() {
            SecurityLendingSequence1.SecurityLendingSequence1Builder result = this.securityLendingSequence1 != null ? this.securityLendingSequence1 : (this.securityLendingSequence1 = SecurityLendingSequence1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getRebate() {
            return this.rebate;
        }

        @Override
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getOrCreateRebate() {
            SecLendRebateCalculation.SecLendRebateCalculationBuilder result = this.rebate != null ? this.rebate : (this.rebate = SecLendRebateCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendsAndPaymentModel", isRequired=true)
        @RuneAttribute(value="dividendsAndPaymentModel", isRequired=true)
        public DividendsAndPaymentModel.DividendsAndPaymentModelBuilder getDividendsAndPaymentModel() {
            return this.dividendsAndPaymentModel;
        }

        @Override
        public DividendsAndPaymentModel.DividendsAndPaymentModelBuilder getOrCreateDividendsAndPaymentModel() {
            DividendsAndPaymentModel.DividendsAndPaymentModelBuilder result = this.dividendsAndPaymentModel != null ? this.dividendsAndPaymentModel : (this.dividendsAndPaymentModel = DividendsAndPaymentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralProvisions", isRequired=true)
        @RuneAttribute(value="collateralProvisions", isRequired=true)
        public SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        public SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder getOrCreateCollateralProvisions() {
            SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder result = this.collateralProvisions != null ? this.collateralProvisions : (this.collateralProvisions = SecLendCollateralProvisions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public SecurityLendingBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SecurityLendingBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderBorrowerModel", isRequired=true)
        @RuneAttribute(value="lenderBorrowerModel", isRequired=true)
        public SecurityLendingBuilder setLenderBorrowerModel(LenderBorrowerModel _lenderBorrowerModel) {
            this.lenderBorrowerModel = _lenderBorrowerModel == null ? null : _lenderBorrowerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public SecurityLendingBuilder setPrincipal(SecurityValuation _principal) {
            this.principal = _principal == null ? null : _principal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initiation", isRequired=true)
        @RuneAttribute(value="initiation", isRequired=true)
        public SecurityLendingBuilder setInitiation(SecLendInitiation _initiation) {
            this.initiation = _initiation == null ? null : _initiation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="termination")
        @RuneAttribute(value="termination")
        public SecurityLendingBuilder setTermination(SecLendTermination _termination) {
            this.termination = _termination == null ? null : _termination.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="duration", isRequired=true)
        @RuneAttribute(value="duration", isRequired=true)
        public SecurityLendingBuilder setDuration(SecurityLendingDurationEnum _duration) {
            this.duration = _duration == null ? null : _duration;
            return this;
        }

        @Override
        @RosettaAttribute(value="extensionPeriodModel")
        @RuneAttribute(value="extensionPeriodModel")
        public SecurityLendingBuilder setExtensionPeriodModel(ExtensionPeriodModel _extensionPeriodModel) {
            this.extensionPeriodModel = _extensionPeriodModel == null ? null : _extensionPeriodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence0")
        @RuneAttribute(value="securityLendingSequence0")
        public SecurityLendingBuilder setSecurityLendingSequence0(SecurityLendingSequence0 _securityLendingSequence0) {
            this.securityLendingSequence0 = _securityLendingSequence0 == null ? null : _securityLendingSequence0.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence1")
        @RuneAttribute(value="securityLendingSequence1")
        public SecurityLendingBuilder setSecurityLendingSequence1(SecurityLendingSequence1 _securityLendingSequence1) {
            this.securityLendingSequence1 = _securityLendingSequence1 == null ? null : _securityLendingSequence1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecurityLendingBuilder setRebate(SecLendRebateCalculation _rebate) {
            this.rebate = _rebate == null ? null : _rebate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public SecurityLendingBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendsAndPaymentModel", isRequired=true)
        @RuneAttribute(value="dividendsAndPaymentModel", isRequired=true)
        public SecurityLendingBuilder setDividendsAndPaymentModel(DividendsAndPaymentModel _dividendsAndPaymentModel) {
            this.dividendsAndPaymentModel = _dividendsAndPaymentModel == null ? null : _dividendsAndPaymentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralProvisions", isRequired=true)
        @RuneAttribute(value="collateralProvisions", isRequired=true)
        public SecurityLendingBuilder setCollateralProvisions(SecLendCollateralProvisions _collateralProvisions) {
            this.collateralProvisions = _collateralProvisions == null ? null : _collateralProvisions.toBuilder();
            return this;
        }

        @Override
        public SecurityLending build() {
            return new SecurityLendingImpl(this);
        }

        @Override
        public SecurityLendingBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityLendingBuilder prune() {
            super.prune();
            if (this.lenderBorrowerModel != null && !this.lenderBorrowerModel.prune().hasData()) {
                this.lenderBorrowerModel = null;
            }
            if (this.principal != null && !this.principal.prune().hasData()) {
                this.principal = null;
            }
            if (this.initiation != null && !this.initiation.prune().hasData()) {
                this.initiation = null;
            }
            if (this.termination != null && !this.termination.prune().hasData()) {
                this.termination = null;
            }
            if (this.extensionPeriodModel != null && !this.extensionPeriodModel.prune().hasData()) {
                this.extensionPeriodModel = null;
            }
            if (this.securityLendingSequence0 != null && !this.securityLendingSequence0.prune().hasData()) {
                this.securityLendingSequence0 = null;
            }
            if (this.securityLendingSequence1 != null && !this.securityLendingSequence1.prune().hasData()) {
                this.securityLendingSequence1 = null;
            }
            if (this.rebate != null && !this.rebate.prune().hasData()) {
                this.rebate = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.dividendsAndPaymentModel != null && !this.dividendsAndPaymentModel.prune().hasData()) {
                this.dividendsAndPaymentModel = null;
            }
            if (this.collateralProvisions != null && !this.collateralProvisions.prune().hasData()) {
                this.collateralProvisions = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLenderBorrowerModel() != null && this.getLenderBorrowerModel().hasData()) {
                return true;
            }
            if (this.getPrincipal() != null && this.getPrincipal().hasData()) {
                return true;
            }
            if (this.getInitiation() != null && this.getInitiation().hasData()) {
                return true;
            }
            if (this.getTermination() != null && this.getTermination().hasData()) {
                return true;
            }
            if (this.getDuration() != null) {
                return true;
            }
            if (this.getExtensionPeriodModel() != null && this.getExtensionPeriodModel().hasData()) {
                return true;
            }
            if (this.getSecurityLendingSequence0() != null && this.getSecurityLendingSequence0().hasData()) {
                return true;
            }
            if (this.getSecurityLendingSequence1() != null && this.getSecurityLendingSequence1().hasData()) {
                return true;
            }
            if (this.getRebate() != null && this.getRebate().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getDividendsAndPaymentModel() != null && this.getDividendsAndPaymentModel().hasData()) {
                return true;
            }
            return this.getCollateralProvisions() != null && this.getCollateralProvisions().hasData();
        }

        @Override
        public SecurityLendingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecurityLendingBuilder o = (SecurityLendingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLenderBorrowerModel(), (RosettaModelObjectBuilder)o.getLenderBorrowerModel(), this::setLenderBorrowerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipal(), (RosettaModelObjectBuilder)o.getPrincipal(), this::setPrincipal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitiation(), (RosettaModelObjectBuilder)o.getInitiation(), this::setInitiation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTermination(), (RosettaModelObjectBuilder)o.getTermination(), this::setTermination);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtensionPeriodModel(), (RosettaModelObjectBuilder)o.getExtensionPeriodModel(), this::setExtensionPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurityLendingSequence0(), (RosettaModelObjectBuilder)o.getSecurityLendingSequence0(), this::setSecurityLendingSequence0);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurityLendingSequence1(), (RosettaModelObjectBuilder)o.getSecurityLendingSequence1(), this::setSecurityLendingSequence1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRebate(), (RosettaModelObjectBuilder)o.getRebate(), this::setRebate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendsAndPaymentModel(), (RosettaModelObjectBuilder)o.getDividendsAndPaymentModel(), this::setDividendsAndPaymentModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralProvisions(), (RosettaModelObjectBuilder)o.getCollateralProvisions(), this::setCollateralProvisions);
            merger.mergeBasic((Object)this.getDuration(), (Object)o.getDuration(), this::setDuration, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecurityLending _that = (SecurityLending)this.getType().cast(o);
            if (!Objects.equals(this.lenderBorrowerModel, _that.getLenderBorrowerModel())) {
                return false;
            }
            if (!Objects.equals(this.principal, _that.getPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.initiation, _that.getInitiation())) {
                return false;
            }
            if (!Objects.equals(this.termination, _that.getTermination())) {
                return false;
            }
            if (!Objects.equals((Object)this.duration, (Object)_that.getDuration())) {
                return false;
            }
            if (!Objects.equals(this.extensionPeriodModel, _that.getExtensionPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.securityLendingSequence0, _that.getSecurityLendingSequence0())) {
                return false;
            }
            if (!Objects.equals(this.securityLendingSequence1, _that.getSecurityLendingSequence1())) {
                return false;
            }
            if (!Objects.equals(this.rebate, _that.getRebate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.dividendsAndPaymentModel, _that.getDividendsAndPaymentModel())) {
                return false;
            }
            return Objects.equals(this.collateralProvisions, _that.getCollateralProvisions());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lenderBorrowerModel != null ? this.lenderBorrowerModel.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            _result = 31 * _result + (this.initiation != null ? this.initiation.hashCode() : 0);
            _result = 31 * _result + (this.termination != null ? this.termination.hashCode() : 0);
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriodModel != null ? this.extensionPeriodModel.hashCode() : 0);
            _result = 31 * _result + (this.securityLendingSequence0 != null ? this.securityLendingSequence0.hashCode() : 0);
            _result = 31 * _result + (this.securityLendingSequence1 != null ? this.securityLendingSequence1.hashCode() : 0);
            _result = 31 * _result + (this.rebate != null ? this.rebate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.dividendsAndPaymentModel != null ? this.dividendsAndPaymentModel.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityLendingBuilder {lenderBorrowerModel=" + String.valueOf(this.lenderBorrowerModel) + ", principal=" + String.valueOf(this.principal) + ", initiation=" + String.valueOf(this.initiation) + ", termination=" + String.valueOf(this.termination) + ", duration=" + String.valueOf((Object)this.duration) + ", extensionPeriodModel=" + String.valueOf(this.extensionPeriodModel) + ", securityLendingSequence0=" + String.valueOf(this.securityLendingSequence0) + ", securityLendingSequence1=" + String.valueOf(this.securityLendingSequence1) + ", rebate=" + String.valueOf(this.rebate) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", dividendsAndPaymentModel=" + String.valueOf(this.dividendsAndPaymentModel) + ", collateralProvisions=" + String.valueOf(this.collateralProvisions) + "} " + super.toString();
        }
    }

    public static interface SecurityLendingBuilder
    extends SecurityLending,
    Product.ProductBuilder {
        public LenderBorrowerModel.LenderBorrowerModelBuilder getOrCreateLenderBorrowerModel();

        @Override
        public LenderBorrowerModel.LenderBorrowerModelBuilder getLenderBorrowerModel();

        public SecurityValuation.SecurityValuationBuilder getOrCreatePrincipal();

        @Override
        public SecurityValuation.SecurityValuationBuilder getPrincipal();

        public SecLendInitiation.SecLendInitiationBuilder getOrCreateInitiation();

        @Override
        public SecLendInitiation.SecLendInitiationBuilder getInitiation();

        public SecLendTermination.SecLendTerminationBuilder getOrCreateTermination();

        @Override
        public SecLendTermination.SecLendTerminationBuilder getTermination();

        public ExtensionPeriodModel.ExtensionPeriodModelBuilder getOrCreateExtensionPeriodModel();

        @Override
        public ExtensionPeriodModel.ExtensionPeriodModelBuilder getExtensionPeriodModel();

        public SecurityLendingSequence0.SecurityLendingSequence0Builder getOrCreateSecurityLendingSequence0();

        @Override
        public SecurityLendingSequence0.SecurityLendingSequence0Builder getSecurityLendingSequence0();

        public SecurityLendingSequence1.SecurityLendingSequence1Builder getOrCreateSecurityLendingSequence1();

        @Override
        public SecurityLendingSequence1.SecurityLendingSequence1Builder getSecurityLendingSequence1();

        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getOrCreateRebate();

        @Override
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getRebate();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public DividendsAndPaymentModel.DividendsAndPaymentModelBuilder getOrCreateDividendsAndPaymentModel();

        @Override
        public DividendsAndPaymentModel.DividendsAndPaymentModelBuilder getDividendsAndPaymentModel();

        public SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder getOrCreateCollateralProvisions();

        @Override
        public SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder getCollateralProvisions();

        @Override
        public SecurityLendingBuilder setProductModel(ProductModel var1);

        @Override
        public SecurityLendingBuilder setId(String var1);

        public SecurityLendingBuilder setLenderBorrowerModel(LenderBorrowerModel var1);

        public SecurityLendingBuilder setPrincipal(SecurityValuation var1);

        public SecurityLendingBuilder setInitiation(SecLendInitiation var1);

        public SecurityLendingBuilder setTermination(SecLendTermination var1);

        public SecurityLendingBuilder setDuration(SecurityLendingDurationEnum var1);

        public SecurityLendingBuilder setExtensionPeriodModel(ExtensionPeriodModel var1);

        public SecurityLendingBuilder setSecurityLendingSequence0(SecurityLendingSequence0 var1);

        public SecurityLendingBuilder setSecurityLendingSequence1(SecurityLendingSequence1 var1);

        public SecurityLendingBuilder setRebate(SecLendRebateCalculation var1);

        public SecurityLendingBuilder setDayCountFraction(DayCountFraction var1);

        public SecurityLendingBuilder setDividendsAndPaymentModel(DividendsAndPaymentModel var1);

        public SecurityLendingBuilder setCollateralProvisions(SecLendCollateralProvisions var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderBorrowerModel"), processor, LenderBorrowerModel.LenderBorrowerModelBuilder.class, this.getLenderBorrowerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principal"), processor, SecurityValuation.SecurityValuationBuilder.class, this.getPrincipal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initiation"), processor, SecLendInitiation.SecLendInitiationBuilder.class, this.getInitiation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("termination"), processor, SecLendTermination.SecLendTerminationBuilder.class, this.getTermination(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("duration"), SecurityLendingDurationEnum.class, (Object)this.getDuration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extensionPeriodModel"), processor, ExtensionPeriodModel.ExtensionPeriodModelBuilder.class, this.getExtensionPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityLendingSequence0"), processor, SecurityLendingSequence0.SecurityLendingSequence0Builder.class, this.getSecurityLendingSequence0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityLendingSequence1"), processor, SecurityLendingSequence1.SecurityLendingSequence1Builder.class, this.getSecurityLendingSequence1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rebate"), processor, SecLendRebateCalculation.SecLendRebateCalculationBuilder.class, this.getRebate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendsAndPaymentModel"), processor, DividendsAndPaymentModel.DividendsAndPaymentModelBuilder.class, this.getDividendsAndPaymentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralProvisions"), processor, SecLendCollateralProvisions.SecLendCollateralProvisionsBuilder.class, this.getCollateralProvisions(), new AttributeMeta[0]);
        }

        @Override
        public SecurityLendingBuilder prune();
    }

    public static class SecurityLendingImpl
    extends Product.ProductImpl
    implements SecurityLending {
        private final LenderBorrowerModel lenderBorrowerModel;
        private final SecurityValuation principal;
        private final SecLendInitiation initiation;
        private final SecLendTermination termination;
        private final SecurityLendingDurationEnum duration;
        private final ExtensionPeriodModel extensionPeriodModel;
        private final SecurityLendingSequence0 securityLendingSequence0;
        private final SecurityLendingSequence1 securityLendingSequence1;
        private final SecLendRebateCalculation rebate;
        private final DayCountFraction dayCountFraction;
        private final DividendsAndPaymentModel dividendsAndPaymentModel;
        private final SecLendCollateralProvisions collateralProvisions;

        protected SecurityLendingImpl(SecurityLendingBuilder builder) {
            super(builder);
            this.lenderBorrowerModel = Optional.ofNullable(builder.getLenderBorrowerModel()).map(f -> f.build()).orElse(null);
            this.principal = Optional.ofNullable(builder.getPrincipal()).map(f -> f.build()).orElse(null);
            this.initiation = Optional.ofNullable(builder.getInitiation()).map(f -> f.build()).orElse(null);
            this.termination = Optional.ofNullable(builder.getTermination()).map(f -> f.build()).orElse(null);
            this.duration = builder.getDuration();
            this.extensionPeriodModel = Optional.ofNullable(builder.getExtensionPeriodModel()).map(f -> f.build()).orElse(null);
            this.securityLendingSequence0 = Optional.ofNullable(builder.getSecurityLendingSequence0()).map(f -> f.build()).orElse(null);
            this.securityLendingSequence1 = Optional.ofNullable(builder.getSecurityLendingSequence1()).map(f -> f.build()).orElse(null);
            this.rebate = Optional.ofNullable(builder.getRebate()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.dividendsAndPaymentModel = Optional.ofNullable(builder.getDividendsAndPaymentModel()).map(f -> f.build()).orElse(null);
            this.collateralProvisions = Optional.ofNullable(builder.getCollateralProvisions()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="lenderBorrowerModel", isRequired=true)
        @RuneAttribute(value="lenderBorrowerModel", isRequired=true)
        public LenderBorrowerModel getLenderBorrowerModel() {
            return this.lenderBorrowerModel;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public SecurityValuation getPrincipal() {
            return this.principal;
        }

        @Override
        @RosettaAttribute(value="initiation", isRequired=true)
        @RuneAttribute(value="initiation", isRequired=true)
        public SecLendInitiation getInitiation() {
            return this.initiation;
        }

        @Override
        @RosettaAttribute(value="termination")
        @RuneAttribute(value="termination")
        public SecLendTermination getTermination() {
            return this.termination;
        }

        @Override
        @RosettaAttribute(value="duration", isRequired=true)
        @RuneAttribute(value="duration", isRequired=true)
        public SecurityLendingDurationEnum getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="extensionPeriodModel")
        @RuneAttribute(value="extensionPeriodModel")
        public ExtensionPeriodModel getExtensionPeriodModel() {
            return this.extensionPeriodModel;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence0")
        @RuneAttribute(value="securityLendingSequence0")
        public SecurityLendingSequence0 getSecurityLendingSequence0() {
            return this.securityLendingSequence0;
        }

        @Override
        @RosettaAttribute(value="securityLendingSequence1")
        @RuneAttribute(value="securityLendingSequence1")
        public SecurityLendingSequence1 getSecurityLendingSequence1() {
            return this.securityLendingSequence1;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecLendRebateCalculation getRebate() {
            return this.rebate;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="dividendsAndPaymentModel", isRequired=true)
        @RuneAttribute(value="dividendsAndPaymentModel", isRequired=true)
        public DividendsAndPaymentModel getDividendsAndPaymentModel() {
            return this.dividendsAndPaymentModel;
        }

        @Override
        @RosettaAttribute(value="collateralProvisions", isRequired=true)
        @RuneAttribute(value="collateralProvisions", isRequired=true)
        public SecLendCollateralProvisions getCollateralProvisions() {
            return this.collateralProvisions;
        }

        @Override
        public SecurityLending build() {
            return this;
        }

        @Override
        public SecurityLendingBuilder toBuilder() {
            SecurityLendingBuilder builder = SecurityLending.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityLendingBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLenderBorrowerModel()).ifPresent(builder::setLenderBorrowerModel);
            Optional.ofNullable(this.getPrincipal()).ifPresent(builder::setPrincipal);
            Optional.ofNullable(this.getInitiation()).ifPresent(builder::setInitiation);
            Optional.ofNullable(this.getTermination()).ifPresent(builder::setTermination);
            Optional.ofNullable(this.getDuration()).ifPresent(builder::setDuration);
            Optional.ofNullable(this.getExtensionPeriodModel()).ifPresent(builder::setExtensionPeriodModel);
            Optional.ofNullable(this.getSecurityLendingSequence0()).ifPresent(builder::setSecurityLendingSequence0);
            Optional.ofNullable(this.getSecurityLendingSequence1()).ifPresent(builder::setSecurityLendingSequence1);
            Optional.ofNullable(this.getRebate()).ifPresent(builder::setRebate);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getDividendsAndPaymentModel()).ifPresent(builder::setDividendsAndPaymentModel);
            Optional.ofNullable(this.getCollateralProvisions()).ifPresent(builder::setCollateralProvisions);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecurityLending _that = (SecurityLending)this.getType().cast(o);
            if (!Objects.equals(this.lenderBorrowerModel, _that.getLenderBorrowerModel())) {
                return false;
            }
            if (!Objects.equals(this.principal, _that.getPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.initiation, _that.getInitiation())) {
                return false;
            }
            if (!Objects.equals(this.termination, _that.getTermination())) {
                return false;
            }
            if (!Objects.equals((Object)this.duration, (Object)_that.getDuration())) {
                return false;
            }
            if (!Objects.equals(this.extensionPeriodModel, _that.getExtensionPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.securityLendingSequence0, _that.getSecurityLendingSequence0())) {
                return false;
            }
            if (!Objects.equals(this.securityLendingSequence1, _that.getSecurityLendingSequence1())) {
                return false;
            }
            if (!Objects.equals(this.rebate, _that.getRebate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.dividendsAndPaymentModel, _that.getDividendsAndPaymentModel())) {
                return false;
            }
            return Objects.equals(this.collateralProvisions, _that.getCollateralProvisions());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lenderBorrowerModel != null ? this.lenderBorrowerModel.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            _result = 31 * _result + (this.initiation != null ? this.initiation.hashCode() : 0);
            _result = 31 * _result + (this.termination != null ? this.termination.hashCode() : 0);
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriodModel != null ? this.extensionPeriodModel.hashCode() : 0);
            _result = 31 * _result + (this.securityLendingSequence0 != null ? this.securityLendingSequence0.hashCode() : 0);
            _result = 31 * _result + (this.securityLendingSequence1 != null ? this.securityLendingSequence1.hashCode() : 0);
            _result = 31 * _result + (this.rebate != null ? this.rebate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.dividendsAndPaymentModel != null ? this.dividendsAndPaymentModel.hashCode() : 0);
            _result = 31 * _result + (this.collateralProvisions != null ? this.collateralProvisions.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityLending {lenderBorrowerModel=" + String.valueOf(this.lenderBorrowerModel) + ", principal=" + String.valueOf(this.principal) + ", initiation=" + String.valueOf(this.initiation) + ", termination=" + String.valueOf(this.termination) + ", duration=" + String.valueOf((Object)this.duration) + ", extensionPeriodModel=" + String.valueOf(this.extensionPeriodModel) + ", securityLendingSequence0=" + String.valueOf(this.securityLendingSequence0) + ", securityLendingSequence1=" + String.valueOf(this.securityLendingSequence1) + ", rebate=" + String.valueOf(this.rebate) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", dividendsAndPaymentModel=" + String.valueOf(this.dividendsAndPaymentModel) + ", collateralProvisions=" + String.valueOf(this.collateralProvisions) + "} " + super.toString();
        }
    }
}

