/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.asset.PriceQuoteUnits;
import fpml.consolidated.riskdef.AssetOrTermPointOrPricingStructureReference;
import fpml.consolidated.riskdef.TermPointReference;
import fpml.consolidated.riskdef.meta.PricingParameterShiftMeta;
import fpml.consolidated.shared.PricingStructureReference;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PricingParameterShift", builder=PricingParameterShiftBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PricingParameterShift", model="fpml", builder=PricingParameterShiftBuilderImpl.class, version="1.2.2")
public interface PricingParameterShift
extends RosettaModelObject {
    public static final PricingParameterShiftMeta metaData = new PricingParameterShiftMeta();

    public AssetOrTermPointOrPricingStructureReference getParameterReference();

    public AssetReference getAssetReference();

    public TermPointReference getTermPointReference();

    public PricingStructureReference getPricingStructureReference();

    public BigDecimal getShift();

    public PriceQuoteUnits getShiftUnits();

    public String getId();

    public PricingParameterShift build();

    public PricingParameterShiftBuilder toBuilder();

    public static PricingParameterShiftBuilder builder() {
        return new PricingParameterShiftBuilderImpl();
    }

    default public RosettaMetaData<? extends PricingParameterShift> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PricingParameterShift> getType() {
        return PricingParameterShift.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("parameterReference"), processor, AssetOrTermPointOrPricingStructureReference.class, this.getParameterReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.class, this.getAssetReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("termPointReference"), processor, TermPointReference.class, this.getTermPointReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.class, this.getPricingStructureReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("shift"), BigDecimal.class, (Object)this.getShift(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("shiftUnits"), processor, PriceQuoteUnits.class, this.getShiftUnits(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PricingParameterShiftBuilderImpl
    implements PricingParameterShiftBuilder {
        protected AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder parameterReference;
        protected AssetReference.AssetReferenceBuilder assetReference;
        protected TermPointReference.TermPointReferenceBuilder termPointReference;
        protected PricingStructureReference.PricingStructureReferenceBuilder pricingStructureReference;
        protected BigDecimal shift;
        protected PriceQuoteUnits.PriceQuoteUnitsBuilder shiftUnits;
        protected String id;

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getParameterReference() {
            return this.parameterReference;
        }

        @Override
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getOrCreateParameterReference() {
            AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder result = this.parameterReference != null ? this.parameterReference : (this.parameterReference = AssetOrTermPointOrPricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public AssetReference.AssetReferenceBuilder getAssetReference() {
            return this.assetReference;
        }

        @Override
        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference() {
            AssetReference.AssetReferenceBuilder result = this.assetReference != null ? this.assetReference : (this.assetReference = AssetReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public TermPointReference.TermPointReferenceBuilder getTermPointReference() {
            return this.termPointReference;
        }

        @Override
        public TermPointReference.TermPointReferenceBuilder getOrCreateTermPointReference() {
            TermPointReference.TermPointReferenceBuilder result = this.termPointReference != null ? this.termPointReference : (this.termPointReference = TermPointReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.pricingStructureReference != null ? this.pricingStructureReference : (this.pricingStructureReference = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public BigDecimal getShift() {
            return this.shift;
        }

        @Override
        @RosettaAttribute(value="shiftUnits")
        @RuneAttribute(value="shiftUnits")
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getShiftUnits() {
            return this.shiftUnits;
        }

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateShiftUnits() {
            PriceQuoteUnits.PriceQuoteUnitsBuilder result = this.shiftUnits != null ? this.shiftUnits : (this.shiftUnits = PriceQuoteUnits.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public PricingParameterShiftBuilder setParameterReference(AssetOrTermPointOrPricingStructureReference _parameterReference) {
            this.parameterReference = _parameterReference == null ? null : _parameterReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public PricingParameterShiftBuilder setAssetReference(AssetReference _assetReference) {
            this.assetReference = _assetReference == null ? null : _assetReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public PricingParameterShiftBuilder setTermPointReference(TermPointReference _termPointReference) {
            this.termPointReference = _termPointReference == null ? null : _termPointReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingParameterShiftBuilder setPricingStructureReference(PricingStructureReference _pricingStructureReference) {
            this.pricingStructureReference = _pricingStructureReference == null ? null : _pricingStructureReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public PricingParameterShiftBuilder setShift(BigDecimal _shift) {
            this.shift = _shift == null ? null : _shift;
            return this;
        }

        @Override
        @RosettaAttribute(value="shiftUnits")
        @RuneAttribute(value="shiftUnits")
        public PricingParameterShiftBuilder setShiftUnits(PriceQuoteUnits _shiftUnits) {
            this.shiftUnits = _shiftUnits == null ? null : _shiftUnits.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PricingParameterShiftBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public PricingParameterShift build() {
            return new PricingParameterShiftImpl(this);
        }

        @Override
        public PricingParameterShiftBuilder toBuilder() {
            return this;
        }

        @Override
        public PricingParameterShiftBuilder prune() {
            if (this.parameterReference != null && !this.parameterReference.prune().hasData()) {
                this.parameterReference = null;
            }
            if (this.assetReference != null && !this.assetReference.prune().hasData()) {
                this.assetReference = null;
            }
            if (this.termPointReference != null && !this.termPointReference.prune().hasData()) {
                this.termPointReference = null;
            }
            if (this.pricingStructureReference != null && !this.pricingStructureReference.prune().hasData()) {
                this.pricingStructureReference = null;
            }
            if (this.shiftUnits != null && !this.shiftUnits.prune().hasData()) {
                this.shiftUnits = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParameterReference() != null && this.getParameterReference().hasData()) {
                return true;
            }
            if (this.getAssetReference() != null && this.getAssetReference().hasData()) {
                return true;
            }
            if (this.getTermPointReference() != null && this.getTermPointReference().hasData()) {
                return true;
            }
            if (this.getPricingStructureReference() != null && this.getPricingStructureReference().hasData()) {
                return true;
            }
            if (this.getShift() != null) {
                return true;
            }
            if (this.getShiftUnits() != null && this.getShiftUnits().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public PricingParameterShiftBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PricingParameterShiftBuilder o = (PricingParameterShiftBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParameterReference(), (RosettaModelObjectBuilder)o.getParameterReference(), this::setParameterReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssetReference(), (RosettaModelObjectBuilder)o.getAssetReference(), this::setAssetReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTermPointReference(), (RosettaModelObjectBuilder)o.getTermPointReference(), this::setTermPointReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingStructureReference(), (RosettaModelObjectBuilder)o.getPricingStructureReference(), this::setPricingStructureReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getShiftUnits(), (RosettaModelObjectBuilder)o.getShiftUnits(), this::setShiftUnits);
            merger.mergeBasic((Object)this.getShift(), (Object)o.getShift(), this::setShift, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingParameterShift _that = this.getType().cast(o);
            if (!Objects.equals(this.parameterReference, _that.getParameterReference())) {
                return false;
            }
            if (!Objects.equals(this.assetReference, _that.getAssetReference())) {
                return false;
            }
            if (!Objects.equals(this.termPointReference, _that.getTermPointReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            if (!Objects.equals(this.shift, _that.getShift())) {
                return false;
            }
            if (!Objects.equals(this.shiftUnits, _that.getShiftUnits())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.parameterReference != null ? this.parameterReference.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            _result = 31 * _result + (this.termPointReference != null ? this.termPointReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.shift != null ? this.shift.hashCode() : 0);
            _result = 31 * _result + (this.shiftUnits != null ? this.shiftUnits.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingParameterShiftBuilder {parameterReference=" + String.valueOf(this.parameterReference) + ", assetReference=" + String.valueOf(this.assetReference) + ", termPointReference=" + String.valueOf(this.termPointReference) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", shift=" + String.valueOf(this.shift) + ", shiftUnits=" + String.valueOf(this.shiftUnits) + ", id=" + this.id + "}";
        }
    }

    public static interface PricingParameterShiftBuilder
    extends PricingParameterShift,
    RosettaModelObjectBuilder {
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getOrCreateParameterReference();

        @Override
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getParameterReference();

        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference();

        @Override
        public AssetReference.AssetReferenceBuilder getAssetReference();

        public TermPointReference.TermPointReferenceBuilder getOrCreateTermPointReference();

        @Override
        public TermPointReference.TermPointReferenceBuilder getTermPointReference();

        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference();

        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateShiftUnits();

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getShiftUnits();

        public PricingParameterShiftBuilder setParameterReference(AssetOrTermPointOrPricingStructureReference var1);

        public PricingParameterShiftBuilder setAssetReference(AssetReference var1);

        public PricingParameterShiftBuilder setTermPointReference(TermPointReference var1);

        public PricingParameterShiftBuilder setPricingStructureReference(PricingStructureReference var1);

        public PricingParameterShiftBuilder setShift(BigDecimal var1);

        public PricingParameterShiftBuilder setShiftUnits(PriceQuoteUnits var1);

        public PricingParameterShiftBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("parameterReference"), processor, AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder.class, this.getParameterReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.AssetReferenceBuilder.class, this.getAssetReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("termPointReference"), processor, TermPointReference.TermPointReferenceBuilder.class, this.getTermPointReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getPricingStructureReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("shift"), BigDecimal.class, (Object)this.getShift(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("shiftUnits"), processor, PriceQuoteUnits.PriceQuoteUnitsBuilder.class, this.getShiftUnits(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PricingParameterShiftBuilder prune();
    }

    public static class PricingParameterShiftImpl
    implements PricingParameterShift {
        private final AssetOrTermPointOrPricingStructureReference parameterReference;
        private final AssetReference assetReference;
        private final TermPointReference termPointReference;
        private final PricingStructureReference pricingStructureReference;
        private final BigDecimal shift;
        private final PriceQuoteUnits shiftUnits;
        private final String id;

        protected PricingParameterShiftImpl(PricingParameterShiftBuilder builder) {
            this.parameterReference = Optional.ofNullable(builder.getParameterReference()).map(f -> f.build()).orElse(null);
            this.assetReference = Optional.ofNullable(builder.getAssetReference()).map(f -> f.build()).orElse(null);
            this.termPointReference = Optional.ofNullable(builder.getTermPointReference()).map(f -> f.build()).orElse(null);
            this.pricingStructureReference = Optional.ofNullable(builder.getPricingStructureReference()).map(f -> f.build()).orElse(null);
            this.shift = builder.getShift();
            this.shiftUnits = Optional.ofNullable(builder.getShiftUnits()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public AssetOrTermPointOrPricingStructureReference getParameterReference() {
            return this.parameterReference;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public AssetReference getAssetReference() {
            return this.assetReference;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public TermPointReference getTermPointReference() {
            return this.termPointReference;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public BigDecimal getShift() {
            return this.shift;
        }

        @Override
        @RosettaAttribute(value="shiftUnits")
        @RuneAttribute(value="shiftUnits")
        public PriceQuoteUnits getShiftUnits() {
            return this.shiftUnits;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public PricingParameterShift build() {
            return this;
        }

        @Override
        public PricingParameterShiftBuilder toBuilder() {
            PricingParameterShiftBuilder builder = PricingParameterShift.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PricingParameterShiftBuilder builder) {
            Optional.ofNullable(this.getParameterReference()).ifPresent(builder::setParameterReference);
            Optional.ofNullable(this.getAssetReference()).ifPresent(builder::setAssetReference);
            Optional.ofNullable(this.getTermPointReference()).ifPresent(builder::setTermPointReference);
            Optional.ofNullable(this.getPricingStructureReference()).ifPresent(builder::setPricingStructureReference);
            Optional.ofNullable(this.getShift()).ifPresent(builder::setShift);
            Optional.ofNullable(this.getShiftUnits()).ifPresent(builder::setShiftUnits);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingParameterShift _that = this.getType().cast(o);
            if (!Objects.equals(this.parameterReference, _that.getParameterReference())) {
                return false;
            }
            if (!Objects.equals(this.assetReference, _that.getAssetReference())) {
                return false;
            }
            if (!Objects.equals(this.termPointReference, _that.getTermPointReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            if (!Objects.equals(this.shift, _that.getShift())) {
                return false;
            }
            if (!Objects.equals(this.shiftUnits, _that.getShiftUnits())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.parameterReference != null ? this.parameterReference.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            _result = 31 * _result + (this.termPointReference != null ? this.termPointReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.shift != null ? this.shift.hashCode() : 0);
            _result = 31 * _result + (this.shiftUnits != null ? this.shiftUnits.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingParameterShift {parameterReference=" + String.valueOf(this.parameterReference) + ", assetReference=" + String.valueOf(this.assetReference) + ", termPointReference=" + String.valueOf(this.termPointReference) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", shift=" + String.valueOf(this.shift) + ", shiftUnits=" + String.valueOf(this.shiftUnits) + ", id=" + this.id + "}";
        }
    }
}

