/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.repo.BondCollateralModel;
import fpml.consolidated.repo.meta.CollateralValuationMeta;
import fpml.consolidated.shared.UnitContractModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralValuation", builder=CollateralValuationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CollateralValuation", model="fpml", builder=CollateralValuationBuilderImpl.class, version="1.2.2")
public interface CollateralValuation
extends RosettaModelObject {
    public static final CollateralValuationMeta metaData = new CollateralValuationMeta();

    public BondCollateralModel getBondCollateralModel();

    public UnitContractModel getUnitContractModel();

    public AssetReference getAssetReference();

    public CollateralValuation build();

    public CollateralValuationBuilder toBuilder();

    public static CollateralValuationBuilder builder() {
        return new CollateralValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralValuation> getType() {
        return CollateralValuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("bondCollateralModel"), processor, BondCollateralModel.class, this.getBondCollateralModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unitContractModel"), processor, UnitContractModel.class, this.getUnitContractModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.class, this.getAssetReference(), new AttributeMeta[0]);
    }

    public static class CollateralValuationBuilderImpl
    implements CollateralValuationBuilder {
        protected BondCollateralModel.BondCollateralModelBuilder bondCollateralModel;
        protected UnitContractModel.UnitContractModelBuilder unitContractModel;
        protected AssetReference.AssetReferenceBuilder assetReference;

        @Override
        @RosettaAttribute(value="bondCollateralModel")
        @RuneAttribute(value="bondCollateralModel")
        public BondCollateralModel.BondCollateralModelBuilder getBondCollateralModel() {
            return this.bondCollateralModel;
        }

        @Override
        public BondCollateralModel.BondCollateralModelBuilder getOrCreateBondCollateralModel() {
            BondCollateralModel.BondCollateralModelBuilder result = this.bondCollateralModel != null ? this.bondCollateralModel : (this.bondCollateralModel = BondCollateralModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="unitContractModel")
        @RuneAttribute(value="unitContractModel")
        public UnitContractModel.UnitContractModelBuilder getUnitContractModel() {
            return this.unitContractModel;
        }

        @Override
        public UnitContractModel.UnitContractModelBuilder getOrCreateUnitContractModel() {
            UnitContractModel.UnitContractModelBuilder result = this.unitContractModel != null ? this.unitContractModel : (this.unitContractModel = UnitContractModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetReference", isRequired=true)
        @RuneAttribute(value="assetReference", isRequired=true)
        public AssetReference.AssetReferenceBuilder getAssetReference() {
            return this.assetReference;
        }

        @Override
        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference() {
            AssetReference.AssetReferenceBuilder result = this.assetReference != null ? this.assetReference : (this.assetReference = AssetReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bondCollateralModel")
        @RuneAttribute(value="bondCollateralModel")
        public CollateralValuationBuilder setBondCollateralModel(BondCollateralModel _bondCollateralModel) {
            this.bondCollateralModel = _bondCollateralModel == null ? null : _bondCollateralModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="unitContractModel")
        @RuneAttribute(value="unitContractModel")
        public CollateralValuationBuilder setUnitContractModel(UnitContractModel _unitContractModel) {
            this.unitContractModel = _unitContractModel == null ? null : _unitContractModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetReference", isRequired=true)
        @RuneAttribute(value="assetReference", isRequired=true)
        public CollateralValuationBuilder setAssetReference(AssetReference _assetReference) {
            this.assetReference = _assetReference == null ? null : _assetReference.toBuilder();
            return this;
        }

        @Override
        public CollateralValuation build() {
            return new CollateralValuationImpl(this);
        }

        @Override
        public CollateralValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralValuationBuilder prune() {
            if (this.bondCollateralModel != null && !this.bondCollateralModel.prune().hasData()) {
                this.bondCollateralModel = null;
            }
            if (this.unitContractModel != null && !this.unitContractModel.prune().hasData()) {
                this.unitContractModel = null;
            }
            if (this.assetReference != null && !this.assetReference.prune().hasData()) {
                this.assetReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBondCollateralModel() != null && this.getBondCollateralModel().hasData()) {
                return true;
            }
            if (this.getUnitContractModel() != null && this.getUnitContractModel().hasData()) {
                return true;
            }
            return this.getAssetReference() != null && this.getAssetReference().hasData();
        }

        public CollateralValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralValuationBuilder o = (CollateralValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondCollateralModel(), (RosettaModelObjectBuilder)o.getBondCollateralModel(), this::setBondCollateralModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnitContractModel(), (RosettaModelObjectBuilder)o.getUnitContractModel(), this::setUnitContractModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssetReference(), (RosettaModelObjectBuilder)o.getAssetReference(), this::setAssetReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.bondCollateralModel, _that.getBondCollateralModel())) {
                return false;
            }
            if (!Objects.equals(this.unitContractModel, _that.getUnitContractModel())) {
                return false;
            }
            return Objects.equals(this.assetReference, _that.getAssetReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bondCollateralModel != null ? this.bondCollateralModel.hashCode() : 0);
            _result = 31 * _result + (this.unitContractModel != null ? this.unitContractModel.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValuationBuilder {bondCollateralModel=" + String.valueOf(this.bondCollateralModel) + ", unitContractModel=" + String.valueOf(this.unitContractModel) + ", assetReference=" + String.valueOf(this.assetReference) + "}";
        }
    }

    public static interface CollateralValuationBuilder
    extends CollateralValuation,
    RosettaModelObjectBuilder {
        public BondCollateralModel.BondCollateralModelBuilder getOrCreateBondCollateralModel();

        @Override
        public BondCollateralModel.BondCollateralModelBuilder getBondCollateralModel();

        public UnitContractModel.UnitContractModelBuilder getOrCreateUnitContractModel();

        @Override
        public UnitContractModel.UnitContractModelBuilder getUnitContractModel();

        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference();

        @Override
        public AssetReference.AssetReferenceBuilder getAssetReference();

        public CollateralValuationBuilder setBondCollateralModel(BondCollateralModel var1);

        public CollateralValuationBuilder setUnitContractModel(UnitContractModel var1);

        public CollateralValuationBuilder setAssetReference(AssetReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("bondCollateralModel"), processor, BondCollateralModel.BondCollateralModelBuilder.class, this.getBondCollateralModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unitContractModel"), processor, UnitContractModel.UnitContractModelBuilder.class, this.getUnitContractModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.AssetReferenceBuilder.class, this.getAssetReference(), new AttributeMeta[0]);
        }

        public CollateralValuationBuilder prune();
    }

    public static class CollateralValuationImpl
    implements CollateralValuation {
        private final BondCollateralModel bondCollateralModel;
        private final UnitContractModel unitContractModel;
        private final AssetReference assetReference;

        protected CollateralValuationImpl(CollateralValuationBuilder builder) {
            this.bondCollateralModel = Optional.ofNullable(builder.getBondCollateralModel()).map(f -> f.build()).orElse(null);
            this.unitContractModel = Optional.ofNullable(builder.getUnitContractModel()).map(f -> f.build()).orElse(null);
            this.assetReference = Optional.ofNullable(builder.getAssetReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="bondCollateralModel")
        @RuneAttribute(value="bondCollateralModel")
        public BondCollateralModel getBondCollateralModel() {
            return this.bondCollateralModel;
        }

        @Override
        @RosettaAttribute(value="unitContractModel")
        @RuneAttribute(value="unitContractModel")
        public UnitContractModel getUnitContractModel() {
            return this.unitContractModel;
        }

        @Override
        @RosettaAttribute(value="assetReference", isRequired=true)
        @RuneAttribute(value="assetReference", isRequired=true)
        public AssetReference getAssetReference() {
            return this.assetReference;
        }

        @Override
        public CollateralValuation build() {
            return this;
        }

        @Override
        public CollateralValuationBuilder toBuilder() {
            CollateralValuationBuilder builder = CollateralValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralValuationBuilder builder) {
            Optional.ofNullable(this.getBondCollateralModel()).ifPresent(builder::setBondCollateralModel);
            Optional.ofNullable(this.getUnitContractModel()).ifPresent(builder::setUnitContractModel);
            Optional.ofNullable(this.getAssetReference()).ifPresent(builder::setAssetReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.bondCollateralModel, _that.getBondCollateralModel())) {
                return false;
            }
            if (!Objects.equals(this.unitContractModel, _that.getUnitContractModel())) {
                return false;
            }
            return Objects.equals(this.assetReference, _that.getAssetReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bondCollateralModel != null ? this.bondCollateralModel.hashCode() : 0);
            _result = 31 * _result + (this.unitContractModel != null ? this.unitContractModel.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralValuation {bondCollateralModel=" + String.valueOf(this.bondCollateralModel) + ", unitContractModel=" + String.valueOf(this.unitContractModel) + ", assetReference=" + String.valueOf(this.assetReference) + "}";
        }
    }
}

