/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ExecutionVenueType;
import fpml.consolidated.recordkeeping.processes.RegReportingPackageInfo;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassification;
import fpml.consolidated.recordkeeping.processes.ReportingRoleAndPurposeModel;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryClassificationPart43_2019Meta;
import fpml.consolidated.shared.CollateralizationType;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryClassificationPart43_2019", builder=RegulatoryClassificationPart43_2019BuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryClassificationPart43_2019", model="fpml", builder=RegulatoryClassificationPart43_2019BuilderImpl.class, version="1.2.2")
public interface RegulatoryClassificationPart43_2019
extends RegulatoryClassification {
    public static final RegulatoryClassificationPart43_2019Meta metaData = new RegulatoryClassificationPart43_2019Meta();

    public List<String> getSupervisoryBody();

    public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel();

    public Boolean getCancellationOfPublicReporting();

    public String getCleared();

    public Boolean getEndUserException();

    public ExecutionVenueType getExecutionVenueType();

    public CollateralizationType getCollateralizationType();

    public Boolean getOffMarketPrice();

    public Boolean getLargeSizeTrade();

    public PartyReference getClearingService();

    public RegReportingPackageInfo getPackageInfo();

    public ZonedDateTime getDisseminationTime();

    public String getDisseminationId();

    public String getOriginalDisseminationId();

    public Boolean getPostPricedIndicator();

    @Override
    public RegulatoryClassificationPart43_2019 build();

    @Override
    public RegulatoryClassificationPart43_2019Builder toBuilder();

    public static RegulatoryClassificationPart43_2019Builder builder() {
        return new RegulatoryClassificationPart43_2019BuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryClassificationPart43_2019> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryClassificationPart43_2019> getType() {
        return RegulatoryClassificationPart43_2019.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("supervisoryBody"), String.class, this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cancellationOfPublicReporting"), Boolean.class, (Object)this.getCancellationOfPublicReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endUserException"), Boolean.class, (Object)this.getEndUserException(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.class, this.getExecutionVenueType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.class, this.getCollateralizationType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offMarketPrice"), Boolean.class, (Object)this.getOffMarketPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingService"), processor, PartyReference.class, this.getClearingService(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInfo"), processor, RegReportingPackageInfo.class, this.getPackageInfo(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("disseminationTime"), ZonedDateTime.class, (Object)this.getDisseminationTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("disseminationId"), String.class, (Object)this.getDisseminationId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalDisseminationId"), String.class, (Object)this.getOriginalDisseminationId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postPricedIndicator"), Boolean.class, (Object)this.getPostPricedIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RegulatoryClassificationPart43_2019BuilderImpl
    extends RegulatoryClassification.RegulatoryClassificationBuilderImpl
    implements RegulatoryClassificationPart43_2019Builder {
        protected List<String> supervisoryBody = new ArrayList<String>();
        protected ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder reportingRoleAndPurposeModel;
        protected Boolean cancellationOfPublicReporting;
        protected String cleared;
        protected Boolean endUserException;
        protected ExecutionVenueType.ExecutionVenueTypeBuilder executionVenueType;
        protected CollateralizationType.CollateralizationTypeBuilder collateralizationType;
        protected Boolean offMarketPrice;
        protected Boolean largeSizeTrade;
        protected PartyReference.PartyReferenceBuilder clearingService;
        protected RegReportingPackageInfo.RegReportingPackageInfoBuilder packageInfo;
        protected ZonedDateTime disseminationTime;
        protected String disseminationId;
        protected String originalDisseminationId;
        protected Boolean postPricedIndicator;

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<String> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel() {
            ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder result = this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel : (this.reportingRoleAndPurposeModel = ReportingRoleAndPurposeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cancellationOfPublicReporting")
        @RuneAttribute(value="cancellationOfPublicReporting")
        public Boolean getCancellationOfPublicReporting() {
            return this.cancellationOfPublicReporting;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="endUserException")
        @RuneAttribute(value="endUserException")
        public Boolean getEndUserException() {
            return this.endUserException;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType() {
            ExecutionVenueType.ExecutionVenueTypeBuilder result = this.executionVenueType != null ? this.executionVenueType : (this.executionVenueType = ExecutionVenueType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType() {
            CollateralizationType.CollateralizationTypeBuilder result = this.collateralizationType != null ? this.collateralizationType : (this.collateralizationType = CollateralizationType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public Boolean getOffMarketPrice() {
            return this.offMarketPrice;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="clearingService")
        @RuneAttribute(value="clearingService")
        public PartyReference.PartyReferenceBuilder getClearingService() {
            return this.clearingService;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateClearingService() {
            PartyReference.PartyReferenceBuilder result = this.clearingService != null ? this.clearingService : (this.clearingService = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageInfo")
        @RuneAttribute(value="packageInfo")
        public RegReportingPackageInfo.RegReportingPackageInfoBuilder getPackageInfo() {
            return this.packageInfo;
        }

        @Override
        public RegReportingPackageInfo.RegReportingPackageInfoBuilder getOrCreatePackageInfo() {
            RegReportingPackageInfo.RegReportingPackageInfoBuilder result = this.packageInfo != null ? this.packageInfo : (this.packageInfo = RegReportingPackageInfo.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="disseminationTime")
        @RuneAttribute(value="disseminationTime")
        public ZonedDateTime getDisseminationTime() {
            return this.disseminationTime;
        }

        @Override
        @RosettaAttribute(value="disseminationId")
        @RuneAttribute(value="disseminationId")
        public String getDisseminationId() {
            return this.disseminationId;
        }

        @Override
        @RosettaAttribute(value="originalDisseminationId")
        @RuneAttribute(value="originalDisseminationId")
        public String getOriginalDisseminationId() {
            return this.originalDisseminationId;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public Boolean getPostPricedIndicator() {
            return this.postPricedIndicator;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(String _supervisoryBody) {
            if (_supervisoryBody != null) {
                this.supervisoryBody.add(_supervisoryBody);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(String _supervisoryBody, int idx) {
            this.getIndex(this.supervisoryBody, idx, () -> _supervisoryBody);
            return this;
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(List<String> supervisoryBodys) {
            if (supervisoryBodys != null) {
                for (String toAdd : supervisoryBodys) {
                    this.supervisoryBody.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationPart43_2019Builder setSupervisoryBody(List<String> supervisoryBodys) {
            this.supervisoryBody = supervisoryBodys == null ? new ArrayList<String>() : (List)supervisoryBodys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public RegulatoryClassificationPart43_2019Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel _reportingRoleAndPurposeModel) {
            this.reportingRoleAndPurposeModel = _reportingRoleAndPurposeModel == null ? null : _reportingRoleAndPurposeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cancellationOfPublicReporting")
        @RuneAttribute(value="cancellationOfPublicReporting")
        public RegulatoryClassificationPart43_2019Builder setCancellationOfPublicReporting(Boolean _cancellationOfPublicReporting) {
            this.cancellationOfPublicReporting = _cancellationOfPublicReporting == null ? null : _cancellationOfPublicReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public RegulatoryClassificationPart43_2019Builder setCleared(String _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="endUserException")
        @RuneAttribute(value="endUserException")
        public RegulatoryClassificationPart43_2019Builder setEndUserException(Boolean _endUserException) {
            this.endUserException = _endUserException == null ? null : _endUserException;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public RegulatoryClassificationPart43_2019Builder setExecutionVenueType(ExecutionVenueType _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public RegulatoryClassificationPart43_2019Builder setCollateralizationType(CollateralizationType _collateralizationType) {
            this.collateralizationType = _collateralizationType == null ? null : _collateralizationType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public RegulatoryClassificationPart43_2019Builder setOffMarketPrice(Boolean _offMarketPrice) {
            this.offMarketPrice = _offMarketPrice == null ? null : _offMarketPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public RegulatoryClassificationPart43_2019Builder setLargeSizeTrade(Boolean _largeSizeTrade) {
            this.largeSizeTrade = _largeSizeTrade == null ? null : _largeSizeTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingService")
        @RuneAttribute(value="clearingService")
        public RegulatoryClassificationPart43_2019Builder setClearingService(PartyReference _clearingService) {
            this.clearingService = _clearingService == null ? null : _clearingService.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInfo")
        @RuneAttribute(value="packageInfo")
        public RegulatoryClassificationPart43_2019Builder setPackageInfo(RegReportingPackageInfo _packageInfo) {
            this.packageInfo = _packageInfo == null ? null : _packageInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="disseminationTime")
        @RuneAttribute(value="disseminationTime")
        public RegulatoryClassificationPart43_2019Builder setDisseminationTime(ZonedDateTime _disseminationTime) {
            this.disseminationTime = _disseminationTime == null ? null : _disseminationTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="disseminationId")
        @RuneAttribute(value="disseminationId")
        public RegulatoryClassificationPart43_2019Builder setDisseminationId(String _disseminationId) {
            this.disseminationId = _disseminationId == null ? null : _disseminationId;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalDisseminationId")
        @RuneAttribute(value="originalDisseminationId")
        public RegulatoryClassificationPart43_2019Builder setOriginalDisseminationId(String _originalDisseminationId) {
            this.originalDisseminationId = _originalDisseminationId == null ? null : _originalDisseminationId;
            return this;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public RegulatoryClassificationPart43_2019Builder setPostPricedIndicator(Boolean _postPricedIndicator) {
            this.postPricedIndicator = _postPricedIndicator == null ? null : _postPricedIndicator;
            return this;
        }

        @Override
        public RegulatoryClassificationPart43_2019 build() {
            return new RegulatoryClassificationPart43_2019Impl(this);
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder prune() {
            super.prune();
            if (this.reportingRoleAndPurposeModel != null && !this.reportingRoleAndPurposeModel.prune().hasData()) {
                this.reportingRoleAndPurposeModel = null;
            }
            if (this.executionVenueType != null && !this.executionVenueType.prune().hasData()) {
                this.executionVenueType = null;
            }
            if (this.collateralizationType != null && !this.collateralizationType.prune().hasData()) {
                this.collateralizationType = null;
            }
            if (this.clearingService != null && !this.clearingService.prune().hasData()) {
                this.clearingService = null;
            }
            if (this.packageInfo != null && !this.packageInfo.prune().hasData()) {
                this.packageInfo = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSupervisoryBody() != null && !this.getSupervisoryBody().isEmpty()) {
                return true;
            }
            if (this.getReportingRoleAndPurposeModel() != null && this.getReportingRoleAndPurposeModel().hasData()) {
                return true;
            }
            if (this.getCancellationOfPublicReporting() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getEndUserException() != null) {
                return true;
            }
            if (this.getExecutionVenueType() != null && this.getExecutionVenueType().hasData()) {
                return true;
            }
            if (this.getCollateralizationType() != null && this.getCollateralizationType().hasData()) {
                return true;
            }
            if (this.getOffMarketPrice() != null) {
                return true;
            }
            if (this.getLargeSizeTrade() != null) {
                return true;
            }
            if (this.getClearingService() != null && this.getClearingService().hasData()) {
                return true;
            }
            if (this.getPackageInfo() != null && this.getPackageInfo().hasData()) {
                return true;
            }
            if (this.getDisseminationTime() != null) {
                return true;
            }
            if (this.getDisseminationId() != null) {
                return true;
            }
            if (this.getOriginalDisseminationId() != null) {
                return true;
            }
            return this.getPostPricedIndicator() != null;
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryClassificationPart43_2019Builder o = (RegulatoryClassificationPart43_2019Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingRoleAndPurposeModel(), (RosettaModelObjectBuilder)o.getReportingRoleAndPurposeModel(), this::setReportingRoleAndPurposeModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionVenueType(), (RosettaModelObjectBuilder)o.getExecutionVenueType(), this::setExecutionVenueType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralizationType(), (RosettaModelObjectBuilder)o.getCollateralizationType(), this::setCollateralizationType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingService(), (RosettaModelObjectBuilder)o.getClearingService(), this::setClearingService);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInfo(), (RosettaModelObjectBuilder)o.getPackageInfo(), this::setPackageInfo);
            merger.mergeBasic(this.getSupervisoryBody(), o.getSupervisoryBody(), this::addSupervisoryBody);
            merger.mergeBasic((Object)this.getCancellationOfPublicReporting(), (Object)o.getCancellationOfPublicReporting(), this::setCancellationOfPublicReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEndUserException(), (Object)o.getEndUserException(), this::setEndUserException, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffMarketPrice(), (Object)o.getOffMarketPrice(), this::setOffMarketPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLargeSizeTrade(), (Object)o.getLargeSizeTrade(), this::setLargeSizeTrade, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDisseminationTime(), (Object)o.getDisseminationTime(), this::setDisseminationTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDisseminationId(), (Object)o.getDisseminationId(), this::setDisseminationId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalDisseminationId(), (Object)o.getOriginalDisseminationId(), this::setOriginalDisseminationId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostPricedIndicator(), (Object)o.getPostPricedIndicator(), this::setPostPricedIndicator, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationPart43_2019 _that = (RegulatoryClassificationPart43_2019)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.cancellationOfPublicReporting, _that.getCancellationOfPublicReporting())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.endUserException, _that.getEndUserException())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.offMarketPrice, _that.getOffMarketPrice())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.clearingService, _that.getClearingService())) {
                return false;
            }
            if (!Objects.equals(this.packageInfo, _that.getPackageInfo())) {
                return false;
            }
            if (!Objects.equals(this.disseminationTime, _that.getDisseminationTime())) {
                return false;
            }
            if (!Objects.equals(this.disseminationId, _that.getDisseminationId())) {
                return false;
            }
            if (!Objects.equals(this.originalDisseminationId, _that.getOriginalDisseminationId())) {
                return false;
            }
            return Objects.equals(this.postPricedIndicator, _that.getPostPricedIndicator());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.cancellationOfPublicReporting != null ? this.cancellationOfPublicReporting.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.endUserException != null ? this.endUserException.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.offMarketPrice != null ? this.offMarketPrice.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.clearingService != null ? this.clearingService.hashCode() : 0);
            _result = 31 * _result + (this.packageInfo != null ? this.packageInfo.hashCode() : 0);
            _result = 31 * _result + (this.disseminationTime != null ? this.disseminationTime.hashCode() : 0);
            _result = 31 * _result + (this.disseminationId != null ? this.disseminationId.hashCode() : 0);
            _result = 31 * _result + (this.originalDisseminationId != null ? this.originalDisseminationId.hashCode() : 0);
            _result = 31 * _result + (this.postPricedIndicator != null ? this.postPricedIndicator.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationPart43_2019Builder {supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", reportingRoleAndPurposeModel=" + String.valueOf(this.reportingRoleAndPurposeModel) + ", cancellationOfPublicReporting=" + this.cancellationOfPublicReporting + ", cleared=" + this.cleared + ", endUserException=" + this.endUserException + ", executionVenueType=" + String.valueOf(this.executionVenueType) + ", collateralizationType=" + String.valueOf(this.collateralizationType) + ", offMarketPrice=" + this.offMarketPrice + ", largeSizeTrade=" + this.largeSizeTrade + ", clearingService=" + String.valueOf(this.clearingService) + ", packageInfo=" + String.valueOf(this.packageInfo) + ", disseminationTime=" + String.valueOf(this.disseminationTime) + ", disseminationId=" + this.disseminationId + ", originalDisseminationId=" + this.originalDisseminationId + ", postPricedIndicator=" + this.postPricedIndicator + "} " + super.toString();
        }
    }

    public static interface RegulatoryClassificationPart43_2019Builder
    extends RegulatoryClassificationPart43_2019,
    RegulatoryClassification.RegulatoryClassificationBuilder {
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel();

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel();

        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType();

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType();

        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType();

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType();

        public PartyReference.PartyReferenceBuilder getOrCreateClearingService();

        @Override
        public PartyReference.PartyReferenceBuilder getClearingService();

        public RegReportingPackageInfo.RegReportingPackageInfoBuilder getOrCreatePackageInfo();

        @Override
        public RegReportingPackageInfo.RegReportingPackageInfoBuilder getPackageInfo();

        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(String var1);

        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(String var1, int var2);

        public RegulatoryClassificationPart43_2019Builder addSupervisoryBody(List<String> var1);

        public RegulatoryClassificationPart43_2019Builder setSupervisoryBody(List<String> var1);

        public RegulatoryClassificationPart43_2019Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel var1);

        public RegulatoryClassificationPart43_2019Builder setCancellationOfPublicReporting(Boolean var1);

        public RegulatoryClassificationPart43_2019Builder setCleared(String var1);

        public RegulatoryClassificationPart43_2019Builder setEndUserException(Boolean var1);

        public RegulatoryClassificationPart43_2019Builder setExecutionVenueType(ExecutionVenueType var1);

        public RegulatoryClassificationPart43_2019Builder setCollateralizationType(CollateralizationType var1);

        public RegulatoryClassificationPart43_2019Builder setOffMarketPrice(Boolean var1);

        public RegulatoryClassificationPart43_2019Builder setLargeSizeTrade(Boolean var1);

        public RegulatoryClassificationPart43_2019Builder setClearingService(PartyReference var1);

        public RegulatoryClassificationPart43_2019Builder setPackageInfo(RegReportingPackageInfo var1);

        public RegulatoryClassificationPart43_2019Builder setDisseminationTime(ZonedDateTime var1);

        public RegulatoryClassificationPart43_2019Builder setDisseminationId(String var1);

        public RegulatoryClassificationPart43_2019Builder setOriginalDisseminationId(String var1);

        public RegulatoryClassificationPart43_2019Builder setPostPricedIndicator(Boolean var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("supervisoryBody"), String.class, this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cancellationOfPublicReporting"), Boolean.class, (Object)this.getCancellationOfPublicReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), String.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endUserException"), Boolean.class, (Object)this.getEndUserException(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.ExecutionVenueTypeBuilder.class, this.getExecutionVenueType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.CollateralizationTypeBuilder.class, this.getCollateralizationType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offMarketPrice"), Boolean.class, (Object)this.getOffMarketPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingService"), processor, PartyReference.PartyReferenceBuilder.class, this.getClearingService(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInfo"), processor, RegReportingPackageInfo.RegReportingPackageInfoBuilder.class, this.getPackageInfo(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("disseminationTime"), ZonedDateTime.class, (Object)this.getDisseminationTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("disseminationId"), String.class, (Object)this.getDisseminationId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalDisseminationId"), String.class, (Object)this.getOriginalDisseminationId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postPricedIndicator"), Boolean.class, (Object)this.getPostPricedIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder prune();
    }

    public static class RegulatoryClassificationPart43_2019Impl
    extends RegulatoryClassification.RegulatoryClassificationImpl
    implements RegulatoryClassificationPart43_2019 {
        private final List<String> supervisoryBody;
        private final ReportingRoleAndPurposeModel reportingRoleAndPurposeModel;
        private final Boolean cancellationOfPublicReporting;
        private final String cleared;
        private final Boolean endUserException;
        private final ExecutionVenueType executionVenueType;
        private final CollateralizationType collateralizationType;
        private final Boolean offMarketPrice;
        private final Boolean largeSizeTrade;
        private final PartyReference clearingService;
        private final RegReportingPackageInfo packageInfo;
        private final ZonedDateTime disseminationTime;
        private final String disseminationId;
        private final String originalDisseminationId;
        private final Boolean postPricedIndicator;

        protected RegulatoryClassificationPart43_2019Impl(RegulatoryClassificationPart43_2019Builder builder) {
            super(builder);
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.reportingRoleAndPurposeModel = Optional.ofNullable(builder.getReportingRoleAndPurposeModel()).map(f -> f.build()).orElse(null);
            this.cancellationOfPublicReporting = builder.getCancellationOfPublicReporting();
            this.cleared = builder.getCleared();
            this.endUserException = builder.getEndUserException();
            this.executionVenueType = Optional.ofNullable(builder.getExecutionVenueType()).map(f -> f.build()).orElse(null);
            this.collateralizationType = Optional.ofNullable(builder.getCollateralizationType()).map(f -> f.build()).orElse(null);
            this.offMarketPrice = builder.getOffMarketPrice();
            this.largeSizeTrade = builder.getLargeSizeTrade();
            this.clearingService = Optional.ofNullable(builder.getClearingService()).map(f -> f.build()).orElse(null);
            this.packageInfo = Optional.ofNullable(builder.getPackageInfo()).map(f -> f.build()).orElse(null);
            this.disseminationTime = builder.getDisseminationTime();
            this.disseminationId = builder.getDisseminationId();
            this.originalDisseminationId = builder.getOriginalDisseminationId();
            this.postPricedIndicator = builder.getPostPricedIndicator();
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<String> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        @RosettaAttribute(value="cancellationOfPublicReporting")
        @RuneAttribute(value="cancellationOfPublicReporting")
        public Boolean getCancellationOfPublicReporting() {
            return this.cancellationOfPublicReporting;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public String getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="endUserException")
        @RuneAttribute(value="endUserException")
        public Boolean getEndUserException() {
            return this.endUserException;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public Boolean getOffMarketPrice() {
            return this.offMarketPrice;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="clearingService")
        @RuneAttribute(value="clearingService")
        public PartyReference getClearingService() {
            return this.clearingService;
        }

        @Override
        @RosettaAttribute(value="packageInfo")
        @RuneAttribute(value="packageInfo")
        public RegReportingPackageInfo getPackageInfo() {
            return this.packageInfo;
        }

        @Override
        @RosettaAttribute(value="disseminationTime")
        @RuneAttribute(value="disseminationTime")
        public ZonedDateTime getDisseminationTime() {
            return this.disseminationTime;
        }

        @Override
        @RosettaAttribute(value="disseminationId")
        @RuneAttribute(value="disseminationId")
        public String getDisseminationId() {
            return this.disseminationId;
        }

        @Override
        @RosettaAttribute(value="originalDisseminationId")
        @RuneAttribute(value="originalDisseminationId")
        public String getOriginalDisseminationId() {
            return this.originalDisseminationId;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public Boolean getPostPricedIndicator() {
            return this.postPricedIndicator;
        }

        @Override
        public RegulatoryClassificationPart43_2019 build() {
            return this;
        }

        @Override
        public RegulatoryClassificationPart43_2019Builder toBuilder() {
            RegulatoryClassificationPart43_2019Builder builder = RegulatoryClassificationPart43_2019.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryClassificationPart43_2019Builder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getReportingRoleAndPurposeModel()).ifPresent(builder::setReportingRoleAndPurposeModel);
            Optional.ofNullable(this.getCancellationOfPublicReporting()).ifPresent(builder::setCancellationOfPublicReporting);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getEndUserException()).ifPresent(builder::setEndUserException);
            Optional.ofNullable(this.getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
            Optional.ofNullable(this.getCollateralizationType()).ifPresent(builder::setCollateralizationType);
            Optional.ofNullable(this.getOffMarketPrice()).ifPresent(builder::setOffMarketPrice);
            Optional.ofNullable(this.getLargeSizeTrade()).ifPresent(builder::setLargeSizeTrade);
            Optional.ofNullable(this.getClearingService()).ifPresent(builder::setClearingService);
            Optional.ofNullable(this.getPackageInfo()).ifPresent(builder::setPackageInfo);
            Optional.ofNullable(this.getDisseminationTime()).ifPresent(builder::setDisseminationTime);
            Optional.ofNullable(this.getDisseminationId()).ifPresent(builder::setDisseminationId);
            Optional.ofNullable(this.getOriginalDisseminationId()).ifPresent(builder::setOriginalDisseminationId);
            Optional.ofNullable(this.getPostPricedIndicator()).ifPresent(builder::setPostPricedIndicator);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationPart43_2019 _that = (RegulatoryClassificationPart43_2019)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.cancellationOfPublicReporting, _that.getCancellationOfPublicReporting())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.endUserException, _that.getEndUserException())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.offMarketPrice, _that.getOffMarketPrice())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.clearingService, _that.getClearingService())) {
                return false;
            }
            if (!Objects.equals(this.packageInfo, _that.getPackageInfo())) {
                return false;
            }
            if (!Objects.equals(this.disseminationTime, _that.getDisseminationTime())) {
                return false;
            }
            if (!Objects.equals(this.disseminationId, _that.getDisseminationId())) {
                return false;
            }
            if (!Objects.equals(this.originalDisseminationId, _that.getOriginalDisseminationId())) {
                return false;
            }
            return Objects.equals(this.postPricedIndicator, _that.getPostPricedIndicator());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.cancellationOfPublicReporting != null ? this.cancellationOfPublicReporting.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.endUserException != null ? this.endUserException.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.offMarketPrice != null ? this.offMarketPrice.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.clearingService != null ? this.clearingService.hashCode() : 0);
            _result = 31 * _result + (this.packageInfo != null ? this.packageInfo.hashCode() : 0);
            _result = 31 * _result + (this.disseminationTime != null ? this.disseminationTime.hashCode() : 0);
            _result = 31 * _result + (this.disseminationId != null ? this.disseminationId.hashCode() : 0);
            _result = 31 * _result + (this.originalDisseminationId != null ? this.originalDisseminationId.hashCode() : 0);
            _result = 31 * _result + (this.postPricedIndicator != null ? this.postPricedIndicator.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationPart43_2019 {supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", reportingRoleAndPurposeModel=" + String.valueOf(this.reportingRoleAndPurposeModel) + ", cancellationOfPublicReporting=" + this.cancellationOfPublicReporting + ", cleared=" + this.cleared + ", endUserException=" + this.endUserException + ", executionVenueType=" + String.valueOf(this.executionVenueType) + ", collateralizationType=" + String.valueOf(this.collateralizationType) + ", offMarketPrice=" + this.offMarketPrice + ", largeSizeTrade=" + this.largeSizeTrade + ", clearingService=" + String.valueOf(this.clearingService) + ", packageInfo=" + String.valueOf(this.packageInfo) + ", disseminationTime=" + String.valueOf(this.disseminationTime) + ", disseminationId=" + this.disseminationId + ", originalDisseminationId=" + this.originalDisseminationId + ", postPricedIndicator=" + this.postPricedIndicator + "} " + super.toString();
        }
    }
}

