/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.option.shared.StrategyFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StrategyFeatureChoice")
@ImplementedBy(value=Default.class)
public interface StrategyFeatureChoice
extends Validator<StrategyFeature> {
    public static final String NAME = "StrategyFeatureChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements StrategyFeatureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrategyFeature strategyFeature) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StrategyFeatureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrategyFeature strategyFeature) {
            ComparisonResult result = this.executeDataRule(strategyFeature);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StrategyFeatureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StrategyFeature", (RosettaPath)path, (String)StrategyFeatureChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StrategyFeatureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StrategyFeature", (RosettaPath)path, (String)StrategyFeatureChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StrategyFeature strategyFeature) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)strategyFeature), Arrays.asList("strikeSpread", "calendarSpread"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

