/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.SignatureType;
import fpml.consolidated.msg.ImplementationSpecification;
import fpml.consolidated.msg.MessageAddress;
import fpml.consolidated.msg.PartyMessageInformation;
import fpml.consolidated.msg.meta.MessageHeaderModelMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MessageHeaderModel", builder=MessageHeaderModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="MessageHeaderModel", model="fpml", builder=MessageHeaderModelBuilderImpl.class, version="1.2.2")
public interface MessageHeaderModel
extends RosettaModelObject {
    public static final MessageHeaderModelMeta metaData = new MessageHeaderModelMeta();

    public MessageAddress getSentBy();

    public List<? extends MessageAddress> getSendTo();

    public List<? extends MessageAddress> getCopyTo();

    public ZonedDateTime getCreationTimestamp();

    public ZonedDateTime getExpiryTimestamp();

    public ImplementationSpecification getImplementationSpecification();

    public List<? extends PartyMessageInformation> getPartyMessageInformation();

    public List<? extends SignatureType> getSignature();

    public MessageHeaderModel build();

    public MessageHeaderModelBuilder toBuilder();

    public static MessageHeaderModelBuilder builder() {
        return new MessageHeaderModelBuilderImpl();
    }

    default public RosettaMetaData<? extends MessageHeaderModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MessageHeaderModel> getType() {
        return MessageHeaderModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("sentBy"), processor, MessageAddress.class, this.getSentBy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sendTo"), processor, MessageAddress.class, this.getSendTo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("copyTo"), processor, MessageAddress.class, this.getCopyTo(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creationTimestamp"), ZonedDateTime.class, (Object)this.getCreationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiryTimestamp"), ZonedDateTime.class, (Object)this.getExpiryTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("implementationSpecification"), processor, ImplementationSpecification.class, this.getImplementationSpecification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyMessageInformation"), processor, PartyMessageInformation.class, this.getPartyMessageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("signature"), processor, SignatureType.class, this.getSignature(), new AttributeMeta[0]);
    }

    public static class MessageHeaderModelBuilderImpl
    implements MessageHeaderModelBuilder {
        protected MessageAddress.MessageAddressBuilder sentBy;
        protected List<MessageAddress.MessageAddressBuilder> sendTo = new ArrayList<MessageAddress.MessageAddressBuilder>();
        protected List<MessageAddress.MessageAddressBuilder> copyTo = new ArrayList<MessageAddress.MessageAddressBuilder>();
        protected ZonedDateTime creationTimestamp;
        protected ZonedDateTime expiryTimestamp;
        protected ImplementationSpecification.ImplementationSpecificationBuilder implementationSpecification;
        protected List<PartyMessageInformation.PartyMessageInformationBuilder> partyMessageInformation = new ArrayList<PartyMessageInformation.PartyMessageInformationBuilder>();
        protected List<SignatureType.SignatureTypeBuilder> signature = new ArrayList<SignatureType.SignatureTypeBuilder>();

        @Override
        @RosettaAttribute(value="sentBy")
        @RuneAttribute(value="sentBy")
        public MessageAddress.MessageAddressBuilder getSentBy() {
            return this.sentBy;
        }

        @Override
        public MessageAddress.MessageAddressBuilder getOrCreateSentBy() {
            MessageAddress.MessageAddressBuilder result = this.sentBy != null ? this.sentBy : (this.sentBy = MessageAddress.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sendTo")
        @RuneAttribute(value="sendTo")
        public List<? extends MessageAddress.MessageAddressBuilder> getSendTo() {
            return this.sendTo;
        }

        @Override
        public MessageAddress.MessageAddressBuilder getOrCreateSendTo(int index) {
            if (this.sendTo == null) {
                this.sendTo = new ArrayList<MessageAddress.MessageAddressBuilder>();
            }
            return (MessageAddress.MessageAddressBuilder)this.getIndex(this.sendTo, index, () -> {
                MessageAddress.MessageAddressBuilder newSendTo = MessageAddress.builder();
                return newSendTo;
            });
        }

        @Override
        @RosettaAttribute(value="copyTo")
        @RuneAttribute(value="copyTo")
        public List<? extends MessageAddress.MessageAddressBuilder> getCopyTo() {
            return this.copyTo;
        }

        @Override
        public MessageAddress.MessageAddressBuilder getOrCreateCopyTo(int index) {
            if (this.copyTo == null) {
                this.copyTo = new ArrayList<MessageAddress.MessageAddressBuilder>();
            }
            return (MessageAddress.MessageAddressBuilder)this.getIndex(this.copyTo, index, () -> {
                MessageAddress.MessageAddressBuilder newCopyTo = MessageAddress.builder();
                return newCopyTo;
            });
        }

        @Override
        @RosettaAttribute(value="creationTimestamp")
        @RuneAttribute(value="creationTimestamp")
        public ZonedDateTime getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        @RosettaAttribute(value="expiryTimestamp")
        @RuneAttribute(value="expiryTimestamp")
        public ZonedDateTime getExpiryTimestamp() {
            return this.expiryTimestamp;
        }

        @Override
        @RosettaAttribute(value="implementationSpecification")
        @RuneAttribute(value="implementationSpecification")
        public ImplementationSpecification.ImplementationSpecificationBuilder getImplementationSpecification() {
            return this.implementationSpecification;
        }

        @Override
        public ImplementationSpecification.ImplementationSpecificationBuilder getOrCreateImplementationSpecification() {
            ImplementationSpecification.ImplementationSpecificationBuilder result = this.implementationSpecification != null ? this.implementationSpecification : (this.implementationSpecification = ImplementationSpecification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyMessageInformation")
        @RuneAttribute(value="partyMessageInformation")
        public List<? extends PartyMessageInformation.PartyMessageInformationBuilder> getPartyMessageInformation() {
            return this.partyMessageInformation;
        }

        @Override
        public PartyMessageInformation.PartyMessageInformationBuilder getOrCreatePartyMessageInformation(int index) {
            if (this.partyMessageInformation == null) {
                this.partyMessageInformation = new ArrayList<PartyMessageInformation.PartyMessageInformationBuilder>();
            }
            return (PartyMessageInformation.PartyMessageInformationBuilder)this.getIndex(this.partyMessageInformation, index, () -> {
                PartyMessageInformation.PartyMessageInformationBuilder newPartyMessageInformation = PartyMessageInformation.builder();
                return newPartyMessageInformation;
            });
        }

        @Override
        @RosettaAttribute(value="signature")
        @RuneAttribute(value="signature")
        public List<? extends SignatureType.SignatureTypeBuilder> getSignature() {
            return this.signature;
        }

        @Override
        public SignatureType.SignatureTypeBuilder getOrCreateSignature(int index) {
            if (this.signature == null) {
                this.signature = new ArrayList<SignatureType.SignatureTypeBuilder>();
            }
            return (SignatureType.SignatureTypeBuilder)this.getIndex(this.signature, index, () -> {
                SignatureType.SignatureTypeBuilder newSignature = SignatureType.builder();
                return newSignature;
            });
        }

        @Override
        @RosettaAttribute(value="sentBy")
        @RuneAttribute(value="sentBy")
        public MessageHeaderModelBuilder setSentBy(MessageAddress _sentBy) {
            this.sentBy = _sentBy == null ? null : _sentBy.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sendTo")
        @RuneAttribute(value="sendTo")
        public MessageHeaderModelBuilder addSendTo(MessageAddress _sendTo) {
            if (_sendTo != null) {
                this.sendTo.add(_sendTo.toBuilder());
            }
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addSendTo(MessageAddress _sendTo, int idx) {
            this.getIndex(this.sendTo, idx, () -> _sendTo.toBuilder());
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addSendTo(List<? extends MessageAddress> sendTos) {
            if (sendTos != null) {
                for (MessageAddress messageAddress : sendTos) {
                    this.sendTo.add(messageAddress.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sendTo")
        public MessageHeaderModelBuilder setSendTo(List<? extends MessageAddress> sendTos) {
            this.sendTo = sendTos == null ? new ArrayList<MessageAddress.MessageAddressBuilder>() : (List)sendTos.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="copyTo")
        @RuneAttribute(value="copyTo")
        public MessageHeaderModelBuilder addCopyTo(MessageAddress _copyTo) {
            if (_copyTo != null) {
                this.copyTo.add(_copyTo.toBuilder());
            }
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addCopyTo(MessageAddress _copyTo, int idx) {
            this.getIndex(this.copyTo, idx, () -> _copyTo.toBuilder());
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addCopyTo(List<? extends MessageAddress> copyTos) {
            if (copyTos != null) {
                for (MessageAddress messageAddress : copyTos) {
                    this.copyTo.add(messageAddress.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="copyTo")
        public MessageHeaderModelBuilder setCopyTo(List<? extends MessageAddress> copyTos) {
            this.copyTo = copyTos == null ? new ArrayList<MessageAddress.MessageAddressBuilder>() : (List)copyTos.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creationTimestamp")
        @RuneAttribute(value="creationTimestamp")
        public MessageHeaderModelBuilder setCreationTimestamp(ZonedDateTime _creationTimestamp) {
            this.creationTimestamp = _creationTimestamp == null ? null : _creationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiryTimestamp")
        @RuneAttribute(value="expiryTimestamp")
        public MessageHeaderModelBuilder setExpiryTimestamp(ZonedDateTime _expiryTimestamp) {
            this.expiryTimestamp = _expiryTimestamp == null ? null : _expiryTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="implementationSpecification")
        @RuneAttribute(value="implementationSpecification")
        public MessageHeaderModelBuilder setImplementationSpecification(ImplementationSpecification _implementationSpecification) {
            this.implementationSpecification = _implementationSpecification == null ? null : _implementationSpecification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyMessageInformation")
        @RuneAttribute(value="partyMessageInformation")
        public MessageHeaderModelBuilder addPartyMessageInformation(PartyMessageInformation _partyMessageInformation) {
            if (_partyMessageInformation != null) {
                this.partyMessageInformation.add(_partyMessageInformation.toBuilder());
            }
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addPartyMessageInformation(PartyMessageInformation _partyMessageInformation, int idx) {
            this.getIndex(this.partyMessageInformation, idx, () -> _partyMessageInformation.toBuilder());
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addPartyMessageInformation(List<? extends PartyMessageInformation> partyMessageInformations) {
            if (partyMessageInformations != null) {
                for (PartyMessageInformation partyMessageInformation : partyMessageInformations) {
                    this.partyMessageInformation.add(partyMessageInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyMessageInformation")
        public MessageHeaderModelBuilder setPartyMessageInformation(List<? extends PartyMessageInformation> partyMessageInformations) {
            this.partyMessageInformation = partyMessageInformations == null ? new ArrayList<PartyMessageInformation.PartyMessageInformationBuilder>() : (List)partyMessageInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="signature")
        @RuneAttribute(value="signature")
        public MessageHeaderModelBuilder addSignature(SignatureType _signature) {
            if (_signature != null) {
                this.signature.add(_signature.toBuilder());
            }
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addSignature(SignatureType _signature, int idx) {
            this.getIndex(this.signature, idx, () -> _signature.toBuilder());
            return this;
        }

        @Override
        public MessageHeaderModelBuilder addSignature(List<? extends SignatureType> signatures) {
            if (signatures != null) {
                for (SignatureType signatureType : signatures) {
                    this.signature.add(signatureType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="signature")
        public MessageHeaderModelBuilder setSignature(List<? extends SignatureType> signatures) {
            this.signature = signatures == null ? new ArrayList<SignatureType.SignatureTypeBuilder>() : (List)signatures.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MessageHeaderModel build() {
            return new MessageHeaderModelImpl(this);
        }

        @Override
        public MessageHeaderModelBuilder toBuilder() {
            return this;
        }

        @Override
        public MessageHeaderModelBuilder prune() {
            if (this.sentBy != null && !this.sentBy.prune().hasData()) {
                this.sentBy = null;
            }
            this.sendTo = this.sendTo.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.copyTo = this.copyTo.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.implementationSpecification != null && !this.implementationSpecification.prune().hasData()) {
                this.implementationSpecification = null;
            }
            this.partyMessageInformation = this.partyMessageInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.signature = this.signature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSentBy() != null && this.getSentBy().hasData()) {
                return true;
            }
            if (this.getSendTo() != null && this.getSendTo().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCopyTo() != null && this.getCopyTo().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreationTimestamp() != null) {
                return true;
            }
            if (this.getExpiryTimestamp() != null) {
                return true;
            }
            if (this.getImplementationSpecification() != null && this.getImplementationSpecification().hasData()) {
                return true;
            }
            if (this.getPartyMessageInformation() != null && this.getPartyMessageInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSignature() != null && this.getSignature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MessageHeaderModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MessageHeaderModelBuilder o = (MessageHeaderModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSentBy(), (RosettaModelObjectBuilder)o.getSentBy(), this::setSentBy);
            merger.mergeRosetta(this.getSendTo(), o.getSendTo(), this::getOrCreateSendTo);
            merger.mergeRosetta(this.getCopyTo(), o.getCopyTo(), this::getOrCreateCopyTo);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getImplementationSpecification(), (RosettaModelObjectBuilder)o.getImplementationSpecification(), this::setImplementationSpecification);
            merger.mergeRosetta(this.getPartyMessageInformation(), o.getPartyMessageInformation(), this::getOrCreatePartyMessageInformation);
            merger.mergeRosetta(this.getSignature(), o.getSignature(), this::getOrCreateSignature);
            merger.mergeBasic((Object)this.getCreationTimestamp(), (Object)o.getCreationTimestamp(), this::setCreationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpiryTimestamp(), (Object)o.getExpiryTimestamp(), this::setExpiryTimestamp, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MessageHeaderModel _that = this.getType().cast(o);
            if (!Objects.equals(this.sentBy, _that.getSentBy())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sendTo, _that.getSendTo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.copyTo, _that.getCopyTo())) {
                return false;
            }
            if (!Objects.equals(this.creationTimestamp, _that.getCreationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expiryTimestamp, _that.getExpiryTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.implementationSpecification, _that.getImplementationSpecification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyMessageInformation, _that.getPartyMessageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.signature, _that.getSignature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sentBy != null ? this.sentBy.hashCode() : 0);
            _result = 31 * _result + (this.sendTo != null ? this.sendTo.hashCode() : 0);
            _result = 31 * _result + (this.copyTo != null ? this.copyTo.hashCode() : 0);
            _result = 31 * _result + (this.creationTimestamp != null ? this.creationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expiryTimestamp != null ? this.expiryTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.implementationSpecification != null ? this.implementationSpecification.hashCode() : 0);
            _result = 31 * _result + (this.partyMessageInformation != null ? this.partyMessageInformation.hashCode() : 0);
            _result = 31 * _result + (this.signature != null ? this.signature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MessageHeaderModelBuilder {sentBy=" + String.valueOf(this.sentBy) + ", sendTo=" + String.valueOf(this.sendTo) + ", copyTo=" + String.valueOf(this.copyTo) + ", creationTimestamp=" + String.valueOf(this.creationTimestamp) + ", expiryTimestamp=" + String.valueOf(this.expiryTimestamp) + ", implementationSpecification=" + String.valueOf(this.implementationSpecification) + ", partyMessageInformation=" + String.valueOf(this.partyMessageInformation) + ", signature=" + String.valueOf(this.signature) + "}";
        }
    }

    public static interface MessageHeaderModelBuilder
    extends MessageHeaderModel,
    RosettaModelObjectBuilder {
        public MessageAddress.MessageAddressBuilder getOrCreateSentBy();

        @Override
        public MessageAddress.MessageAddressBuilder getSentBy();

        public MessageAddress.MessageAddressBuilder getOrCreateSendTo(int var1);

        public List<? extends MessageAddress.MessageAddressBuilder> getSendTo();

        public MessageAddress.MessageAddressBuilder getOrCreateCopyTo(int var1);

        public List<? extends MessageAddress.MessageAddressBuilder> getCopyTo();

        public ImplementationSpecification.ImplementationSpecificationBuilder getOrCreateImplementationSpecification();

        @Override
        public ImplementationSpecification.ImplementationSpecificationBuilder getImplementationSpecification();

        public PartyMessageInformation.PartyMessageInformationBuilder getOrCreatePartyMessageInformation(int var1);

        public List<? extends PartyMessageInformation.PartyMessageInformationBuilder> getPartyMessageInformation();

        public SignatureType.SignatureTypeBuilder getOrCreateSignature(int var1);

        public List<? extends SignatureType.SignatureTypeBuilder> getSignature();

        public MessageHeaderModelBuilder setSentBy(MessageAddress var1);

        public MessageHeaderModelBuilder addSendTo(MessageAddress var1);

        public MessageHeaderModelBuilder addSendTo(MessageAddress var1, int var2);

        public MessageHeaderModelBuilder addSendTo(List<? extends MessageAddress> var1);

        public MessageHeaderModelBuilder setSendTo(List<? extends MessageAddress> var1);

        public MessageHeaderModelBuilder addCopyTo(MessageAddress var1);

        public MessageHeaderModelBuilder addCopyTo(MessageAddress var1, int var2);

        public MessageHeaderModelBuilder addCopyTo(List<? extends MessageAddress> var1);

        public MessageHeaderModelBuilder setCopyTo(List<? extends MessageAddress> var1);

        public MessageHeaderModelBuilder setCreationTimestamp(ZonedDateTime var1);

        public MessageHeaderModelBuilder setExpiryTimestamp(ZonedDateTime var1);

        public MessageHeaderModelBuilder setImplementationSpecification(ImplementationSpecification var1);

        public MessageHeaderModelBuilder addPartyMessageInformation(PartyMessageInformation var1);

        public MessageHeaderModelBuilder addPartyMessageInformation(PartyMessageInformation var1, int var2);

        public MessageHeaderModelBuilder addPartyMessageInformation(List<? extends PartyMessageInformation> var1);

        public MessageHeaderModelBuilder setPartyMessageInformation(List<? extends PartyMessageInformation> var1);

        public MessageHeaderModelBuilder addSignature(SignatureType var1);

        public MessageHeaderModelBuilder addSignature(SignatureType var1, int var2);

        public MessageHeaderModelBuilder addSignature(List<? extends SignatureType> var1);

        public MessageHeaderModelBuilder setSignature(List<? extends SignatureType> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("sentBy"), processor, MessageAddress.MessageAddressBuilder.class, this.getSentBy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sendTo"), processor, MessageAddress.MessageAddressBuilder.class, this.getSendTo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("copyTo"), processor, MessageAddress.MessageAddressBuilder.class, this.getCopyTo(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creationTimestamp"), ZonedDateTime.class, (Object)this.getCreationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiryTimestamp"), ZonedDateTime.class, (Object)this.getExpiryTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("implementationSpecification"), processor, ImplementationSpecification.ImplementationSpecificationBuilder.class, this.getImplementationSpecification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyMessageInformation"), processor, PartyMessageInformation.PartyMessageInformationBuilder.class, this.getPartyMessageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("signature"), processor, SignatureType.SignatureTypeBuilder.class, this.getSignature(), new AttributeMeta[0]);
        }

        public MessageHeaderModelBuilder prune();
    }

    public static class MessageHeaderModelImpl
    implements MessageHeaderModel {
        private final MessageAddress sentBy;
        private final List<? extends MessageAddress> sendTo;
        private final List<? extends MessageAddress> copyTo;
        private final ZonedDateTime creationTimestamp;
        private final ZonedDateTime expiryTimestamp;
        private final ImplementationSpecification implementationSpecification;
        private final List<? extends PartyMessageInformation> partyMessageInformation;
        private final List<? extends SignatureType> signature;

        protected MessageHeaderModelImpl(MessageHeaderModelBuilder builder) {
            this.sentBy = Optional.ofNullable(builder.getSentBy()).map(f -> f.build()).orElse(null);
            this.sendTo = Optional.ofNullable(builder.getSendTo()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.copyTo = Optional.ofNullable(builder.getCopyTo()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creationTimestamp = builder.getCreationTimestamp();
            this.expiryTimestamp = builder.getExpiryTimestamp();
            this.implementationSpecification = Optional.ofNullable(builder.getImplementationSpecification()).map(f -> f.build()).orElse(null);
            this.partyMessageInformation = Optional.ofNullable(builder.getPartyMessageInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.signature = Optional.ofNullable(builder.getSignature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="sentBy")
        @RuneAttribute(value="sentBy")
        public MessageAddress getSentBy() {
            return this.sentBy;
        }

        @Override
        @RosettaAttribute(value="sendTo")
        @RuneAttribute(value="sendTo")
        public List<? extends MessageAddress> getSendTo() {
            return this.sendTo;
        }

        @Override
        @RosettaAttribute(value="copyTo")
        @RuneAttribute(value="copyTo")
        public List<? extends MessageAddress> getCopyTo() {
            return this.copyTo;
        }

        @Override
        @RosettaAttribute(value="creationTimestamp")
        @RuneAttribute(value="creationTimestamp")
        public ZonedDateTime getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        @RosettaAttribute(value="expiryTimestamp")
        @RuneAttribute(value="expiryTimestamp")
        public ZonedDateTime getExpiryTimestamp() {
            return this.expiryTimestamp;
        }

        @Override
        @RosettaAttribute(value="implementationSpecification")
        @RuneAttribute(value="implementationSpecification")
        public ImplementationSpecification getImplementationSpecification() {
            return this.implementationSpecification;
        }

        @Override
        @RosettaAttribute(value="partyMessageInformation")
        @RuneAttribute(value="partyMessageInformation")
        public List<? extends PartyMessageInformation> getPartyMessageInformation() {
            return this.partyMessageInformation;
        }

        @Override
        @RosettaAttribute(value="signature")
        @RuneAttribute(value="signature")
        public List<? extends SignatureType> getSignature() {
            return this.signature;
        }

        @Override
        public MessageHeaderModel build() {
            return this;
        }

        @Override
        public MessageHeaderModelBuilder toBuilder() {
            MessageHeaderModelBuilder builder = MessageHeaderModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MessageHeaderModelBuilder builder) {
            Optional.ofNullable(this.getSentBy()).ifPresent(builder::setSentBy);
            Optional.ofNullable(this.getSendTo()).ifPresent(builder::setSendTo);
            Optional.ofNullable(this.getCopyTo()).ifPresent(builder::setCopyTo);
            Optional.ofNullable(this.getCreationTimestamp()).ifPresent(builder::setCreationTimestamp);
            Optional.ofNullable(this.getExpiryTimestamp()).ifPresent(builder::setExpiryTimestamp);
            Optional.ofNullable(this.getImplementationSpecification()).ifPresent(builder::setImplementationSpecification);
            Optional.ofNullable(this.getPartyMessageInformation()).ifPresent(builder::setPartyMessageInformation);
            Optional.ofNullable(this.getSignature()).ifPresent(builder::setSignature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MessageHeaderModel _that = this.getType().cast(o);
            if (!Objects.equals(this.sentBy, _that.getSentBy())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sendTo, _that.getSendTo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.copyTo, _that.getCopyTo())) {
                return false;
            }
            if (!Objects.equals(this.creationTimestamp, _that.getCreationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expiryTimestamp, _that.getExpiryTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.implementationSpecification, _that.getImplementationSpecification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyMessageInformation, _that.getPartyMessageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.signature, _that.getSignature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sentBy != null ? this.sentBy.hashCode() : 0);
            _result = 31 * _result + (this.sendTo != null ? this.sendTo.hashCode() : 0);
            _result = 31 * _result + (this.copyTo != null ? this.copyTo.hashCode() : 0);
            _result = 31 * _result + (this.creationTimestamp != null ? this.creationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expiryTimestamp != null ? this.expiryTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.implementationSpecification != null ? this.implementationSpecification.hashCode() : 0);
            _result = 31 * _result + (this.partyMessageInformation != null ? this.partyMessageInformation.hashCode() : 0);
            _result = 31 * _result + (this.signature != null ? this.signature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MessageHeaderModel {sentBy=" + String.valueOf(this.sentBy) + ", sendTo=" + String.valueOf(this.sendTo) + ", copyTo=" + String.valueOf(this.copyTo) + ", creationTimestamp=" + String.valueOf(this.creationTimestamp) + ", expiryTimestamp=" + String.valueOf(this.expiryTimestamp) + ", implementationSpecification=" + String.valueOf(this.implementationSpecification) + ", partyMessageInformation=" + String.valueOf(this.partyMessageInformation) + ", signature=" + String.valueOf(this.signature) + "}";
        }
    }
}

