/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.meta.RepaymentTypeModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RepaymentTypeModel", builder=RepaymentTypeModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RepaymentTypeModel", model="fpml", builder=RepaymentTypeModelBuilderImpl.class, version="1.2.2")
public interface RepaymentTypeModel
extends RosettaModelObject {
    public static final RepaymentTypeModelMeta metaData = new RepaymentTypeModelMeta();

    public Boolean getRefusalAllowed();

    public Boolean getBorrowerMandatory();

    public Boolean getScheduledRepayment();

    public RepaymentTypeModel build();

    public RepaymentTypeModelBuilder toBuilder();

    public static RepaymentTypeModelBuilder builder() {
        return new RepaymentTypeModelBuilderImpl();
    }

    default public RosettaMetaData<? extends RepaymentTypeModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RepaymentTypeModel> getType() {
        return RepaymentTypeModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("refusalAllowed"), Boolean.class, (Object)this.getRefusalAllowed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("borrowerMandatory"), Boolean.class, (Object)this.getBorrowerMandatory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("scheduledRepayment"), Boolean.class, (Object)this.getScheduledRepayment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RepaymentTypeModelBuilderImpl
    implements RepaymentTypeModelBuilder {
        protected Boolean refusalAllowed;
        protected Boolean borrowerMandatory;
        protected Boolean scheduledRepayment;

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public Boolean getRefusalAllowed() {
            return this.refusalAllowed;
        }

        @Override
        @RosettaAttribute(value="borrowerMandatory")
        @RuneAttribute(value="borrowerMandatory")
        public Boolean getBorrowerMandatory() {
            return this.borrowerMandatory;
        }

        @Override
        @RosettaAttribute(value="scheduledRepayment")
        @RuneAttribute(value="scheduledRepayment")
        public Boolean getScheduledRepayment() {
            return this.scheduledRepayment;
        }

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public RepaymentTypeModelBuilder setRefusalAllowed(Boolean _refusalAllowed) {
            this.refusalAllowed = _refusalAllowed == null ? null : _refusalAllowed;
            return this;
        }

        @Override
        @RosettaAttribute(value="borrowerMandatory")
        @RuneAttribute(value="borrowerMandatory")
        public RepaymentTypeModelBuilder setBorrowerMandatory(Boolean _borrowerMandatory) {
            this.borrowerMandatory = _borrowerMandatory == null ? null : _borrowerMandatory;
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduledRepayment")
        @RuneAttribute(value="scheduledRepayment")
        public RepaymentTypeModelBuilder setScheduledRepayment(Boolean _scheduledRepayment) {
            this.scheduledRepayment = _scheduledRepayment == null ? null : _scheduledRepayment;
            return this;
        }

        @Override
        public RepaymentTypeModel build() {
            return new RepaymentTypeModelImpl(this);
        }

        @Override
        public RepaymentTypeModelBuilder toBuilder() {
            return this;
        }

        @Override
        public RepaymentTypeModelBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getRefusalAllowed() != null) {
                return true;
            }
            if (this.getBorrowerMandatory() != null) {
                return true;
            }
            return this.getScheduledRepayment() != null;
        }

        public RepaymentTypeModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepaymentTypeModelBuilder o = (RepaymentTypeModelBuilder)other;
            merger.mergeBasic((Object)this.getRefusalAllowed(), (Object)o.getRefusalAllowed(), this::setRefusalAllowed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBorrowerMandatory(), (Object)o.getBorrowerMandatory(), this::setBorrowerMandatory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getScheduledRepayment(), (Object)o.getScheduledRepayment(), this::setScheduledRepayment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepaymentTypeModel _that = this.getType().cast(o);
            if (!Objects.equals(this.refusalAllowed, _that.getRefusalAllowed())) {
                return false;
            }
            if (!Objects.equals(this.borrowerMandatory, _that.getBorrowerMandatory())) {
                return false;
            }
            return Objects.equals(this.scheduledRepayment, _that.getScheduledRepayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.refusalAllowed != null ? this.refusalAllowed.hashCode() : 0);
            _result = 31 * _result + (this.borrowerMandatory != null ? this.borrowerMandatory.hashCode() : 0);
            _result = 31 * _result + (this.scheduledRepayment != null ? this.scheduledRepayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepaymentTypeModelBuilder {refusalAllowed=" + this.refusalAllowed + ", borrowerMandatory=" + this.borrowerMandatory + ", scheduledRepayment=" + this.scheduledRepayment + "}";
        }
    }

    public static interface RepaymentTypeModelBuilder
    extends RepaymentTypeModel,
    RosettaModelObjectBuilder {
        public RepaymentTypeModelBuilder setRefusalAllowed(Boolean var1);

        public RepaymentTypeModelBuilder setBorrowerMandatory(Boolean var1);

        public RepaymentTypeModelBuilder setScheduledRepayment(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("refusalAllowed"), Boolean.class, (Object)this.getRefusalAllowed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("borrowerMandatory"), Boolean.class, (Object)this.getBorrowerMandatory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("scheduledRepayment"), Boolean.class, (Object)this.getScheduledRepayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RepaymentTypeModelBuilder prune();
    }

    public static class RepaymentTypeModelImpl
    implements RepaymentTypeModel {
        private final Boolean refusalAllowed;
        private final Boolean borrowerMandatory;
        private final Boolean scheduledRepayment;

        protected RepaymentTypeModelImpl(RepaymentTypeModelBuilder builder) {
            this.refusalAllowed = builder.getRefusalAllowed();
            this.borrowerMandatory = builder.getBorrowerMandatory();
            this.scheduledRepayment = builder.getScheduledRepayment();
        }

        @Override
        @RosettaAttribute(value="refusalAllowed", isRequired=true)
        @RuneAttribute(value="refusalAllowed", isRequired=true)
        public Boolean getRefusalAllowed() {
            return this.refusalAllowed;
        }

        @Override
        @RosettaAttribute(value="borrowerMandatory")
        @RuneAttribute(value="borrowerMandatory")
        public Boolean getBorrowerMandatory() {
            return this.borrowerMandatory;
        }

        @Override
        @RosettaAttribute(value="scheduledRepayment")
        @RuneAttribute(value="scheduledRepayment")
        public Boolean getScheduledRepayment() {
            return this.scheduledRepayment;
        }

        @Override
        public RepaymentTypeModel build() {
            return this;
        }

        @Override
        public RepaymentTypeModelBuilder toBuilder() {
            RepaymentTypeModelBuilder builder = RepaymentTypeModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepaymentTypeModelBuilder builder) {
            Optional.ofNullable(this.getRefusalAllowed()).ifPresent(builder::setRefusalAllowed);
            Optional.ofNullable(this.getBorrowerMandatory()).ifPresent(builder::setBorrowerMandatory);
            Optional.ofNullable(this.getScheduledRepayment()).ifPresent(builder::setScheduledRepayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepaymentTypeModel _that = this.getType().cast(o);
            if (!Objects.equals(this.refusalAllowed, _that.getRefusalAllowed())) {
                return false;
            }
            if (!Objects.equals(this.borrowerMandatory, _that.getBorrowerMandatory())) {
                return false;
            }
            return Objects.equals(this.scheduledRepayment, _that.getScheduledRepayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.refusalAllowed != null ? this.refusalAllowed.hashCode() : 0);
            _result = 31 * _result + (this.borrowerMandatory != null ? this.borrowerMandatory.hashCode() : 0);
            _result = 31 * _result + (this.scheduledRepayment != null ? this.scheduledRepayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepaymentTypeModel {refusalAllowed=" + this.refusalAllowed + ", borrowerMandatory=" + this.borrowerMandatory + ", scheduledRepayment=" + this.scheduledRepayment + "}";
        }
    }
}

