/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.LoanTradingNonAccruingFeeTypeEnum;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.MiscFeeType;
import fpml.consolidated.loan.NonAccruingFeeTypeId;
import fpml.consolidated.loan.meta.LoanTradingNonAccruingFeeMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradingNonAccruingFee", builder=LoanTradingNonAccruingFeeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanTradingNonAccruingFee", model="fpml", builder=LoanTradingNonAccruingFeeBuilderImpl.class, version="1.2.2")
public interface LoanTradingNonAccruingFee
extends RosettaModelObject {
    public static final LoanTradingNonAccruingFeeMeta metaData = new LoanTradingNonAccruingFeeMeta();

    public NonNegativeMoney getAmount();

    public NonAccruingFeeTypeId getNonAccruingFeeTypeId();

    public LoanTradingNonAccruingFeeTypeEnum getNonAccruingFeetype();

    public MiscFeeType getMiscFeeType();

    public FacilityReference getFacilityReference();

    public LoanContractReference getLoanContractReference();

    public LetterOfCreditReference getLetterOfCreditReference();

    public LoanTradingNonAccruingFee build();

    public LoanTradingNonAccruingFeeBuilder toBuilder();

    public static LoanTradingNonAccruingFeeBuilder builder() {
        return new LoanTradingNonAccruingFeeBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingNonAccruingFee> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingNonAccruingFee> getType() {
        return LoanTradingNonAccruingFee.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonAccruingFeeTypeId"), processor, NonAccruingFeeTypeId.class, this.getNonAccruingFeeTypeId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonAccruingFeetype"), LoanTradingNonAccruingFeeTypeEnum.class, (Object)this.getNonAccruingFeetype(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("miscFeeType"), processor, MiscFeeType.class, this.getMiscFeeType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
    }

    public static class LoanTradingNonAccruingFeeBuilderImpl
    implements LoanTradingNonAccruingFeeBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder nonAccruingFeeTypeId;
        protected LoanTradingNonAccruingFeeTypeEnum nonAccruingFeetype;
        protected MiscFeeType.MiscFeeTypeBuilder miscFeeType;
        protected FacilityReference.FacilityReferenceBuilder facilityReference;
        protected LoanContractReference.LoanContractReferenceBuilder loanContractReference;
        protected LetterOfCreditReference.LetterOfCreditReferenceBuilder letterOfCreditReference;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        public NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder getNonAccruingFeeTypeId() {
            return this.nonAccruingFeeTypeId;
        }

        @Override
        public NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder getOrCreateNonAccruingFeeTypeId() {
            NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder result = this.nonAccruingFeeTypeId != null ? this.nonAccruingFeeTypeId : (this.nonAccruingFeeTypeId = NonAccruingFeeTypeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeetype")
        @RuneAttribute(value="nonAccruingFeetype")
        public LoanTradingNonAccruingFeeTypeEnum getNonAccruingFeetype() {
            return this.nonAccruingFeetype;
        }

        @Override
        @RosettaAttribute(value="miscFeeType")
        @RuneAttribute(value="miscFeeType")
        public MiscFeeType.MiscFeeTypeBuilder getMiscFeeType() {
            return this.miscFeeType;
        }

        @Override
        public MiscFeeType.MiscFeeTypeBuilder getOrCreateMiscFeeType() {
            MiscFeeType.MiscFeeTypeBuilder result = this.miscFeeType != null ? this.miscFeeType : (this.miscFeeType = MiscFeeType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference() {
            LoanContractReference.LoanContractReferenceBuilder result = this.loanContractReference != null ? this.loanContractReference : (this.loanContractReference = LoanContractReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference")
        @RuneAttribute(value="letterOfCreditReference")
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getLetterOfCreditReference() {
            return this.letterOfCreditReference;
        }

        @Override
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getOrCreateLetterOfCreditReference() {
            LetterOfCreditReference.LetterOfCreditReferenceBuilder result = this.letterOfCreditReference != null ? this.letterOfCreditReference : (this.letterOfCreditReference = LetterOfCreditReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradingNonAccruingFeeBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        public LoanTradingNonAccruingFeeBuilder setNonAccruingFeeTypeId(NonAccruingFeeTypeId _nonAccruingFeeTypeId) {
            this.nonAccruingFeeTypeId = _nonAccruingFeeTypeId == null ? null : _nonAccruingFeeTypeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeetype")
        @RuneAttribute(value="nonAccruingFeetype")
        public LoanTradingNonAccruingFeeBuilder setNonAccruingFeetype(LoanTradingNonAccruingFeeTypeEnum _nonAccruingFeetype) {
            this.nonAccruingFeetype = _nonAccruingFeetype == null ? null : _nonAccruingFeetype;
            return this;
        }

        @Override
        @RosettaAttribute(value="miscFeeType")
        @RuneAttribute(value="miscFeeType")
        public LoanTradingNonAccruingFeeBuilder setMiscFeeType(MiscFeeType _miscFeeType) {
            this.miscFeeType = _miscFeeType == null ? null : _miscFeeType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanTradingNonAccruingFeeBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public LoanTradingNonAccruingFeeBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference")
        @RuneAttribute(value="letterOfCreditReference")
        public LoanTradingNonAccruingFeeBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        public LoanTradingNonAccruingFee build() {
            return new LoanTradingNonAccruingFeeImpl(this);
        }

        @Override
        public LoanTradingNonAccruingFeeBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingNonAccruingFeeBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.nonAccruingFeeTypeId != null && !this.nonAccruingFeeTypeId.prune().hasData()) {
                this.nonAccruingFeeTypeId = null;
            }
            if (this.miscFeeType != null && !this.miscFeeType.prune().hasData()) {
                this.miscFeeType = null;
            }
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            if (this.loanContractReference != null && !this.loanContractReference.prune().hasData()) {
                this.loanContractReference = null;
            }
            if (this.letterOfCreditReference != null && !this.letterOfCreditReference.prune().hasData()) {
                this.letterOfCreditReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getNonAccruingFeeTypeId() != null && this.getNonAccruingFeeTypeId().hasData()) {
                return true;
            }
            if (this.getNonAccruingFeetype() != null) {
                return true;
            }
            if (this.getMiscFeeType() != null && this.getMiscFeeType().hasData()) {
                return true;
            }
            if (this.getFacilityReference() != null && this.getFacilityReference().hasData()) {
                return true;
            }
            if (this.getLoanContractReference() != null && this.getLoanContractReference().hasData()) {
                return true;
            }
            return this.getLetterOfCreditReference() != null && this.getLetterOfCreditReference().hasData();
        }

        public LoanTradingNonAccruingFeeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradingNonAccruingFeeBuilder o = (LoanTradingNonAccruingFeeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonAccruingFeeTypeId(), (RosettaModelObjectBuilder)o.getNonAccruingFeeTypeId(), this::setNonAccruingFeeTypeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMiscFeeType(), (RosettaModelObjectBuilder)o.getMiscFeeType(), this::setMiscFeeType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanContractReference(), (RosettaModelObjectBuilder)o.getLoanContractReference(), this::setLoanContractReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditReference(), (RosettaModelObjectBuilder)o.getLetterOfCreditReference(), this::setLetterOfCreditReference);
            merger.mergeBasic((Object)this.getNonAccruingFeetype(), (Object)o.getNonAccruingFeetype(), this::setNonAccruingFeetype, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingNonAccruingFee _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.nonAccruingFeeTypeId, _that.getNonAccruingFeeTypeId())) {
                return false;
            }
            if (!Objects.equals((Object)this.nonAccruingFeetype, (Object)_that.getNonAccruingFeetype())) {
                return false;
            }
            if (!Objects.equals(this.miscFeeType, _that.getMiscFeeType())) {
                return false;
            }
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.loanContractReference, _that.getLoanContractReference())) {
                return false;
            }
            return Objects.equals(this.letterOfCreditReference, _that.getLetterOfCreditReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFeeTypeId != null ? this.nonAccruingFeeTypeId.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFeetype != null ? ((Object)((Object)this.nonAccruingFeetype)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.miscFeeType != null ? this.miscFeeType.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditReference != null ? this.letterOfCreditReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingNonAccruingFeeBuilder {amount=" + String.valueOf(this.amount) + ", nonAccruingFeeTypeId=" + String.valueOf(this.nonAccruingFeeTypeId) + ", nonAccruingFeetype=" + String.valueOf((Object)this.nonAccruingFeetype) + ", miscFeeType=" + String.valueOf(this.miscFeeType) + ", facilityReference=" + String.valueOf(this.facilityReference) + ", loanContractReference=" + String.valueOf(this.loanContractReference) + ", letterOfCreditReference=" + String.valueOf(this.letterOfCreditReference) + "}";
        }
    }

    public static interface LoanTradingNonAccruingFeeBuilder
    extends LoanTradingNonAccruingFee,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder getOrCreateNonAccruingFeeTypeId();

        @Override
        public NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder getNonAccruingFeeTypeId();

        public MiscFeeType.MiscFeeTypeBuilder getOrCreateMiscFeeType();

        @Override
        public MiscFeeType.MiscFeeTypeBuilder getMiscFeeType();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference();

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference();

        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getOrCreateLetterOfCreditReference();

        @Override
        public LetterOfCreditReference.LetterOfCreditReferenceBuilder getLetterOfCreditReference();

        public LoanTradingNonAccruingFeeBuilder setAmount(NonNegativeMoney var1);

        public LoanTradingNonAccruingFeeBuilder setNonAccruingFeeTypeId(NonAccruingFeeTypeId var1);

        public LoanTradingNonAccruingFeeBuilder setNonAccruingFeetype(LoanTradingNonAccruingFeeTypeEnum var1);

        public LoanTradingNonAccruingFeeBuilder setMiscFeeType(MiscFeeType var1);

        public LoanTradingNonAccruingFeeBuilder setFacilityReference(FacilityReference var1);

        public LoanTradingNonAccruingFeeBuilder setLoanContractReference(LoanContractReference var1);

        public LoanTradingNonAccruingFeeBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonAccruingFeeTypeId"), processor, NonAccruingFeeTypeId.NonAccruingFeeTypeIdBuilder.class, this.getNonAccruingFeeTypeId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonAccruingFeetype"), LoanTradingNonAccruingFeeTypeEnum.class, (Object)this.getNonAccruingFeetype(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("miscFeeType"), processor, MiscFeeType.MiscFeeTypeBuilder.class, this.getMiscFeeType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        }

        public LoanTradingNonAccruingFeeBuilder prune();
    }

    public static class LoanTradingNonAccruingFeeImpl
    implements LoanTradingNonAccruingFee {
        private final NonNegativeMoney amount;
        private final NonAccruingFeeTypeId nonAccruingFeeTypeId;
        private final LoanTradingNonAccruingFeeTypeEnum nonAccruingFeetype;
        private final MiscFeeType miscFeeType;
        private final FacilityReference facilityReference;
        private final LoanContractReference loanContractReference;
        private final LetterOfCreditReference letterOfCreditReference;

        protected LoanTradingNonAccruingFeeImpl(LoanTradingNonAccruingFeeBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.nonAccruingFeeTypeId = Optional.ofNullable(builder.getNonAccruingFeeTypeId()).map(f -> f.build()).orElse(null);
            this.nonAccruingFeetype = builder.getNonAccruingFeetype();
            this.miscFeeType = Optional.ofNullable(builder.getMiscFeeType()).map(f -> f.build()).orElse(null);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
            this.loanContractReference = Optional.ofNullable(builder.getLoanContractReference()).map(f -> f.build()).orElse(null);
            this.letterOfCreditReference = Optional.ofNullable(builder.getLetterOfCreditReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="nonAccruingFeeTypeId", isRequired=true)
        public NonAccruingFeeTypeId getNonAccruingFeeTypeId() {
            return this.nonAccruingFeeTypeId;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFeetype")
        @RuneAttribute(value="nonAccruingFeetype")
        public LoanTradingNonAccruingFeeTypeEnum getNonAccruingFeetype() {
            return this.nonAccruingFeetype;
        }

        @Override
        @RosettaAttribute(value="miscFeeType")
        @RuneAttribute(value="miscFeeType")
        public MiscFeeType getMiscFeeType() {
            return this.miscFeeType;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public LoanContractReference getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference")
        @RuneAttribute(value="letterOfCreditReference")
        public LetterOfCreditReference getLetterOfCreditReference() {
            return this.letterOfCreditReference;
        }

        @Override
        public LoanTradingNonAccruingFee build() {
            return this;
        }

        @Override
        public LoanTradingNonAccruingFeeBuilder toBuilder() {
            LoanTradingNonAccruingFeeBuilder builder = LoanTradingNonAccruingFee.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingNonAccruingFeeBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getNonAccruingFeeTypeId()).ifPresent(builder::setNonAccruingFeeTypeId);
            Optional.ofNullable(this.getNonAccruingFeetype()).ifPresent(builder::setNonAccruingFeetype);
            Optional.ofNullable(this.getMiscFeeType()).ifPresent(builder::setMiscFeeType);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
            Optional.ofNullable(this.getLoanContractReference()).ifPresent(builder::setLoanContractReference);
            Optional.ofNullable(this.getLetterOfCreditReference()).ifPresent(builder::setLetterOfCreditReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingNonAccruingFee _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.nonAccruingFeeTypeId, _that.getNonAccruingFeeTypeId())) {
                return false;
            }
            if (!Objects.equals((Object)this.nonAccruingFeetype, (Object)_that.getNonAccruingFeetype())) {
                return false;
            }
            if (!Objects.equals(this.miscFeeType, _that.getMiscFeeType())) {
                return false;
            }
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.loanContractReference, _that.getLoanContractReference())) {
                return false;
            }
            return Objects.equals(this.letterOfCreditReference, _that.getLetterOfCreditReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFeeTypeId != null ? this.nonAccruingFeeTypeId.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFeetype != null ? ((Object)((Object)this.nonAccruingFeetype)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.miscFeeType != null ? this.miscFeeType.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditReference != null ? this.letterOfCreditReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingNonAccruingFee {amount=" + String.valueOf(this.amount) + ", nonAccruingFeeTypeId=" + String.valueOf(this.nonAccruingFeeTypeId) + ", nonAccruingFeetype=" + String.valueOf((Object)this.nonAccruingFeetype) + ", miscFeeType=" + String.valueOf(this.miscFeeType) + ", facilityReference=" + String.valueOf(this.facilityReference) + ", loanContractReference=" + String.valueOf(this.loanContractReference) + ", letterOfCreditReference=" + String.valueOf(this.letterOfCreditReference) + "}";
        }
    }
}

