/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanStatement;
import fpml.consolidated.loan.Deal;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.LetterOfCreditDetailsModel;
import fpml.consolidated.loan.LoanContractDetailsModel;
import fpml.consolidated.loan.LoanLegalAction;
import fpml.consolidated.loan.LoanLegalActionStatementChoice;
import fpml.consolidated.loan.meta.LoanLegalActionStatementMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalActionStatement", builder=LoanLegalActionStatementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanLegalActionStatement", model="fpml", builder=LoanLegalActionStatementBuilderImpl.class, version="1.2.2")
public interface LoanLegalActionStatement
extends AbstractLoanStatement {
    public static final LoanLegalActionStatementMeta metaData = new LoanLegalActionStatementMeta();

    public LoanLegalAction getLegalAction();

    public DealDetailsModel getDealDetailsModel();

    public Deal getDeal();

    public List<? extends LoanLegalActionStatementChoice> getLoanLegalActionStatementChoice();

    public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel();

    public List<? extends LetterOfCreditDetailsModel> getLetterOfCreditDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public LoanLegalActionStatement build();

    @Override
    public LoanLegalActionStatementBuilder toBuilder();

    public static LoanLegalActionStatementBuilder builder() {
        return new LoanLegalActionStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalActionStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalActionStatement> getType() {
        return LoanLegalActionStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAction"), processor, LoanLegalAction.class, this.getLegalAction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deal"), processor, Deal.class, this.getDeal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalActionStatementChoice"), processor, LoanLegalActionStatementChoice.class, this.getLoanLegalActionStatementChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanLegalActionStatementBuilderImpl
    extends AbstractLoanStatement.AbstractLoanStatementBuilderImpl
    implements LoanLegalActionStatementBuilder {
        protected LoanLegalAction.LoanLegalActionBuilder legalAction;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected Deal.DealBuilder deal;
        protected List<LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder> loanLegalActionStatementChoice = new ArrayList<LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder>();
        protected List<LoanContractDetailsModel.LoanContractDetailsModelBuilder> loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
        protected List<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> letterOfCreditDetailsModel = new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="legalAction", isRequired=true)
        @RuneAttribute(value="legalAction", isRequired=true)
        public LoanLegalAction.LoanLegalActionBuilder getLegalAction() {
            return this.legalAction;
        }

        @Override
        public LoanLegalAction.LoanLegalActionBuilder getOrCreateLegalAction() {
            LoanLegalAction.LoanLegalActionBuilder result = this.legalAction != null ? this.legalAction : (this.legalAction = LoanLegalAction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deal")
        @RuneAttribute(value="deal")
        public Deal.DealBuilder getDeal() {
            return this.deal;
        }

        @Override
        public Deal.DealBuilder getOrCreateDeal() {
            Deal.DealBuilder result = this.deal != null ? this.deal : (this.deal = Deal.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionStatementChoice")
        @RuneAttribute(value="loanLegalActionStatementChoice")
        public List<? extends LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder> getLoanLegalActionStatementChoice() {
            return this.loanLegalActionStatementChoice;
        }

        @Override
        public LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder getOrCreateLoanLegalActionStatementChoice(int index) {
            if (this.loanLegalActionStatementChoice == null) {
                this.loanLegalActionStatementChoice = new ArrayList<LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder>();
            }
            return (LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder)this.getIndex(this.loanLegalActionStatementChoice, index, () -> {
                LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder newLoanLegalActionStatementChoice = LoanLegalActionStatementChoice.builder();
                return newLoanLegalActionStatementChoice;
            });
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int index) {
            if (this.loanContractDetailsModel == null) {
                this.loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
            }
            return (LoanContractDetailsModel.LoanContractDetailsModelBuilder)this.getIndex(this.loanContractDetailsModel, index, () -> {
                LoanContractDetailsModel.LoanContractDetailsModelBuilder newLoanContractDetailsModel = LoanContractDetailsModel.builder();
                return newLoanContractDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public List<? extends LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel(int index) {
            if (this.letterOfCreditDetailsModel == null) {
                this.letterOfCreditDetailsModel = new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>();
            }
            return (LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder)this.getIndex(this.letterOfCreditDetailsModel, index, () -> {
                LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder newLetterOfCreditDetailsModel = LetterOfCreditDetailsModel.builder();
                return newLetterOfCreditDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanLegalActionStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanLegalActionStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanLegalActionStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanLegalActionStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanLegalActionStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanLegalActionStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanLegalActionStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanLegalActionStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public LoanLegalActionStatementBuilder setStatementDate(ZonedDateTime _statementDate) {
            this.statementDate = _statementDate == null ? null : _statementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public LoanLegalActionStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalAction", isRequired=true)
        @RuneAttribute(value="legalAction", isRequired=true)
        public LoanLegalActionStatementBuilder setLegalAction(LoanLegalAction _legalAction) {
            this.legalAction = _legalAction == null ? null : _legalAction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public LoanLegalActionStatementBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deal")
        @RuneAttribute(value="deal")
        public LoanLegalActionStatementBuilder setDeal(Deal _deal) {
            this.deal = _deal == null ? null : _deal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionStatementChoice")
        @RuneAttribute(value="loanLegalActionStatementChoice")
        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(LoanLegalActionStatementChoice _loanLegalActionStatementChoice) {
            if (_loanLegalActionStatementChoice != null) {
                this.loanLegalActionStatementChoice.add(_loanLegalActionStatementChoice.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(LoanLegalActionStatementChoice _loanLegalActionStatementChoice, int idx) {
            this.getIndex(this.loanLegalActionStatementChoice, idx, () -> _loanLegalActionStatementChoice.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(List<? extends LoanLegalActionStatementChoice> loanLegalActionStatementChoices) {
            if (loanLegalActionStatementChoices != null) {
                for (LoanLegalActionStatementChoice loanLegalActionStatementChoice : loanLegalActionStatementChoices) {
                    this.loanLegalActionStatementChoice.add(loanLegalActionStatementChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanLegalActionStatementChoice")
        public LoanLegalActionStatementBuilder setLoanLegalActionStatementChoice(List<? extends LoanLegalActionStatementChoice> loanLegalActionStatementChoices) {
            this.loanLegalActionStatementChoice = loanLegalActionStatementChoices == null ? new ArrayList<LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder>() : (List)loanLegalActionStatementChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel) {
            if (_loanContractDetailsModel != null) {
                this.loanContractDetailsModel.add(_loanContractDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel, int idx) {
            this.getIndex(this.loanContractDetailsModel, idx, () -> _loanContractDetailsModel.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            if (loanContractDetailsModels != null) {
                for (LoanContractDetailsModel loanContractDetailsModel : loanContractDetailsModels) {
                    this.loanContractDetailsModel.add(loanContractDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractDetailsModel")
        public LoanLegalActionStatementBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            this.loanContractDetailsModel = loanContractDetailsModels == null ? new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>() : (List)loanContractDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel _letterOfCreditDetailsModel) {
            if (_letterOfCreditDetailsModel != null) {
                this.letterOfCreditDetailsModel.add(_letterOfCreditDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel _letterOfCreditDetailsModel, int idx) {
            this.getIndex(this.letterOfCreditDetailsModel, idx, () -> _letterOfCreditDetailsModel.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModels) {
            if (letterOfCreditDetailsModels != null) {
                for (LetterOfCreditDetailsModel letterOfCreditDetailsModel : letterOfCreditDetailsModels) {
                    this.letterOfCreditDetailsModel.add(letterOfCreditDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public LoanLegalActionStatementBuilder setLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModels) {
            this.letterOfCreditDetailsModel = letterOfCreditDetailsModels == null ? new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>() : (List)letterOfCreditDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public LoanLegalActionStatementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanLegalActionStatementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanLegalActionStatement build() {
            return new LoanLegalActionStatementImpl(this);
        }

        @Override
        public LoanLegalActionStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder prune() {
            super.prune();
            if (this.legalAction != null && !this.legalAction.prune().hasData()) {
                this.legalAction = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.deal != null && !this.deal.prune().hasData()) {
                this.deal = null;
            }
            this.loanLegalActionStatementChoice = this.loanLegalActionStatementChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.loanContractDetailsModel = this.loanContractDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.letterOfCreditDetailsModel = this.letterOfCreditDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLegalAction() != null && this.getLegalAction().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getDeal() != null && this.getDeal().hasData()) {
                return true;
            }
            if (this.getLoanLegalActionStatementChoice() != null && this.getLoanLegalActionStatementChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLoanContractDetailsModel() != null && this.getLoanContractDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLetterOfCreditDetailsModel() != null && this.getLetterOfCreditDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanLegalActionStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanLegalActionStatementBuilder o = (LoanLegalActionStatementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalAction(), (RosettaModelObjectBuilder)o.getLegalAction(), this::setLegalAction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeal(), (RosettaModelObjectBuilder)o.getDeal(), this::setDeal);
            merger.mergeRosetta(this.getLoanLegalActionStatementChoice(), o.getLoanLegalActionStatementChoice(), this::getOrCreateLoanLegalActionStatementChoice);
            merger.mergeRosetta(this.getLoanContractDetailsModel(), o.getLoanContractDetailsModel(), this::getOrCreateLoanContractDetailsModel);
            merger.mergeRosetta(this.getLetterOfCreditDetailsModel(), o.getLetterOfCreditDetailsModel(), this::getOrCreateLetterOfCreditDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionStatement _that = (LoanLegalActionStatement)this.getType().cast(o);
            if (!Objects.equals(this.legalAction, _that.getLegalAction())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanLegalActionStatementChoice, _that.getLoanLegalActionStatementChoice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.legalAction != null ? this.legalAction.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionStatementChoice != null ? this.loanLegalActionStatementChoice.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionStatementBuilder {legalAction=" + String.valueOf(this.legalAction) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", deal=" + String.valueOf(this.deal) + ", loanLegalActionStatementChoice=" + String.valueOf(this.loanLegalActionStatementChoice) + ", loanContractDetailsModel=" + String.valueOf(this.loanContractDetailsModel) + ", letterOfCreditDetailsModel=" + String.valueOf(this.letterOfCreditDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface LoanLegalActionStatementBuilder
    extends LoanLegalActionStatement,
    AbstractLoanStatement.AbstractLoanStatementBuilder {
        public LoanLegalAction.LoanLegalActionBuilder getOrCreateLegalAction();

        @Override
        public LoanLegalAction.LoanLegalActionBuilder getLegalAction();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public Deal.DealBuilder getOrCreateDeal();

        @Override
        public Deal.DealBuilder getDeal();

        public LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder getOrCreateLoanLegalActionStatementChoice(int var1);

        public List<? extends LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder> getLoanLegalActionStatementChoice();

        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int var1);

        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel();

        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel(int var1);

        public List<? extends LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> getLetterOfCreditDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanLegalActionStatementBuilder setFpmlVersion(String var1);

        @Override
        public LoanLegalActionStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanLegalActionStatementBuilder setActualBuild(Integer var1);

        @Override
        public LoanLegalActionStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanLegalActionStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanLegalActionStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanLegalActionStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanLegalActionStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanLegalActionStatementBuilder setStatementDate(ZonedDateTime var1);

        @Override
        public LoanLegalActionStatementBuilder setComments(String var1);

        public LoanLegalActionStatementBuilder setLegalAction(LoanLegalAction var1);

        public LoanLegalActionStatementBuilder setDealDetailsModel(DealDetailsModel var1);

        public LoanLegalActionStatementBuilder setDeal(Deal var1);

        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(LoanLegalActionStatementChoice var1);

        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(LoanLegalActionStatementChoice var1, int var2);

        public LoanLegalActionStatementBuilder addLoanLegalActionStatementChoice(List<? extends LoanLegalActionStatementChoice> var1);

        public LoanLegalActionStatementBuilder setLoanLegalActionStatementChoice(List<? extends LoanLegalActionStatementChoice> var1);

        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1);

        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1, int var2);

        public LoanLegalActionStatementBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public LoanLegalActionStatementBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel var1);

        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel var1, int var2);

        public LoanLegalActionStatementBuilder addLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> var1);

        public LoanLegalActionStatementBuilder setLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> var1);

        public LoanLegalActionStatementBuilder addParty(Party var1);

        public LoanLegalActionStatementBuilder addParty(Party var1, int var2);

        public LoanLegalActionStatementBuilder addParty(List<? extends Party> var1);

        public LoanLegalActionStatementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAction"), processor, LoanLegalAction.LoanLegalActionBuilder.class, this.getLegalAction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deal"), processor, Deal.DealBuilder.class, this.getDeal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalActionStatementChoice"), processor, LoanLegalActionStatementChoice.LoanLegalActionStatementChoiceBuilder.class, this.getLoanLegalActionStatementChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.LoanContractDetailsModelBuilder.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanLegalActionStatementBuilder prune();
    }

    public static class LoanLegalActionStatementImpl
    extends AbstractLoanStatement.AbstractLoanStatementImpl
    implements LoanLegalActionStatement {
        private final LoanLegalAction legalAction;
        private final DealDetailsModel dealDetailsModel;
        private final Deal deal;
        private final List<? extends LoanLegalActionStatementChoice> loanLegalActionStatementChoice;
        private final List<? extends LoanContractDetailsModel> loanContractDetailsModel;
        private final List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModel;
        private final List<? extends Party> party;

        protected LoanLegalActionStatementImpl(LoanLegalActionStatementBuilder builder) {
            super(builder);
            this.legalAction = Optional.ofNullable(builder.getLegalAction()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.deal = Optional.ofNullable(builder.getDeal()).map(f -> f.build()).orElse(null);
            this.loanLegalActionStatementChoice = Optional.ofNullable(builder.getLoanLegalActionStatementChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.loanContractDetailsModel = Optional.ofNullable(builder.getLoanContractDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.letterOfCreditDetailsModel = Optional.ofNullable(builder.getLetterOfCreditDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="legalAction", isRequired=true)
        @RuneAttribute(value="legalAction", isRequired=true)
        public LoanLegalAction getLegalAction() {
            return this.legalAction;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="deal")
        @RuneAttribute(value="deal")
        public Deal getDeal() {
            return this.deal;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionStatementChoice")
        @RuneAttribute(value="loanLegalActionStatementChoice")
        public List<? extends LoanLegalActionStatementChoice> getLoanLegalActionStatementChoice() {
            return this.loanLegalActionStatementChoice;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public List<? extends LetterOfCreditDetailsModel> getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanLegalActionStatement build() {
            return this;
        }

        @Override
        public LoanLegalActionStatementBuilder toBuilder() {
            LoanLegalActionStatementBuilder builder = LoanLegalActionStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalActionStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLegalAction()).ifPresent(builder::setLegalAction);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getDeal()).ifPresent(builder::setDeal);
            Optional.ofNullable(this.getLoanLegalActionStatementChoice()).ifPresent(builder::setLoanLegalActionStatementChoice);
            Optional.ofNullable(this.getLoanContractDetailsModel()).ifPresent(builder::setLoanContractDetailsModel);
            Optional.ofNullable(this.getLetterOfCreditDetailsModel()).ifPresent(builder::setLetterOfCreditDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionStatement _that = (LoanLegalActionStatement)this.getType().cast(o);
            if (!Objects.equals(this.legalAction, _that.getLegalAction())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanLegalActionStatementChoice, _that.getLoanLegalActionStatementChoice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.legalAction != null ? this.legalAction.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionStatementChoice != null ? this.loanLegalActionStatementChoice.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionStatement {legalAction=" + String.valueOf(this.legalAction) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", deal=" + String.valueOf(this.deal) + ", loanLegalActionStatementChoice=" + String.valueOf(this.loanLegalActionStatementChoice) + ", loanContractDetailsModel=" + String.valueOf(this.loanContractDetailsModel) + ", letterOfCreditDetailsModel=" + String.valueOf(this.letterOfCreditDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

