/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractServicingNotification;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.LegalActionIdentifier;
import fpml.consolidated.loan.LoanLegalAction;
import fpml.consolidated.loan.LoanLegalActionNotificationChoice0;
import fpml.consolidated.loan.LoanLegalActionNotificationChoice1;
import fpml.consolidated.loan.LoanLegalActionSummary;
import fpml.consolidated.loan.meta.LoanLegalActionNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalActionNotification", builder=LoanLegalActionNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanLegalActionNotification", model="fpml", builder=LoanLegalActionNotificationBuilderImpl.class, version="1.2.2")
public interface LoanLegalActionNotification
extends AbstractServicingNotification {
    public static final LoanLegalActionNotificationMeta metaData = new LoanLegalActionNotificationMeta();

    public List<? extends LoanLegalActionNotificationChoice0> getLoanLegalActionNotificationChoice0();

    public LegalActionIdentifier getLegalActionIdentifier();

    public LoanLegalActionSummary getLegalActionSummary();

    public LoanLegalAction getLegalAction();

    public List<? extends LoanLegalActionNotificationChoice1> getLoanLegalActionNotificationChoice1();

    public List<? extends Party> getParty();

    @Override
    public LoanLegalActionNotification build();

    @Override
    public LoanLegalActionNotificationBuilder toBuilder();

    public static LoanLegalActionNotificationBuilder builder() {
        return new LoanLegalActionNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalActionNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalActionNotification> getType() {
        return LoanLegalActionNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalActionNotificationChoice0"), processor, LoanLegalActionNotificationChoice0.class, this.getLoanLegalActionNotificationChoice0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionIdentifier"), processor, LegalActionIdentifier.class, this.getLegalActionIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionSummary"), processor, LoanLegalActionSummary.class, this.getLegalActionSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAction"), processor, LoanLegalAction.class, this.getLegalAction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalActionNotificationChoice1"), processor, LoanLegalActionNotificationChoice1.class, this.getLoanLegalActionNotificationChoice1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanLegalActionNotificationBuilderImpl
    extends AbstractServicingNotification.AbstractServicingNotificationBuilderImpl
    implements LoanLegalActionNotificationBuilder {
        protected List<LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder> loanLegalActionNotificationChoice0 = new ArrayList<LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder>();
        protected LegalActionIdentifier.LegalActionIdentifierBuilder legalActionIdentifier;
        protected LoanLegalActionSummary.LoanLegalActionSummaryBuilder legalActionSummary;
        protected LoanLegalAction.LoanLegalActionBuilder legalAction;
        protected List<LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder> loanLegalActionNotificationChoice1 = new ArrayList<LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        public List<? extends LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder> getLoanLegalActionNotificationChoice0() {
            return this.loanLegalActionNotificationChoice0;
        }

        @Override
        public LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder getOrCreateLoanLegalActionNotificationChoice0(int index) {
            if (this.loanLegalActionNotificationChoice0 == null) {
                this.loanLegalActionNotificationChoice0 = new ArrayList<LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder>();
            }
            return (LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder)this.getIndex(this.loanLegalActionNotificationChoice0, index, () -> {
                LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder newLoanLegalActionNotificationChoice0 = LoanLegalActionNotificationChoice0.builder();
                return newLoanLegalActionNotificationChoice0;
            });
        }

        @Override
        @RosettaAttribute(value="legalActionIdentifier")
        @RuneAttribute(value="legalActionIdentifier")
        public LegalActionIdentifier.LegalActionIdentifierBuilder getLegalActionIdentifier() {
            return this.legalActionIdentifier;
        }

        @Override
        public LegalActionIdentifier.LegalActionIdentifierBuilder getOrCreateLegalActionIdentifier() {
            LegalActionIdentifier.LegalActionIdentifierBuilder result = this.legalActionIdentifier != null ? this.legalActionIdentifier : (this.legalActionIdentifier = LegalActionIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legalActionSummary")
        @RuneAttribute(value="legalActionSummary")
        public LoanLegalActionSummary.LoanLegalActionSummaryBuilder getLegalActionSummary() {
            return this.legalActionSummary;
        }

        @Override
        public LoanLegalActionSummary.LoanLegalActionSummaryBuilder getOrCreateLegalActionSummary() {
            LoanLegalActionSummary.LoanLegalActionSummaryBuilder result = this.legalActionSummary != null ? this.legalActionSummary : (this.legalActionSummary = LoanLegalActionSummary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legalAction")
        @RuneAttribute(value="legalAction")
        public LoanLegalAction.LoanLegalActionBuilder getLegalAction() {
            return this.legalAction;
        }

        @Override
        public LoanLegalAction.LoanLegalActionBuilder getOrCreateLegalAction() {
            LoanLegalAction.LoanLegalActionBuilder result = this.legalAction != null ? this.legalAction : (this.legalAction = LoanLegalAction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice1")
        @RuneAttribute(value="loanLegalActionNotificationChoice1")
        public List<? extends LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder> getLoanLegalActionNotificationChoice1() {
            return this.loanLegalActionNotificationChoice1;
        }

        @Override
        public LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder getOrCreateLoanLegalActionNotificationChoice1(int index) {
            if (this.loanLegalActionNotificationChoice1 == null) {
                this.loanLegalActionNotificationChoice1 = new ArrayList<LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder>();
            }
            return (LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder)this.getIndex(this.loanLegalActionNotificationChoice1, index, () -> {
                LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder newLoanLegalActionNotificationChoice1 = LoanLegalActionNotificationChoice1.builder();
                return newLoanLegalActionNotificationChoice1;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanLegalActionNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanLegalActionNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanLegalActionNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanLegalActionNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanLegalActionNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanLegalActionNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanLegalActionNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanLegalActionNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public LoanLegalActionNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public LoanLegalActionNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public LoanLegalActionNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public LoanLegalActionNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(LoanLegalActionNotificationChoice0 _loanLegalActionNotificationChoice0) {
            if (_loanLegalActionNotificationChoice0 != null) {
                this.loanLegalActionNotificationChoice0.add(_loanLegalActionNotificationChoice0.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(LoanLegalActionNotificationChoice0 _loanLegalActionNotificationChoice0, int idx) {
            this.getIndex(this.loanLegalActionNotificationChoice0, idx, () -> _loanLegalActionNotificationChoice0.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(List<? extends LoanLegalActionNotificationChoice0> loanLegalActionNotificationChoice0s) {
            if (loanLegalActionNotificationChoice0s != null) {
                for (LoanLegalActionNotificationChoice0 loanLegalActionNotificationChoice0 : loanLegalActionNotificationChoice0s) {
                    this.loanLegalActionNotificationChoice0.add(loanLegalActionNotificationChoice0.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanLegalActionNotificationChoice0")
        public LoanLegalActionNotificationBuilder setLoanLegalActionNotificationChoice0(List<? extends LoanLegalActionNotificationChoice0> loanLegalActionNotificationChoice0s) {
            this.loanLegalActionNotificationChoice0 = loanLegalActionNotificationChoice0s == null ? new ArrayList<LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder>() : (List)loanLegalActionNotificationChoice0s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionIdentifier")
        @RuneAttribute(value="legalActionIdentifier")
        public LoanLegalActionNotificationBuilder setLegalActionIdentifier(LegalActionIdentifier _legalActionIdentifier) {
            this.legalActionIdentifier = _legalActionIdentifier == null ? null : _legalActionIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionSummary")
        @RuneAttribute(value="legalActionSummary")
        public LoanLegalActionNotificationBuilder setLegalActionSummary(LoanLegalActionSummary _legalActionSummary) {
            this.legalActionSummary = _legalActionSummary == null ? null : _legalActionSummary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legalAction")
        @RuneAttribute(value="legalAction")
        public LoanLegalActionNotificationBuilder setLegalAction(LoanLegalAction _legalAction) {
            this.legalAction = _legalAction == null ? null : _legalAction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice1")
        @RuneAttribute(value="loanLegalActionNotificationChoice1")
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(LoanLegalActionNotificationChoice1 _loanLegalActionNotificationChoice1) {
            if (_loanLegalActionNotificationChoice1 != null) {
                this.loanLegalActionNotificationChoice1.add(_loanLegalActionNotificationChoice1.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(LoanLegalActionNotificationChoice1 _loanLegalActionNotificationChoice1, int idx) {
            this.getIndex(this.loanLegalActionNotificationChoice1, idx, () -> _loanLegalActionNotificationChoice1.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(List<? extends LoanLegalActionNotificationChoice1> loanLegalActionNotificationChoice1s) {
            if (loanLegalActionNotificationChoice1s != null) {
                for (LoanLegalActionNotificationChoice1 loanLegalActionNotificationChoice1 : loanLegalActionNotificationChoice1s) {
                    this.loanLegalActionNotificationChoice1.add(loanLegalActionNotificationChoice1.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanLegalActionNotificationChoice1")
        public LoanLegalActionNotificationBuilder setLoanLegalActionNotificationChoice1(List<? extends LoanLegalActionNotificationChoice1> loanLegalActionNotificationChoice1s) {
            this.loanLegalActionNotificationChoice1 = loanLegalActionNotificationChoice1s == null ? new ArrayList<LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder>() : (List)loanLegalActionNotificationChoice1s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public LoanLegalActionNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanLegalActionNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanLegalActionNotification build() {
            return new LoanLegalActionNotificationImpl(this);
        }

        @Override
        public LoanLegalActionNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder prune() {
            super.prune();
            this.loanLegalActionNotificationChoice0 = this.loanLegalActionNotificationChoice0.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.legalActionIdentifier != null && !this.legalActionIdentifier.prune().hasData()) {
                this.legalActionIdentifier = null;
            }
            if (this.legalActionSummary != null && !this.legalActionSummary.prune().hasData()) {
                this.legalActionSummary = null;
            }
            if (this.legalAction != null && !this.legalAction.prune().hasData()) {
                this.legalAction = null;
            }
            this.loanLegalActionNotificationChoice1 = this.loanLegalActionNotificationChoice1.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanLegalActionNotificationChoice0() != null && this.getLoanLegalActionNotificationChoice0().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLegalActionIdentifier() != null && this.getLegalActionIdentifier().hasData()) {
                return true;
            }
            if (this.getLegalActionSummary() != null && this.getLegalActionSummary().hasData()) {
                return true;
            }
            if (this.getLegalAction() != null && this.getLegalAction().hasData()) {
                return true;
            }
            if (this.getLoanLegalActionNotificationChoice1() != null && this.getLoanLegalActionNotificationChoice1().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanLegalActionNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanLegalActionNotificationBuilder o = (LoanLegalActionNotificationBuilder)other;
            merger.mergeRosetta(this.getLoanLegalActionNotificationChoice0(), o.getLoanLegalActionNotificationChoice0(), this::getOrCreateLoanLegalActionNotificationChoice0);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalActionIdentifier(), (RosettaModelObjectBuilder)o.getLegalActionIdentifier(), this::setLegalActionIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalActionSummary(), (RosettaModelObjectBuilder)o.getLegalActionSummary(), this::setLegalActionSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalAction(), (RosettaModelObjectBuilder)o.getLegalAction(), this::setLegalAction);
            merger.mergeRosetta(this.getLoanLegalActionNotificationChoice1(), o.getLoanLegalActionNotificationChoice1(), this::getOrCreateLoanLegalActionNotificationChoice1);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionNotification _that = (LoanLegalActionNotification)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanLegalActionNotificationChoice0, _that.getLoanLegalActionNotificationChoice0())) {
                return false;
            }
            if (!Objects.equals(this.legalActionIdentifier, _that.getLegalActionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.legalActionSummary, _that.getLegalActionSummary())) {
                return false;
            }
            if (!Objects.equals(this.legalAction, _that.getLegalAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanLegalActionNotificationChoice1, _that.getLoanLegalActionNotificationChoice1())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanLegalActionNotificationChoice0 != null ? this.loanLegalActionNotificationChoice0.hashCode() : 0);
            _result = 31 * _result + (this.legalActionIdentifier != null ? this.legalActionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.legalActionSummary != null ? this.legalActionSummary.hashCode() : 0);
            _result = 31 * _result + (this.legalAction != null ? this.legalAction.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionNotificationChoice1 != null ? this.loanLegalActionNotificationChoice1.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionNotificationBuilder {loanLegalActionNotificationChoice0=" + String.valueOf(this.loanLegalActionNotificationChoice0) + ", legalActionIdentifier=" + String.valueOf(this.legalActionIdentifier) + ", legalActionSummary=" + String.valueOf(this.legalActionSummary) + ", legalAction=" + String.valueOf(this.legalAction) + ", loanLegalActionNotificationChoice1=" + String.valueOf(this.loanLegalActionNotificationChoice1) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface LoanLegalActionNotificationBuilder
    extends LoanLegalActionNotification,
    AbstractServicingNotification.AbstractServicingNotificationBuilder {
        public LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder getOrCreateLoanLegalActionNotificationChoice0(int var1);

        public List<? extends LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder> getLoanLegalActionNotificationChoice0();

        public LegalActionIdentifier.LegalActionIdentifierBuilder getOrCreateLegalActionIdentifier();

        @Override
        public LegalActionIdentifier.LegalActionIdentifierBuilder getLegalActionIdentifier();

        public LoanLegalActionSummary.LoanLegalActionSummaryBuilder getOrCreateLegalActionSummary();

        @Override
        public LoanLegalActionSummary.LoanLegalActionSummaryBuilder getLegalActionSummary();

        public LoanLegalAction.LoanLegalActionBuilder getOrCreateLegalAction();

        @Override
        public LoanLegalAction.LoanLegalActionBuilder getLegalAction();

        public LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder getOrCreateLoanLegalActionNotificationChoice1(int var1);

        public List<? extends LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder> getLoanLegalActionNotificationChoice1();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanLegalActionNotificationBuilder setFpmlVersion(String var1);

        @Override
        public LoanLegalActionNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanLegalActionNotificationBuilder setActualBuild(Integer var1);

        @Override
        public LoanLegalActionNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanLegalActionNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanLegalActionNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanLegalActionNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanLegalActionNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanLegalActionNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public LoanLegalActionNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public LoanLegalActionNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public LoanLegalActionNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public LoanLegalActionNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public LoanLegalActionNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(LoanLegalActionNotificationChoice0 var1);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(LoanLegalActionNotificationChoice0 var1, int var2);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice0(List<? extends LoanLegalActionNotificationChoice0> var1);

        public LoanLegalActionNotificationBuilder setLoanLegalActionNotificationChoice0(List<? extends LoanLegalActionNotificationChoice0> var1);

        public LoanLegalActionNotificationBuilder setLegalActionIdentifier(LegalActionIdentifier var1);

        public LoanLegalActionNotificationBuilder setLegalActionSummary(LoanLegalActionSummary var1);

        public LoanLegalActionNotificationBuilder setLegalAction(LoanLegalAction var1);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(LoanLegalActionNotificationChoice1 var1);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(LoanLegalActionNotificationChoice1 var1, int var2);

        public LoanLegalActionNotificationBuilder addLoanLegalActionNotificationChoice1(List<? extends LoanLegalActionNotificationChoice1> var1);

        public LoanLegalActionNotificationBuilder setLoanLegalActionNotificationChoice1(List<? extends LoanLegalActionNotificationChoice1> var1);

        public LoanLegalActionNotificationBuilder addParty(Party var1);

        public LoanLegalActionNotificationBuilder addParty(Party var1, int var2);

        public LoanLegalActionNotificationBuilder addParty(List<? extends Party> var1);

        public LoanLegalActionNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalActionNotificationChoice0"), processor, LoanLegalActionNotificationChoice0.LoanLegalActionNotificationChoice0Builder.class, this.getLoanLegalActionNotificationChoice0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionIdentifier"), processor, LegalActionIdentifier.LegalActionIdentifierBuilder.class, this.getLegalActionIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionSummary"), processor, LoanLegalActionSummary.LoanLegalActionSummaryBuilder.class, this.getLegalActionSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAction"), processor, LoanLegalAction.LoanLegalActionBuilder.class, this.getLegalAction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalActionNotificationChoice1"), processor, LoanLegalActionNotificationChoice1.LoanLegalActionNotificationChoice1Builder.class, this.getLoanLegalActionNotificationChoice1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanLegalActionNotificationBuilder prune();
    }

    public static class LoanLegalActionNotificationImpl
    extends AbstractServicingNotification.AbstractServicingNotificationImpl
    implements LoanLegalActionNotification {
        private final List<? extends LoanLegalActionNotificationChoice0> loanLegalActionNotificationChoice0;
        private final LegalActionIdentifier legalActionIdentifier;
        private final LoanLegalActionSummary legalActionSummary;
        private final LoanLegalAction legalAction;
        private final List<? extends LoanLegalActionNotificationChoice1> loanLegalActionNotificationChoice1;
        private final List<? extends Party> party;

        protected LoanLegalActionNotificationImpl(LoanLegalActionNotificationBuilder builder) {
            super(builder);
            this.loanLegalActionNotificationChoice0 = Optional.ofNullable(builder.getLoanLegalActionNotificationChoice0()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legalActionIdentifier = Optional.ofNullable(builder.getLegalActionIdentifier()).map(f -> f.build()).orElse(null);
            this.legalActionSummary = Optional.ofNullable(builder.getLegalActionSummary()).map(f -> f.build()).orElse(null);
            this.legalAction = Optional.ofNullable(builder.getLegalAction()).map(f -> f.build()).orElse(null);
            this.loanLegalActionNotificationChoice1 = Optional.ofNullable(builder.getLoanLegalActionNotificationChoice1()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanLegalActionNotificationChoice0", isRequired=true)
        public List<? extends LoanLegalActionNotificationChoice0> getLoanLegalActionNotificationChoice0() {
            return this.loanLegalActionNotificationChoice0;
        }

        @Override
        @RosettaAttribute(value="legalActionIdentifier")
        @RuneAttribute(value="legalActionIdentifier")
        public LegalActionIdentifier getLegalActionIdentifier() {
            return this.legalActionIdentifier;
        }

        @Override
        @RosettaAttribute(value="legalActionSummary")
        @RuneAttribute(value="legalActionSummary")
        public LoanLegalActionSummary getLegalActionSummary() {
            return this.legalActionSummary;
        }

        @Override
        @RosettaAttribute(value="legalAction")
        @RuneAttribute(value="legalAction")
        public LoanLegalAction getLegalAction() {
            return this.legalAction;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionNotificationChoice1")
        @RuneAttribute(value="loanLegalActionNotificationChoice1")
        public List<? extends LoanLegalActionNotificationChoice1> getLoanLegalActionNotificationChoice1() {
            return this.loanLegalActionNotificationChoice1;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanLegalActionNotification build() {
            return this;
        }

        @Override
        public LoanLegalActionNotificationBuilder toBuilder() {
            LoanLegalActionNotificationBuilder builder = LoanLegalActionNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalActionNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanLegalActionNotificationChoice0()).ifPresent(builder::setLoanLegalActionNotificationChoice0);
            Optional.ofNullable(this.getLegalActionIdentifier()).ifPresent(builder::setLegalActionIdentifier);
            Optional.ofNullable(this.getLegalActionSummary()).ifPresent(builder::setLegalActionSummary);
            Optional.ofNullable(this.getLegalAction()).ifPresent(builder::setLegalAction);
            Optional.ofNullable(this.getLoanLegalActionNotificationChoice1()).ifPresent(builder::setLoanLegalActionNotificationChoice1);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionNotification _that = (LoanLegalActionNotification)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanLegalActionNotificationChoice0, _that.getLoanLegalActionNotificationChoice0())) {
                return false;
            }
            if (!Objects.equals(this.legalActionIdentifier, _that.getLegalActionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.legalActionSummary, _that.getLegalActionSummary())) {
                return false;
            }
            if (!Objects.equals(this.legalAction, _that.getLegalAction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanLegalActionNotificationChoice1, _that.getLoanLegalActionNotificationChoice1())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanLegalActionNotificationChoice0 != null ? this.loanLegalActionNotificationChoice0.hashCode() : 0);
            _result = 31 * _result + (this.legalActionIdentifier != null ? this.legalActionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.legalActionSummary != null ? this.legalActionSummary.hashCode() : 0);
            _result = 31 * _result + (this.legalAction != null ? this.legalAction.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionNotificationChoice1 != null ? this.loanLegalActionNotificationChoice1.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionNotification {loanLegalActionNotificationChoice0=" + String.valueOf(this.loanLegalActionNotificationChoice0) + ", legalActionIdentifier=" + String.valueOf(this.legalActionIdentifier) + ", legalActionSummary=" + String.valueOf(this.legalActionSummary) + ", legalAction=" + String.valueOf(this.legalAction) + ", loanLegalActionNotificationChoice1=" + String.valueOf(this.loanLegalActionNotificationChoice1) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

