/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractLoanFloatingRateOptionBase;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.LoanFloatingRate;
import fpml.consolidated.loan.LoanFloatingRateAccrualSequence;
import fpml.consolidated.loan.PeriodWithDaysModel;
import fpml.consolidated.loan.meta.LoanFloatingRateAccrualMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanFloatingRateAccrual", builder=LoanFloatingRateAccrualBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanFloatingRateAccrual", model="fpml", builder=LoanFloatingRateAccrualBuilderImpl.class, version="1.2.2")
public interface LoanFloatingRateAccrual
extends AbstractLoanFloatingRateOptionBase {
    public static final LoanFloatingRateAccrualMeta metaData = new LoanFloatingRateAccrualMeta();

    public PeriodWithDaysModel getPeriodWithDaysModel();

    public LoanFloatingRateAccrualSequence getLoanFloatingRateAccrualSequence();

    @Override
    public LoanFloatingRateAccrual build();

    @Override
    public LoanFloatingRateAccrualBuilder toBuilder();

    public static LoanFloatingRateAccrualBuilder builder() {
        return new LoanFloatingRateAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanFloatingRateAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanFloatingRateAccrual> getType() {
        return LoanFloatingRateAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.class, this.getRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanFloatingRateAccrualSequence"), processor, LoanFloatingRateAccrualSequence.class, this.getLoanFloatingRateAccrualSequence(), new AttributeMeta[0]);
    }

    public static class LoanFloatingRateAccrualBuilderImpl
    extends AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseBuilderImpl
    implements LoanFloatingRateAccrualBuilder {
        protected PeriodWithDaysModel.PeriodWithDaysModelBuilder periodWithDaysModel;
        protected LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder loanFloatingRateAccrualSequence;

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel() {
            PeriodWithDaysModel.PeriodWithDaysModelBuilder result = this.periodWithDaysModel != null ? this.periodWithDaysModel : (this.periodWithDaysModel = PeriodWithDaysModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanFloatingRateAccrualSequence")
        @RuneAttribute(value="loanFloatingRateAccrualSequence")
        public LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder getLoanFloatingRateAccrualSequence() {
            return this.loanFloatingRateAccrualSequence;
        }

        @Override
        public LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder getOrCreateLoanFloatingRateAccrualSequence() {
            LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder result = this.loanFloatingRateAccrualSequence != null ? this.loanFloatingRateAccrualSequence : (this.loanFloatingRateAccrualSequence = LoanFloatingRateAccrualSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public LoanFloatingRateAccrualBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public LoanFloatingRateAccrualBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public LoanFloatingRateAccrualBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LoanFloatingRateAccrualBuilder setRate(LoanFloatingRate _rate) {
            this.rate = _rate == null ? null : _rate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public LoanFloatingRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel _periodWithDaysModel) {
            this.periodWithDaysModel = _periodWithDaysModel == null ? null : _periodWithDaysModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanFloatingRateAccrualSequence")
        @RuneAttribute(value="loanFloatingRateAccrualSequence")
        public LoanFloatingRateAccrualBuilder setLoanFloatingRateAccrualSequence(LoanFloatingRateAccrualSequence _loanFloatingRateAccrualSequence) {
            this.loanFloatingRateAccrualSequence = _loanFloatingRateAccrualSequence == null ? null : _loanFloatingRateAccrualSequence.toBuilder();
            return this;
        }

        @Override
        public LoanFloatingRateAccrual build() {
            return new LoanFloatingRateAccrualImpl(this);
        }

        @Override
        public LoanFloatingRateAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanFloatingRateAccrualBuilder prune() {
            super.prune();
            if (this.periodWithDaysModel != null && !this.periodWithDaysModel.prune().hasData()) {
                this.periodWithDaysModel = null;
            }
            if (this.loanFloatingRateAccrualSequence != null && !this.loanFloatingRateAccrualSequence.prune().hasData()) {
                this.loanFloatingRateAccrualSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodWithDaysModel() != null && this.getPeriodWithDaysModel().hasData()) {
                return true;
            }
            return this.getLoanFloatingRateAccrualSequence() != null && this.getLoanFloatingRateAccrualSequence().hasData();
        }

        @Override
        public LoanFloatingRateAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanFloatingRateAccrualBuilder o = (LoanFloatingRateAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodWithDaysModel(), (RosettaModelObjectBuilder)o.getPeriodWithDaysModel(), this::setPeriodWithDaysModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanFloatingRateAccrualSequence(), (RosettaModelObjectBuilder)o.getLoanFloatingRateAccrualSequence(), this::setLoanFloatingRateAccrualSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanFloatingRateAccrual _that = (LoanFloatingRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            return Objects.equals(this.loanFloatingRateAccrualSequence, _that.getLoanFloatingRateAccrualSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.loanFloatingRateAccrualSequence != null ? this.loanFloatingRateAccrualSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanFloatingRateAccrualBuilder {periodWithDaysModel=" + String.valueOf(this.periodWithDaysModel) + ", loanFloatingRateAccrualSequence=" + String.valueOf(this.loanFloatingRateAccrualSequence) + "} " + super.toString();
        }
    }

    public static interface LoanFloatingRateAccrualBuilder
    extends LoanFloatingRateAccrual,
    AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseBuilder {
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel();

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel();

        public LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder getOrCreateLoanFloatingRateAccrualSequence();

        @Override
        public LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder getLoanFloatingRateAccrualSequence();

        @Override
        public LoanFloatingRateAccrualBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public LoanFloatingRateAccrualBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public LoanFloatingRateAccrualBuilder setPaymentFrequency(Period var1);

        @Override
        public LoanFloatingRateAccrualBuilder setRate(LoanFloatingRate var1);

        public LoanFloatingRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel var1);

        public LoanFloatingRateAccrualBuilder setLoanFloatingRateAccrualSequence(LoanFloatingRateAccrualSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.LoanFloatingRateBuilder.class, (RosettaModelObjectBuilder)this.getRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.PeriodWithDaysModelBuilder.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanFloatingRateAccrualSequence"), processor, LoanFloatingRateAccrualSequence.LoanFloatingRateAccrualSequenceBuilder.class, this.getLoanFloatingRateAccrualSequence(), new AttributeMeta[0]);
        }

        @Override
        public LoanFloatingRateAccrualBuilder prune();
    }

    public static class LoanFloatingRateAccrualImpl
    extends AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseImpl
    implements LoanFloatingRateAccrual {
        private final PeriodWithDaysModel periodWithDaysModel;
        private final LoanFloatingRateAccrualSequence loanFloatingRateAccrualSequence;

        protected LoanFloatingRateAccrualImpl(LoanFloatingRateAccrualBuilder builder) {
            super(builder);
            this.periodWithDaysModel = Optional.ofNullable(builder.getPeriodWithDaysModel()).map(f -> f.build()).orElse(null);
            this.loanFloatingRateAccrualSequence = Optional.ofNullable(builder.getLoanFloatingRateAccrualSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        @RosettaAttribute(value="loanFloatingRateAccrualSequence")
        @RuneAttribute(value="loanFloatingRateAccrualSequence")
        public LoanFloatingRateAccrualSequence getLoanFloatingRateAccrualSequence() {
            return this.loanFloatingRateAccrualSequence;
        }

        @Override
        public LoanFloatingRateAccrual build() {
            return this;
        }

        @Override
        public LoanFloatingRateAccrualBuilder toBuilder() {
            LoanFloatingRateAccrualBuilder builder = LoanFloatingRateAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanFloatingRateAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodWithDaysModel()).ifPresent(builder::setPeriodWithDaysModel);
            Optional.ofNullable(this.getLoanFloatingRateAccrualSequence()).ifPresent(builder::setLoanFloatingRateAccrualSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanFloatingRateAccrual _that = (LoanFloatingRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            return Objects.equals(this.loanFloatingRateAccrualSequence, _that.getLoanFloatingRateAccrualSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.loanFloatingRateAccrualSequence != null ? this.loanFloatingRateAccrualSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanFloatingRateAccrual {periodWithDaysModel=" + String.valueOf(this.periodWithDaysModel) + ", loanFloatingRateAccrualSequence=" + String.valueOf(this.loanFloatingRateAccrualSequence) + "} " + super.toString();
        }
    }
}

