/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.LoanAllocationReference;
import fpml.consolidated.loan.LoanSimplePayment;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.meta.LoanAllocationPaymentMeta;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.SettlementInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanAllocationPayment", builder=LoanAllocationPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanAllocationPayment", model="fpml", builder=LoanAllocationPaymentBuilderImpl.class, version="1.2.2")
public interface LoanAllocationPayment
extends LoanSimplePayment {
    public static final LoanAllocationPaymentMeta metaData = new LoanAllocationPaymentMeta();

    public List<? extends LoanAllocationReference> getAllocationReference();

    public SettlementInstruction getReceiverSettlementInstruction();

    @Override
    public LoanAllocationPayment build();

    @Override
    public LoanAllocationPaymentBuilder toBuilder();

    public static LoanAllocationPaymentBuilder builder() {
        return new LoanAllocationPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationPayment> getType() {
        return LoanAllocationPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.class, this.getAllocationReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("receiverSettlementInstruction"), processor, SettlementInstruction.class, this.getReceiverSettlementInstruction(), new AttributeMeta[0]);
    }

    public static class LoanAllocationPaymentBuilderImpl
    extends LoanSimplePayment.LoanSimplePaymentBuilderImpl
    implements LoanAllocationPaymentBuilder {
        protected List<LoanAllocationReference.LoanAllocationReferenceBuilder> allocationReference = new ArrayList<LoanAllocationReference.LoanAllocationReferenceBuilder>();
        protected SettlementInstruction.SettlementInstructionBuilder receiverSettlementInstruction;

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public List<? extends LoanAllocationReference.LoanAllocationReferenceBuilder> getAllocationReference() {
            return this.allocationReference;
        }

        @Override
        public LoanAllocationReference.LoanAllocationReferenceBuilder getOrCreateAllocationReference(int index) {
            if (this.allocationReference == null) {
                this.allocationReference = new ArrayList<LoanAllocationReference.LoanAllocationReferenceBuilder>();
            }
            return (LoanAllocationReference.LoanAllocationReferenceBuilder)this.getIndex(this.allocationReference, index, () -> {
                LoanAllocationReference.LoanAllocationReferenceBuilder newAllocationReference = LoanAllocationReference.builder();
                return newAllocationReference;
            });
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public SettlementInstruction.SettlementInstructionBuilder getReceiverSettlementInstruction() {
            return this.receiverSettlementInstruction;
        }

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getOrCreateReceiverSettlementInstruction() {
            SettlementInstruction.SettlementInstructionBuilder result = this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction : (this.receiverSettlementInstruction = SettlementInstruction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanAllocationPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public LoanAllocationPaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public LoanAllocationPaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public LoanAllocationPaymentBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public LoanAllocationPaymentBuilder addAllocationReference(LoanAllocationReference _allocationReference) {
            if (_allocationReference != null) {
                this.allocationReference.add(_allocationReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationPaymentBuilder addAllocationReference(LoanAllocationReference _allocationReference, int idx) {
            this.getIndex(this.allocationReference, idx, () -> _allocationReference.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationPaymentBuilder addAllocationReference(List<? extends LoanAllocationReference> allocationReferences) {
            if (allocationReferences != null) {
                for (LoanAllocationReference loanAllocationReference : allocationReferences) {
                    this.allocationReference.add(loanAllocationReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocationReference")
        public LoanAllocationPaymentBuilder setAllocationReference(List<? extends LoanAllocationReference> allocationReferences) {
            this.allocationReference = allocationReferences == null ? new ArrayList<LoanAllocationReference.LoanAllocationReferenceBuilder>() : (List)allocationReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public LoanAllocationPaymentBuilder setReceiverSettlementInstruction(SettlementInstruction _receiverSettlementInstruction) {
            this.receiverSettlementInstruction = _receiverSettlementInstruction == null ? null : _receiverSettlementInstruction.toBuilder();
            return this;
        }

        @Override
        public LoanAllocationPayment build() {
            return new LoanAllocationPaymentImpl(this);
        }

        @Override
        public LoanAllocationPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationPaymentBuilder prune() {
            super.prune();
            this.allocationReference = this.allocationReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.receiverSettlementInstruction != null && !this.receiverSettlementInstruction.prune().hasData()) {
                this.receiverSettlementInstruction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAllocationReference() != null && this.getAllocationReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReceiverSettlementInstruction() != null && this.getReceiverSettlementInstruction().hasData();
        }

        @Override
        public LoanAllocationPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationPaymentBuilder o = (LoanAllocationPaymentBuilder)other;
            merger.mergeRosetta(this.getAllocationReference(), o.getAllocationReference(), this::getOrCreateAllocationReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReceiverSettlementInstruction(), (RosettaModelObjectBuilder)o.getReceiverSettlementInstruction(), this::setReceiverSettlementInstruction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationPayment _that = (LoanAllocationPayment)this.getType().cast(o);
            if (!ListEquals.listEquals(this.allocationReference, _that.getAllocationReference())) {
                return false;
            }
            return Objects.equals(this.receiverSettlementInstruction, _that.getReceiverSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.allocationReference != null ? this.allocationReference.hashCode() : 0);
            _result = 31 * _result + (this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationPaymentBuilder {allocationReference=" + String.valueOf(this.allocationReference) + ", receiverSettlementInstruction=" + String.valueOf(this.receiverSettlementInstruction) + "} " + super.toString();
        }
    }

    public static interface LoanAllocationPaymentBuilder
    extends LoanAllocationPayment,
    LoanSimplePayment.LoanSimplePaymentBuilder {
        public LoanAllocationReference.LoanAllocationReferenceBuilder getOrCreateAllocationReference(int var1);

        public List<? extends LoanAllocationReference.LoanAllocationReferenceBuilder> getAllocationReference();

        public SettlementInstruction.SettlementInstructionBuilder getOrCreateReceiverSettlementInstruction();

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getReceiverSettlementInstruction();

        @Override
        public LoanAllocationPaymentBuilder setId(String var1);

        @Override
        public LoanAllocationPaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        @Override
        public LoanAllocationPaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        @Override
        public LoanAllocationPaymentBuilder setPaymentDate(AdjustableDate var1);

        public LoanAllocationPaymentBuilder addAllocationReference(LoanAllocationReference var1);

        public LoanAllocationPaymentBuilder addAllocationReference(LoanAllocationReference var1, int var2);

        public LoanAllocationPaymentBuilder addAllocationReference(List<? extends LoanAllocationReference> var1);

        public LoanAllocationPaymentBuilder setAllocationReference(List<? extends LoanAllocationReference> var1);

        public LoanAllocationPaymentBuilder setReceiverSettlementInstruction(SettlementInstruction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.LoanAllocationReferenceBuilder.class, this.getAllocationReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("receiverSettlementInstruction"), processor, SettlementInstruction.SettlementInstructionBuilder.class, this.getReceiverSettlementInstruction(), new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationPaymentBuilder prune();
    }

    public static class LoanAllocationPaymentImpl
    extends LoanSimplePayment.LoanSimplePaymentImpl
    implements LoanAllocationPayment {
        private final List<? extends LoanAllocationReference> allocationReference;
        private final SettlementInstruction receiverSettlementInstruction;

        protected LoanAllocationPaymentImpl(LoanAllocationPaymentBuilder builder) {
            super(builder);
            this.allocationReference = Optional.ofNullable(builder.getAllocationReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.receiverSettlementInstruction = Optional.ofNullable(builder.getReceiverSettlementInstruction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public List<? extends LoanAllocationReference> getAllocationReference() {
            return this.allocationReference;
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public SettlementInstruction getReceiverSettlementInstruction() {
            return this.receiverSettlementInstruction;
        }

        @Override
        public LoanAllocationPayment build() {
            return this;
        }

        @Override
        public LoanAllocationPaymentBuilder toBuilder() {
            LoanAllocationPaymentBuilder builder = LoanAllocationPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAllocationReference()).ifPresent(builder::setAllocationReference);
            Optional.ofNullable(this.getReceiverSettlementInstruction()).ifPresent(builder::setReceiverSettlementInstruction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationPayment _that = (LoanAllocationPayment)this.getType().cast(o);
            if (!ListEquals.listEquals(this.allocationReference, _that.getAllocationReference())) {
                return false;
            }
            return Objects.equals(this.receiverSettlementInstruction, _that.getReceiverSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.allocationReference != null ? this.allocationReference.hashCode() : 0);
            _result = 31 * _result + (this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationPayment {allocationReference=" + String.valueOf(this.allocationReference) + ", receiverSettlementInstruction=" + String.valueOf(this.receiverSettlementInstruction) + "} " + super.toString();
        }
    }
}

