/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.FeeRateOptionBase;
import fpml.consolidated.loan.LcType;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LcOptionMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.PeriodModel;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LcOption", builder=LcOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LcOption", model="fpml", builder=LcOptionBuilderImpl.class, version="1.2.2")
public interface LcOption
extends FeeRateOptionBase {
    public static final LcOptionMeta metaData = new LcOptionMeta();

    public PeriodModel getPeriodModel();

    public LcType _getType();

    public MoneyWithParticipantShare getMinLcIssuanceFeeAmount();

    @Override
    public LcOption build();

    @Override
    public LcOptionBuilder toBuilder();

    public static LcOptionBuilder builder() {
        return new LcOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends LcOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcOption> getType() {
        return LcOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("type"), processor, LcType.class, this._getType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minLcIssuanceFeeAmount"), processor, MoneyWithParticipantShare.class, this.getMinLcIssuanceFeeAmount(), new AttributeMeta[0]);
    }

    public static class LcOptionBuilderImpl
    extends FeeRateOptionBase.FeeRateOptionBaseBuilderImpl
    implements LcOptionBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected LcType.LcTypeBuilder type;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder minLcIssuanceFeeAmount;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LcType.LcTypeBuilder _getType() {
            return this.type;
        }

        @Override
        public LcType.LcTypeBuilder getOrCreateType() {
            LcType.LcTypeBuilder result = this.type != null ? this.type : (this.type = LcType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minLcIssuanceFeeAmount")
        @RuneAttribute(value="minLcIssuanceFeeAmount")
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getMinLcIssuanceFeeAmount() {
            return this.minLcIssuanceFeeAmount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateMinLcIssuanceFeeAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.minLcIssuanceFeeAmount != null ? this.minLcIssuanceFeeAmount : (this.minLcIssuanceFeeAmount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public LcOptionBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public LcOptionBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public LcOptionBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LcOptionBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public LcOptionBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LcOptionBuilder setType(LcType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minLcIssuanceFeeAmount")
        @RuneAttribute(value="minLcIssuanceFeeAmount")
        public LcOptionBuilder setMinLcIssuanceFeeAmount(MoneyWithParticipantShare _minLcIssuanceFeeAmount) {
            this.minLcIssuanceFeeAmount = _minLcIssuanceFeeAmount == null ? null : _minLcIssuanceFeeAmount.toBuilder();
            return this;
        }

        @Override
        public LcOption build() {
            return new LcOptionImpl(this);
        }

        @Override
        public LcOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public LcOptionBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.type != null && !this.type.prune().hasData()) {
                this.type = null;
            }
            if (this.minLcIssuanceFeeAmount != null && !this.minLcIssuanceFeeAmount.prune().hasData()) {
                this.minLcIssuanceFeeAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this._getType() != null && this._getType().hasData()) {
                return true;
            }
            return this.getMinLcIssuanceFeeAmount() != null && this.getMinLcIssuanceFeeAmount().hasData();
        }

        @Override
        public LcOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcOptionBuilder o = (LcOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this._getType(), (RosettaModelObjectBuilder)o._getType(), this::setType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinLcIssuanceFeeAmount(), (RosettaModelObjectBuilder)o.getMinLcIssuanceFeeAmount(), this::setMinLcIssuanceFeeAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcOption _that = (LcOption)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            return Objects.equals(this.minLcIssuanceFeeAmount, _that.getMinLcIssuanceFeeAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.minLcIssuanceFeeAmount != null ? this.minLcIssuanceFeeAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcOptionBuilder {periodModel=" + String.valueOf(this.periodModel) + ", type=" + String.valueOf(this.type) + ", minLcIssuanceFeeAmount=" + String.valueOf(this.minLcIssuanceFeeAmount) + "} " + super.toString();
        }
    }

    public static interface LcOptionBuilder
    extends LcOption,
    FeeRateOptionBase.FeeRateOptionBaseBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public LcType.LcTypeBuilder getOrCreateType();

        @Override
        public LcType.LcTypeBuilder _getType();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateMinLcIssuanceFeeAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getMinLcIssuanceFeeAmount();

        @Override
        public LcOptionBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public LcOptionBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public LcOptionBuilder setPaymentFrequency(Period var1);

        @Override
        public LcOptionBuilder setRate(BigDecimal var1);

        public LcOptionBuilder setPeriodModel(PeriodModel var1);

        public LcOptionBuilder setType(LcType var1);

        public LcOptionBuilder setMinLcIssuanceFeeAmount(MoneyWithParticipantShare var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("type"), processor, LcType.LcTypeBuilder.class, this._getType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minLcIssuanceFeeAmount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getMinLcIssuanceFeeAmount(), new AttributeMeta[0]);
        }

        @Override
        public LcOptionBuilder prune();
    }

    public static class LcOptionImpl
    extends FeeRateOptionBase.FeeRateOptionBaseImpl
    implements LcOption {
        private final PeriodModel periodModel;
        private final LcType type;
        private final MoneyWithParticipantShare minLcIssuanceFeeAmount;

        protected LcOptionImpl(LcOptionBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.type = Optional.ofNullable(builder._getType()).map(f -> f.build()).orElse(null);
            this.minLcIssuanceFeeAmount = Optional.ofNullable(builder.getMinLcIssuanceFeeAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LcType _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="minLcIssuanceFeeAmount")
        @RuneAttribute(value="minLcIssuanceFeeAmount")
        public MoneyWithParticipantShare getMinLcIssuanceFeeAmount() {
            return this.minLcIssuanceFeeAmount;
        }

        @Override
        public LcOption build() {
            return this;
        }

        @Override
        public LcOptionBuilder toBuilder() {
            LcOptionBuilder builder = LcOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getMinLcIssuanceFeeAmount()).ifPresent(builder::setMinLcIssuanceFeeAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcOption _that = (LcOption)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            return Objects.equals(this.minLcIssuanceFeeAmount, _that.getMinLcIssuanceFeeAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.minLcIssuanceFeeAmount != null ? this.minLcIssuanceFeeAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcOption {periodModel=" + String.valueOf(this.periodModel) + ", type=" + String.valueOf(this.type) + ", minLcIssuanceFeeAmount=" + String.valueOf(this.minLcIssuanceFeeAmount) + "} " + super.toString();
        }
    }
}

