/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractContractNotification;
import fpml.consolidated.loan.AbstractLcEvent;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.FacilityDetailsModel;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.LetterOfCreditDetailsModel;
import fpml.consolidated.loan.meta.LcNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LcNotification", builder=LcNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LcNotification", model="fpml", builder=LcNotificationBuilderImpl.class, version="1.2.2")
public interface LcNotification
extends AbstractContractNotification {
    public static final LcNotificationMeta metaData = new LcNotificationMeta();

    public AbstractLcEvent getLcEventGroup();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public LetterOfCreditDetailsModel getLetterOfCreditDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public LcNotification build();

    @Override
    public LcNotificationBuilder toBuilder();

    public static LcNotificationBuilder builder() {
        return new LcNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends LcNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcNotification> getType() {
        return LcNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcEventGroup"), processor, AbstractLcEvent.class, this.getLcEventGroup(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LcNotificationBuilderImpl
    extends AbstractContractNotification.AbstractContractNotificationBuilderImpl
    implements LcNotificationBuilder {
        protected AbstractLcEvent.AbstractLcEventBuilder lcEventGroup;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder letterOfCreditDetailsModel;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="lcEventGroup", isRequired=true)
        @RuneAttribute(value="lcEventGroup", isRequired=true)
        public AbstractLcEvent.AbstractLcEventBuilder getLcEventGroup() {
            return this.lcEventGroup;
        }

        @Override
        public AbstractLcEvent.AbstractLcEventBuilder getOrCreateLcEventGroup() {
            AbstractLcEvent.AbstractLcEventBuilder result = this.lcEventGroup != null ? this.lcEventGroup : (this.lcEventGroup = AbstractLcEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel() {
            LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder result = this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel : (this.letterOfCreditDetailsModel = LetterOfCreditDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LcNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LcNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LcNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LcNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LcNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LcNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LcNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LcNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public LcNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public LcNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public LcNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public LcNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public LcNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public LcNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public LcNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition) {
            if (_facilityPosition != null) {
                this.facilityPosition.add(_facilityPosition.toBuilder());
            }
            return this;
        }

        @Override
        public LcNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition, int idx) {
            this.getIndex(this.facilityPosition, idx, () -> _facilityPosition.toBuilder());
            return this;
        }

        @Override
        public LcNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            if (facilityPositions != null) {
                for (FacilityPosition facilityPosition : facilityPositions) {
                    this.facilityPosition.add(facilityPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityPosition")
        public LcNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            this.facilityPosition = facilityPositions == null ? new ArrayList() : (List)facilityPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lcEventGroup", isRequired=true)
        @RuneAttribute(value="lcEventGroup", isRequired=true)
        public LcNotificationBuilder setLcEventGroup(AbstractLcEvent _lcEventGroup) {
            this.lcEventGroup = _lcEventGroup == null ? null : _lcEventGroup.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public LcNotificationBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public LcNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        public LcNotificationBuilder setLetterOfCreditDetailsModel(LetterOfCreditDetailsModel _letterOfCreditDetailsModel) {
            this.letterOfCreditDetailsModel = _letterOfCreditDetailsModel == null ? null : _letterOfCreditDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LcNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LcNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LcNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LcNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LcNotification build() {
            return new LcNotificationImpl(this);
        }

        @Override
        public LcNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LcNotificationBuilder prune() {
            super.prune();
            if (this.lcEventGroup != null && !this.lcEventGroup.prune().hasData()) {
                this.lcEventGroup = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            if (this.letterOfCreditDetailsModel != null && !this.letterOfCreditDetailsModel.prune().hasData()) {
                this.letterOfCreditDetailsModel = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLcEventGroup() != null && this.getLcEventGroup().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            if (this.getLetterOfCreditDetailsModel() != null && this.getLetterOfCreditDetailsModel().hasData()) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LcNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcNotificationBuilder o = (LcNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLcEventGroup(), (RosettaModelObjectBuilder)o.getLcEventGroup(), this::setLcEventGroup);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditDetailsModel(), (RosettaModelObjectBuilder)o.getLetterOfCreditDetailsModel(), this::setLetterOfCreditDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcNotification _that = (LcNotification)this.getType().cast(o);
            if (!Objects.equals(this.lcEventGroup, _that.getLcEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcEventGroup != null ? this.lcEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcNotificationBuilder {lcEventGroup=" + String.valueOf(this.lcEventGroup) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", letterOfCreditDetailsModel=" + String.valueOf(this.letterOfCreditDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface LcNotificationBuilder
    extends LcNotification,
    AbstractContractNotification.AbstractContractNotificationBuilder {
        public AbstractLcEvent.AbstractLcEventBuilder getOrCreateLcEventGroup();

        @Override
        public AbstractLcEvent.AbstractLcEventBuilder getLcEventGroup();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel();

        @Override
        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getLetterOfCreditDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LcNotificationBuilder setFpmlVersion(String var1);

        @Override
        public LcNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public LcNotificationBuilder setActualBuild(Integer var1);

        @Override
        public LcNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LcNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public LcNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public LcNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LcNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LcNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public LcNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public LcNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public LcNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public LcNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public LcNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        @Override
        public LcNotificationBuilder addFacilityPosition(FacilityPosition var1);

        @Override
        public LcNotificationBuilder addFacilityPosition(FacilityPosition var1, int var2);

        @Override
        public LcNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> var1);

        @Override
        public LcNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> var1);

        public LcNotificationBuilder setLcEventGroup(AbstractLcEvent var1);

        public LcNotificationBuilder setDealDetailsModel(DealDetailsModel var1);

        public LcNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public LcNotificationBuilder setLetterOfCreditDetailsModel(LetterOfCreditDetailsModel var1);

        public LcNotificationBuilder addParty(Party var1);

        public LcNotificationBuilder addParty(Party var1, int var2);

        public LcNotificationBuilder addParty(List<? extends Party> var1);

        public LcNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcEventGroup"), processor, AbstractLcEvent.AbstractLcEventBuilder.class, this.getLcEventGroup(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LcNotificationBuilder prune();
    }

    public static class LcNotificationImpl
    extends AbstractContractNotification.AbstractContractNotificationImpl
    implements LcNotification {
        private final AbstractLcEvent lcEventGroup;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final LetterOfCreditDetailsModel letterOfCreditDetailsModel;
        private final List<? extends Party> party;

        protected LcNotificationImpl(LcNotificationBuilder builder) {
            super(builder);
            this.lcEventGroup = Optional.ofNullable(builder.getLcEventGroup()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.letterOfCreditDetailsModel = Optional.ofNullable(builder.getLetterOfCreditDetailsModel()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="lcEventGroup", isRequired=true)
        @RuneAttribute(value="lcEventGroup", isRequired=true)
        public AbstractLcEvent getLcEventGroup() {
            return this.lcEventGroup;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditDetailsModel", isRequired=true)
        public LetterOfCreditDetailsModel getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LcNotification build() {
            return this;
        }

        @Override
        public LcNotificationBuilder toBuilder() {
            LcNotificationBuilder builder = LcNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLcEventGroup()).ifPresent(builder::setLcEventGroup);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getLetterOfCreditDetailsModel()).ifPresent(builder::setLetterOfCreditDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcNotification _that = (LcNotification)this.getType().cast(o);
            if (!Objects.equals(this.lcEventGroup, _that.getLcEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcEventGroup != null ? this.lcEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcNotification {lcEventGroup=" + String.valueOf(this.lcEventGroup) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", letterOfCreditDetailsModel=" + String.valueOf(this.letterOfCreditDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

