/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLcEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AccrualPeriod;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LcIssuanceFeePaymentMeta;
import fpml.consolidated.shared.PeriodModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LcIssuanceFeePayment", builder=LcIssuanceFeePaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LcIssuanceFeePayment", model="fpml", builder=LcIssuanceFeePaymentBuilderImpl.class, version="1.2.2")
public interface LcIssuanceFeePayment
extends AbstractLcEvent {
    public static final LcIssuanceFeePaymentMeta metaData = new LcIssuanceFeePaymentMeta();

    public AccrualTypeId getId();

    public PeriodModel getPeriodModel();

    public MoneyWithParticipantShare getAmount();

    public List<? extends AccrualPeriod> getAccrualSchedule();

    @Override
    public LcIssuanceFeePayment build();

    @Override
    public LcIssuanceFeePaymentBuilder toBuilder();

    public static LcIssuanceFeePaymentBuilder builder() {
        return new LcIssuanceFeePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LcIssuanceFeePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcIssuanceFeePayment> getType() {
        return LcIssuanceFeePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("id"), processor, AccrualTypeId.class, this.getId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.class, this.getAccrualSchedule(), new AttributeMeta[0]);
    }

    public static class LcIssuanceFeePaymentBuilderImpl
    extends AbstractLcEvent.AbstractLcEventBuilderImpl
    implements LcIssuanceFeePaymentBuilder {
        protected AccrualTypeId.AccrualTypeIdBuilder id;
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected List<AccrualPeriod.AccrualPeriodBuilder> accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccrualTypeId.AccrualTypeIdBuilder getId() {
            return this.id;
        }

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateId() {
            AccrualTypeId.AccrualTypeIdBuilder result = this.id != null ? this.id : (this.id = AccrualTypeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int index) {
            if (this.accrualSchedule == null) {
                this.accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
            }
            return (AccrualPeriod.AccrualPeriodBuilder)this.getIndex(this.accrualSchedule, index, () -> {
                AccrualPeriod.AccrualPeriodBuilder newAccrualSchedule = AccrualPeriod.builder();
                return newAccrualSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LcIssuanceFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LcIssuanceFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LcIssuanceFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LcIssuanceFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LcIssuanceFeePaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LcIssuanceFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LcIssuanceFeePaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LcIssuanceFeePaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LcIssuanceFeePaymentBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public LcIssuanceFeePaymentBuilder setId(AccrualTypeId _id) {
            this.id = _id == null ? null : _id.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public LcIssuanceFeePaymentBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LcIssuanceFeePaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public LcIssuanceFeePaymentBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule) {
            if (_accrualSchedule != null) {
                this.accrualSchedule.add(_accrualSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule, int idx) {
            this.getIndex(this.accrualSchedule, idx, () -> _accrualSchedule.toBuilder());
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder addAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            if (accrualSchedules != null) {
                for (AccrualPeriod accrualPeriod : accrualSchedules) {
                    this.accrualSchedule.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualSchedule")
        public LcIssuanceFeePaymentBuilder setAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            this.accrualSchedule = accrualSchedules == null ? new ArrayList<AccrualPeriod.AccrualPeriodBuilder>() : (List)accrualSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LcIssuanceFeePayment build() {
            return new LcIssuanceFeePaymentImpl(this);
        }

        @Override
        public LcIssuanceFeePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder prune() {
            super.prune();
            if (this.id != null && !this.id.prune().hasData()) {
                this.id = null;
            }
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            this.accrualSchedule = this.accrualSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getId() != null && this.getId().hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getAccrualSchedule() != null && this.getAccrualSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LcIssuanceFeePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcIssuanceFeePaymentBuilder o = (LcIssuanceFeePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getId(), (RosettaModelObjectBuilder)o.getId(), this::setId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta(this.getAccrualSchedule(), o.getAccrualSchedule(), this::getOrCreateAccrualSchedule);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcIssuanceFeePayment _that = (LcIssuanceFeePayment)this.getType().cast(o);
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcIssuanceFeePaymentBuilder {id=" + String.valueOf(this.id) + ", periodModel=" + String.valueOf(this.periodModel) + ", amount=" + String.valueOf(this.amount) + ", accrualSchedule=" + String.valueOf(this.accrualSchedule) + "} " + super.toString();
        }
    }

    public static interface LcIssuanceFeePaymentBuilder
    extends LcIssuanceFeePayment,
    AbstractLcEvent.AbstractLcEventBuilder {
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateId();

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getId();

        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int var1);

        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule();

        @Override
        public LcIssuanceFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LcIssuanceFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LcIssuanceFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcIssuanceFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcIssuanceFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LcIssuanceFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LcIssuanceFeePaymentBuilder setComment(String var1);

        @Override
        public LcIssuanceFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LcIssuanceFeePaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LcIssuanceFeePaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LcIssuanceFeePaymentBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        public LcIssuanceFeePaymentBuilder setId(AccrualTypeId var1);

        public LcIssuanceFeePaymentBuilder setPeriodModel(PeriodModel var1);

        public LcIssuanceFeePaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public LcIssuanceFeePaymentBuilder addAccrualSchedule(AccrualPeriod var1);

        public LcIssuanceFeePaymentBuilder addAccrualSchedule(AccrualPeriod var1, int var2);

        public LcIssuanceFeePaymentBuilder addAccrualSchedule(List<? extends AccrualPeriod> var1);

        public LcIssuanceFeePaymentBuilder setAccrualSchedule(List<? extends AccrualPeriod> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLetterOfCreditReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("id"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, this.getId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualSchedule(), new AttributeMeta[0]);
        }

        @Override
        public LcIssuanceFeePaymentBuilder prune();
    }

    public static class LcIssuanceFeePaymentImpl
    extends AbstractLcEvent.AbstractLcEventImpl
    implements LcIssuanceFeePayment {
        private final AccrualTypeId id;
        private final PeriodModel periodModel;
        private final MoneyWithParticipantShare amount;
        private final List<? extends AccrualPeriod> accrualSchedule;

        protected LcIssuanceFeePaymentImpl(LcIssuanceFeePaymentBuilder builder) {
            super(builder);
            this.id = Optional.ofNullable(builder.getId()).map(f -> f.build()).orElse(null);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.accrualSchedule = Optional.ofNullable(builder.getAccrualSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccrualTypeId getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public LcIssuanceFeePayment build() {
            return this;
        }

        @Override
        public LcIssuanceFeePaymentBuilder toBuilder() {
            LcIssuanceFeePaymentBuilder builder = LcIssuanceFeePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcIssuanceFeePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAccrualSchedule()).ifPresent(builder::setAccrualSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcIssuanceFeePayment _that = (LcIssuanceFeePayment)this.getType().cast(o);
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcIssuanceFeePayment {id=" + String.valueOf(this.id) + ", periodModel=" + String.valueOf(this.periodModel) + ", amount=" + String.valueOf(this.amount) + ", accrualSchedule=" + String.valueOf(this.accrualSchedule) + "} " + super.toString();
        }
    }
}

