/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLcEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FxTerms;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.LcFxRevaluationMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LcFxRevaluation", builder=LcFxRevaluationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LcFxRevaluation", model="fpml", builder=LcFxRevaluationBuilderImpl.class, version="1.2.2")
public interface LcFxRevaluation
extends AbstractLcEvent {
    public static final LcFxRevaluationMeta metaData = new LcFxRevaluationMeta();

    public FxTerms getLcFxRate();

    public FxTerms getFacilityFxRate();

    @Override
    public LcFxRevaluation build();

    @Override
    public LcFxRevaluationBuilder toBuilder();

    public static LcFxRevaluationBuilder builder() {
        return new LcFxRevaluationBuilderImpl();
    }

    default public RosettaMetaData<? extends LcFxRevaluation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcFxRevaluation> getType() {
        return LcFxRevaluation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcFxRate"), processor, FxTerms.class, this.getLcFxRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.class, this.getFacilityFxRate(), new AttributeMeta[0]);
    }

    public static class LcFxRevaluationBuilderImpl
    extends AbstractLcEvent.AbstractLcEventBuilderImpl
    implements LcFxRevaluationBuilder {
        protected FxTerms.FxTermsBuilder lcFxRate;
        protected FxTerms.FxTermsBuilder facilityFxRate;

        @Override
        @RosettaAttribute(value="lcFxRate")
        @RuneAttribute(value="lcFxRate")
        public FxTerms.FxTermsBuilder getLcFxRate() {
            return this.lcFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateLcFxRate() {
            FxTerms.FxTermsBuilder result = this.lcFxRate != null ? this.lcFxRate : (this.lcFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms.FxTermsBuilder getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate() {
            FxTerms.FxTermsBuilder result = this.facilityFxRate != null ? this.facilityFxRate : (this.facilityFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LcFxRevaluationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LcFxRevaluationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LcFxRevaluationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LcFxRevaluationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LcFxRevaluationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LcFxRevaluationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LcFxRevaluationBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LcFxRevaluationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LcFxRevaluationBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LcFxRevaluationBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LcFxRevaluationBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lcFxRate")
        @RuneAttribute(value="lcFxRate")
        public LcFxRevaluationBuilder setLcFxRate(FxTerms _lcFxRate) {
            this.lcFxRate = _lcFxRate == null ? null : _lcFxRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public LcFxRevaluationBuilder setFacilityFxRate(FxTerms _facilityFxRate) {
            this.facilityFxRate = _facilityFxRate == null ? null : _facilityFxRate.toBuilder();
            return this;
        }

        @Override
        public LcFxRevaluation build() {
            return new LcFxRevaluationImpl(this);
        }

        @Override
        public LcFxRevaluationBuilder toBuilder() {
            return this;
        }

        @Override
        public LcFxRevaluationBuilder prune() {
            super.prune();
            if (this.lcFxRate != null && !this.lcFxRate.prune().hasData()) {
                this.lcFxRate = null;
            }
            if (this.facilityFxRate != null && !this.facilityFxRate.prune().hasData()) {
                this.facilityFxRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLcFxRate() != null && this.getLcFxRate().hasData()) {
                return true;
            }
            return this.getFacilityFxRate() != null && this.getFacilityFxRate().hasData();
        }

        @Override
        public LcFxRevaluationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcFxRevaluationBuilder o = (LcFxRevaluationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLcFxRate(), (RosettaModelObjectBuilder)o.getLcFxRate(), this::setLcFxRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityFxRate(), (RosettaModelObjectBuilder)o.getFacilityFxRate(), this::setFacilityFxRate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcFxRevaluation _that = (LcFxRevaluation)this.getType().cast(o);
            if (!Objects.equals(this.lcFxRate, _that.getLcFxRate())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcFxRate != null ? this.lcFxRate.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcFxRevaluationBuilder {lcFxRate=" + String.valueOf(this.lcFxRate) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }

    public static interface LcFxRevaluationBuilder
    extends LcFxRevaluation,
    AbstractLcEvent.AbstractLcEventBuilder {
        public FxTerms.FxTermsBuilder getOrCreateLcFxRate();

        @Override
        public FxTerms.FxTermsBuilder getLcFxRate();

        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate();

        @Override
        public FxTerms.FxTermsBuilder getFacilityFxRate();

        @Override
        public LcFxRevaluationBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LcFxRevaluationBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LcFxRevaluationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcFxRevaluationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcFxRevaluationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LcFxRevaluationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LcFxRevaluationBuilder setComment(String var1);

        @Override
        public LcFxRevaluationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LcFxRevaluationBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LcFxRevaluationBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LcFxRevaluationBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        public LcFxRevaluationBuilder setLcFxRate(FxTerms var1);

        public LcFxRevaluationBuilder setFacilityFxRate(FxTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLetterOfCreditReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getLcFxRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getFacilityFxRate(), new AttributeMeta[0]);
        }

        @Override
        public LcFxRevaluationBuilder prune();
    }

    public static class LcFxRevaluationImpl
    extends AbstractLcEvent.AbstractLcEventImpl
    implements LcFxRevaluation {
        private final FxTerms lcFxRate;
        private final FxTerms facilityFxRate;

        protected LcFxRevaluationImpl(LcFxRevaluationBuilder builder) {
            super(builder);
            this.lcFxRate = Optional.ofNullable(builder.getLcFxRate()).map(f -> f.build()).orElse(null);
            this.facilityFxRate = Optional.ofNullable(builder.getFacilityFxRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="lcFxRate")
        @RuneAttribute(value="lcFxRate")
        public FxTerms getLcFxRate() {
            return this.lcFxRate;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public LcFxRevaluation build() {
            return this;
        }

        @Override
        public LcFxRevaluationBuilder toBuilder() {
            LcFxRevaluationBuilder builder = LcFxRevaluation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcFxRevaluationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLcFxRate()).ifPresent(builder::setLcFxRate);
            Optional.ofNullable(this.getFacilityFxRate()).ifPresent(builder::setFacilityFxRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcFxRevaluation _that = (LcFxRevaluation)this.getType().cast(o);
            if (!Objects.equals(this.lcFxRate, _that.getLcFxRate())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcFxRate != null ? this.lcFxRate.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcFxRevaluation {lcFxRate=" + String.valueOf(this.lcFxRate) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }
}

