/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.loan.meta.IdentifiedAssetWithPartyMeta;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IdentifiedAssetWithParty", builder=IdentifiedAssetWithPartyBuilderImpl.class, version="1.2.2")
@RuneDataType(value="IdentifiedAssetWithParty", model="fpml", builder=IdentifiedAssetWithPartyBuilderImpl.class, version="1.2.2")
public interface IdentifiedAssetWithParty
extends Asset {
    public static final IdentifiedAssetWithPartyMeta metaData = new IdentifiedAssetWithPartyMeta();

    public PartyReference getPartyReference();

    public List<? extends InstrumentId> getInstrumentId();

    public String getDescription();

    @Override
    public IdentifiedAssetWithParty build();

    @Override
    public IdentifiedAssetWithPartyBuilder toBuilder();

    public static IdentifiedAssetWithPartyBuilder builder() {
        return new IdentifiedAssetWithPartyBuilderImpl();
    }

    default public RosettaMetaData<? extends IdentifiedAssetWithParty> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IdentifiedAssetWithParty> getType() {
        return IdentifiedAssetWithParty.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class IdentifiedAssetWithPartyBuilderImpl
    extends Asset.AssetBuilderImpl
    implements IdentifiedAssetWithPartyBuilder {
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<InstrumentId.InstrumentIdBuilder> instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
        protected String description;

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int index) {
            if (this.instrumentId == null) {
                this.instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
            }
            return (InstrumentId.InstrumentIdBuilder)this.getIndex(this.instrumentId, index, () -> {
                InstrumentId.InstrumentIdBuilder newInstrumentId = InstrumentId.builder();
                return newInstrumentId;
            });
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public IdentifiedAssetWithPartyBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public IdentifiedAssetWithPartyBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public IdentifiedAssetWithPartyBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public IdentifiedAssetWithPartyBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public IdentifiedAssetWithPartyBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public IdentifiedAssetWithPartyBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList<InstrumentId.InstrumentIdBuilder>() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public IdentifiedAssetWithPartyBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        public IdentifiedAssetWithParty build() {
            return new IdentifiedAssetWithPartyImpl(this);
        }

        @Override
        public IdentifiedAssetWithPartyBuilder toBuilder() {
            return this;
        }

        @Override
        public IdentifiedAssetWithPartyBuilder prune() {
            super.prune();
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.instrumentId = this.instrumentId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getInstrumentId() != null && this.getInstrumentId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDescription() != null;
        }

        @Override
        public IdentifiedAssetWithPartyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            IdentifiedAssetWithPartyBuilder o = (IdentifiedAssetWithPartyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getInstrumentId(), o.getInstrumentId(), this::getOrCreateInstrumentId);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IdentifiedAssetWithParty _that = (IdentifiedAssetWithParty)this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IdentifiedAssetWithPartyBuilder {partyReference=" + String.valueOf(this.partyReference) + ", instrumentId=" + String.valueOf(this.instrumentId) + ", description=" + this.description + "} " + super.toString();
        }
    }

    public static interface IdentifiedAssetWithPartyBuilder
    extends IdentifiedAssetWithParty,
    Asset.AssetBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int var1);

        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId();

        @Override
        public IdentifiedAssetWithPartyBuilder setId(String var1);

        public IdentifiedAssetWithPartyBuilder setPartyReference(PartyReference var1);

        public IdentifiedAssetWithPartyBuilder addInstrumentId(InstrumentId var1);

        public IdentifiedAssetWithPartyBuilder addInstrumentId(InstrumentId var1, int var2);

        public IdentifiedAssetWithPartyBuilder addInstrumentId(List<? extends InstrumentId> var1);

        public IdentifiedAssetWithPartyBuilder setInstrumentId(List<? extends InstrumentId> var1);

        public IdentifiedAssetWithPartyBuilder setDescription(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public IdentifiedAssetWithPartyBuilder prune();
    }

    public static class IdentifiedAssetWithPartyImpl
    extends Asset.AssetImpl
    implements IdentifiedAssetWithParty {
        private final PartyReference partyReference;
        private final List<? extends InstrumentId> instrumentId;
        private final String description;

        protected IdentifiedAssetWithPartyImpl(IdentifiedAssetWithPartyBuilder builder) {
            super(builder);
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.instrumentId = Optional.ofNullable(builder.getInstrumentId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.description = builder.getDescription();
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public List<? extends InstrumentId> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public IdentifiedAssetWithParty build() {
            return this;
        }

        @Override
        public IdentifiedAssetWithPartyBuilder toBuilder() {
            IdentifiedAssetWithPartyBuilder builder = IdentifiedAssetWithParty.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IdentifiedAssetWithPartyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getInstrumentId()).ifPresent(builder::setInstrumentId);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IdentifiedAssetWithParty _that = (IdentifiedAssetWithParty)this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IdentifiedAssetWithParty {partyReference=" + String.valueOf(this.partyReference) + ", instrumentId=" + String.valueOf(this.instrumentId) + ", description=" + this.description + "} " + super.toString();
        }
    }
}

