/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.EventPaymentSequence;
import fpml.consolidated.loan.LoanSimplePayment;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.meta.EventPaymentMeta;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.SettlementInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EventPayment", builder=EventPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EventPayment", model="fpml", builder=EventPaymentBuilderImpl.class, version="1.2.2")
public interface EventPayment
extends LoanSimplePayment {
    public static final EventPaymentMeta metaData = new EventPaymentMeta();

    public List<? extends EventPaymentSequence> getEventPaymentSequence();

    public SettlementInstruction getSettlementInstruction();

    @Override
    public EventPayment build();

    @Override
    public EventPaymentBuilder toBuilder();

    public static EventPaymentBuilder builder() {
        return new EventPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends EventPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EventPayment> getType() {
        return EventPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPaymentSequence"), processor, EventPaymentSequence.class, this.getEventPaymentSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInstruction"), processor, SettlementInstruction.class, this.getSettlementInstruction(), new AttributeMeta[0]);
    }

    public static class EventPaymentBuilderImpl
    extends LoanSimplePayment.LoanSimplePaymentBuilderImpl
    implements EventPaymentBuilder {
        protected List<EventPaymentSequence.EventPaymentSequenceBuilder> eventPaymentSequence = new ArrayList<EventPaymentSequence.EventPaymentSequenceBuilder>();
        protected SettlementInstruction.SettlementInstructionBuilder settlementInstruction;

        @Override
        @RosettaAttribute(value="eventPaymentSequence", isRequired=true)
        @RuneAttribute(value="eventPaymentSequence", isRequired=true)
        public List<? extends EventPaymentSequence.EventPaymentSequenceBuilder> getEventPaymentSequence() {
            return this.eventPaymentSequence;
        }

        @Override
        public EventPaymentSequence.EventPaymentSequenceBuilder getOrCreateEventPaymentSequence(int index) {
            if (this.eventPaymentSequence == null) {
                this.eventPaymentSequence = new ArrayList<EventPaymentSequence.EventPaymentSequenceBuilder>();
            }
            return (EventPaymentSequence.EventPaymentSequenceBuilder)this.getIndex(this.eventPaymentSequence, index, () -> {
                EventPaymentSequence.EventPaymentSequenceBuilder newEventPaymentSequence = EventPaymentSequence.builder();
                return newEventPaymentSequence;
            });
        }

        @Override
        @RosettaAttribute(value="settlementInstruction")
        @RuneAttribute(value="settlementInstruction")
        public SettlementInstruction.SettlementInstructionBuilder getSettlementInstruction() {
            return this.settlementInstruction;
        }

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getOrCreateSettlementInstruction() {
            SettlementInstruction.SettlementInstructionBuilder result = this.settlementInstruction != null ? this.settlementInstruction : (this.settlementInstruction = SettlementInstruction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EventPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public EventPaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public EventPaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public EventPaymentBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPaymentSequence", isRequired=true)
        @RuneAttribute(value="eventPaymentSequence", isRequired=true)
        public EventPaymentBuilder addEventPaymentSequence(EventPaymentSequence _eventPaymentSequence) {
            if (_eventPaymentSequence != null) {
                this.eventPaymentSequence.add(_eventPaymentSequence.toBuilder());
            }
            return this;
        }

        @Override
        public EventPaymentBuilder addEventPaymentSequence(EventPaymentSequence _eventPaymentSequence, int idx) {
            this.getIndex(this.eventPaymentSequence, idx, () -> _eventPaymentSequence.toBuilder());
            return this;
        }

        @Override
        public EventPaymentBuilder addEventPaymentSequence(List<? extends EventPaymentSequence> eventPaymentSequences) {
            if (eventPaymentSequences != null) {
                for (EventPaymentSequence eventPaymentSequence : eventPaymentSequences) {
                    this.eventPaymentSequence.add(eventPaymentSequence.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPaymentSequence")
        public EventPaymentBuilder setEventPaymentSequence(List<? extends EventPaymentSequence> eventPaymentSequences) {
            this.eventPaymentSequence = eventPaymentSequences == null ? new ArrayList<EventPaymentSequence.EventPaymentSequenceBuilder>() : (List)eventPaymentSequences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInstruction")
        @RuneAttribute(value="settlementInstruction")
        public EventPaymentBuilder setSettlementInstruction(SettlementInstruction _settlementInstruction) {
            this.settlementInstruction = _settlementInstruction == null ? null : _settlementInstruction.toBuilder();
            return this;
        }

        @Override
        public EventPayment build() {
            return new EventPaymentImpl(this);
        }

        @Override
        public EventPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public EventPaymentBuilder prune() {
            super.prune();
            this.eventPaymentSequence = this.eventPaymentSequence.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementInstruction != null && !this.settlementInstruction.prune().hasData()) {
                this.settlementInstruction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEventPaymentSequence() != null && this.getEventPaymentSequence().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSettlementInstruction() != null && this.getSettlementInstruction().hasData();
        }

        @Override
        public EventPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EventPaymentBuilder o = (EventPaymentBuilder)other;
            merger.mergeRosetta(this.getEventPaymentSequence(), o.getEventPaymentSequence(), this::getOrCreateEventPaymentSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInstruction(), (RosettaModelObjectBuilder)o.getSettlementInstruction(), this::setSettlementInstruction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EventPayment _that = (EventPayment)this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventPaymentSequence, _that.getEventPaymentSequence())) {
                return false;
            }
            return Objects.equals(this.settlementInstruction, _that.getSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventPaymentSequence != null ? this.eventPaymentSequence.hashCode() : 0);
            _result = 31 * _result + (this.settlementInstruction != null ? this.settlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EventPaymentBuilder {eventPaymentSequence=" + String.valueOf(this.eventPaymentSequence) + ", settlementInstruction=" + String.valueOf(this.settlementInstruction) + "} " + super.toString();
        }
    }

    public static interface EventPaymentBuilder
    extends EventPayment,
    LoanSimplePayment.LoanSimplePaymentBuilder {
        public EventPaymentSequence.EventPaymentSequenceBuilder getOrCreateEventPaymentSequence(int var1);

        public List<? extends EventPaymentSequence.EventPaymentSequenceBuilder> getEventPaymentSequence();

        public SettlementInstruction.SettlementInstructionBuilder getOrCreateSettlementInstruction();

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getSettlementInstruction();

        @Override
        public EventPaymentBuilder setId(String var1);

        @Override
        public EventPaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        @Override
        public EventPaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        @Override
        public EventPaymentBuilder setPaymentDate(AdjustableDate var1);

        public EventPaymentBuilder addEventPaymentSequence(EventPaymentSequence var1);

        public EventPaymentBuilder addEventPaymentSequence(EventPaymentSequence var1, int var2);

        public EventPaymentBuilder addEventPaymentSequence(List<? extends EventPaymentSequence> var1);

        public EventPaymentBuilder setEventPaymentSequence(List<? extends EventPaymentSequence> var1);

        public EventPaymentBuilder setSettlementInstruction(SettlementInstruction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPaymentSequence"), processor, EventPaymentSequence.EventPaymentSequenceBuilder.class, this.getEventPaymentSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInstruction"), processor, SettlementInstruction.SettlementInstructionBuilder.class, this.getSettlementInstruction(), new AttributeMeta[0]);
        }

        @Override
        public EventPaymentBuilder prune();
    }

    public static class EventPaymentImpl
    extends LoanSimplePayment.LoanSimplePaymentImpl
    implements EventPayment {
        private final List<? extends EventPaymentSequence> eventPaymentSequence;
        private final SettlementInstruction settlementInstruction;

        protected EventPaymentImpl(EventPaymentBuilder builder) {
            super(builder);
            this.eventPaymentSequence = Optional.ofNullable(builder.getEventPaymentSequence()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementInstruction = Optional.ofNullable(builder.getSettlementInstruction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventPaymentSequence", isRequired=true)
        @RuneAttribute(value="eventPaymentSequence", isRequired=true)
        public List<? extends EventPaymentSequence> getEventPaymentSequence() {
            return this.eventPaymentSequence;
        }

        @Override
        @RosettaAttribute(value="settlementInstruction")
        @RuneAttribute(value="settlementInstruction")
        public SettlementInstruction getSettlementInstruction() {
            return this.settlementInstruction;
        }

        @Override
        public EventPayment build() {
            return this;
        }

        @Override
        public EventPaymentBuilder toBuilder() {
            EventPaymentBuilder builder = EventPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EventPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEventPaymentSequence()).ifPresent(builder::setEventPaymentSequence);
            Optional.ofNullable(this.getSettlementInstruction()).ifPresent(builder::setSettlementInstruction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EventPayment _that = (EventPayment)this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventPaymentSequence, _that.getEventPaymentSequence())) {
                return false;
            }
            return Objects.equals(this.settlementInstruction, _that.getSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventPaymentSequence != null ? this.eventPaymentSequence.hashCode() : 0);
            _result = 31 * _result + (this.settlementInstruction != null ? this.settlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EventPayment {eventPaymentSequence=" + String.valueOf(this.eventPaymentSequence) + ", settlementInstruction=" + String.valueOf(this.settlementInstruction) + "} " + super.toString();
        }
    }
}

