/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.DealIdentifier;
import fpml.consolidated.loan.DealRolesModel;
import fpml.consolidated.loan.DealSummarySequence;
import fpml.consolidated.loan.meta.DealSummaryMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DealSummary", builder=DealSummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="DealSummary", model="fpml", builder=DealSummaryBuilderImpl.class, version="1.2.2")
public interface DealSummary
extends DealIdentifier {
    public static final DealSummaryMeta metaData = new DealSummaryMeta();

    public DealRolesModel getDealRolesModel();

    public ZonedDateTime getCreditAgreementDate();

    public Currency getCurrency();

    public DealSummarySequence getDealSummarySequence();

    @Override
    public DealSummary build();

    @Override
    public DealSummaryBuilder toBuilder();

    public static DealSummaryBuilder builder() {
        return new DealSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends DealSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DealSummary> getType() {
        return DealSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealRolesModel"), processor, DealRolesModel.class, this.getDealRolesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealSummarySequence"), processor, DealSummarySequence.class, this.getDealSummarySequence(), new AttributeMeta[0]);
    }

    public static class DealSummaryBuilderImpl
    extends DealIdentifier.DealIdentifierBuilderImpl
    implements DealSummaryBuilder {
        protected DealRolesModel.DealRolesModelBuilder dealRolesModel;
        protected ZonedDateTime creditAgreementDate;
        protected Currency.CurrencyBuilder currency;
        protected DealSummarySequence.DealSummarySequenceBuilder dealSummarySequence;

        @Override
        @RosettaAttribute(value="dealRolesModel", isRequired=true)
        @RuneAttribute(value="dealRolesModel", isRequired=true)
        public DealRolesModel.DealRolesModelBuilder getDealRolesModel() {
            return this.dealRolesModel;
        }

        @Override
        public DealRolesModel.DealRolesModelBuilder getOrCreateDealRolesModel() {
            DealRolesModel.DealRolesModelBuilder result = this.dealRolesModel != null ? this.dealRolesModel : (this.dealRolesModel = DealRolesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate", isRequired=true)
        @RuneAttribute(value="creditAgreementDate", isRequired=true)
        public ZonedDateTime getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealSummarySequence")
        @RuneAttribute(value="dealSummarySequence")
        public DealSummarySequence.DealSummarySequenceBuilder getDealSummarySequence() {
            return this.dealSummarySequence;
        }

        @Override
        public DealSummarySequence.DealSummarySequenceBuilder getOrCreateDealSummarySequence() {
            DealSummarySequence.DealSummarySequenceBuilder result = this.dealSummarySequence != null ? this.dealSummarySequence : (this.dealSummarySequence = DealSummarySequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DealSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public DealSummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public DealSummaryBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public DealSummaryBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public DealSummaryBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public DealSummaryBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public DealSummaryBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealRolesModel", isRequired=true)
        @RuneAttribute(value="dealRolesModel", isRequired=true)
        public DealSummaryBuilder setDealRolesModel(DealRolesModel _dealRolesModel) {
            this.dealRolesModel = _dealRolesModel == null ? null : _dealRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate", isRequired=true)
        @RuneAttribute(value="creditAgreementDate", isRequired=true)
        public DealSummaryBuilder setCreditAgreementDate(ZonedDateTime _creditAgreementDate) {
            this.creditAgreementDate = _creditAgreementDate == null ? null : _creditAgreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public DealSummaryBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealSummarySequence")
        @RuneAttribute(value="dealSummarySequence")
        public DealSummaryBuilder setDealSummarySequence(DealSummarySequence _dealSummarySequence) {
            this.dealSummarySequence = _dealSummarySequence == null ? null : _dealSummarySequence.toBuilder();
            return this;
        }

        @Override
        public DealSummary build() {
            return new DealSummaryImpl(this);
        }

        @Override
        public DealSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public DealSummaryBuilder prune() {
            super.prune();
            if (this.dealRolesModel != null && !this.dealRolesModel.prune().hasData()) {
                this.dealRolesModel = null;
            }
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.dealSummarySequence != null && !this.dealSummarySequence.prune().hasData()) {
                this.dealSummarySequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDealRolesModel() != null && this.getDealRolesModel().hasData()) {
                return true;
            }
            if (this.getCreditAgreementDate() != null) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            return this.getDealSummarySequence() != null && this.getDealSummarySequence().hasData();
        }

        @Override
        public DealSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DealSummaryBuilder o = (DealSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealRolesModel(), (RosettaModelObjectBuilder)o.getDealRolesModel(), this::setDealRolesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealSummarySequence(), (RosettaModelObjectBuilder)o.getDealSummarySequence(), this::setDealSummarySequence);
            merger.mergeBasic((Object)this.getCreditAgreementDate(), (Object)o.getCreditAgreementDate(), this::setCreditAgreementDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DealSummary _that = (DealSummary)this.getType().cast(o);
            if (!Objects.equals(this.dealRolesModel, _that.getDealRolesModel())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.dealSummarySequence, _that.getDealSummarySequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealRolesModel != null ? this.dealRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.dealSummarySequence != null ? this.dealSummarySequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DealSummaryBuilder {dealRolesModel=" + String.valueOf(this.dealRolesModel) + ", creditAgreementDate=" + String.valueOf(this.creditAgreementDate) + ", currency=" + String.valueOf(this.currency) + ", dealSummarySequence=" + String.valueOf(this.dealSummarySequence) + "} " + super.toString();
        }
    }

    public static interface DealSummaryBuilder
    extends DealSummary,
    DealIdentifier.DealIdentifierBuilder {
        public DealRolesModel.DealRolesModelBuilder getOrCreateDealRolesModel();

        @Override
        public DealRolesModel.DealRolesModelBuilder getDealRolesModel();

        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public DealSummarySequence.DealSummarySequenceBuilder getOrCreateDealSummarySequence();

        @Override
        public DealSummarySequence.DealSummarySequenceBuilder getDealSummarySequence();

        @Override
        public DealSummaryBuilder setId(String var1);

        @Override
        public DealSummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public DealSummaryBuilder addInstrumentId(InstrumentId var1);

        @Override
        public DealSummaryBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public DealSummaryBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DealSummaryBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DealSummaryBuilder setDescription(String var1);

        public DealSummaryBuilder setDealRolesModel(DealRolesModel var1);

        public DealSummaryBuilder setCreditAgreementDate(ZonedDateTime var1);

        public DealSummaryBuilder setCurrency(Currency var1);

        public DealSummaryBuilder setDealSummarySequence(DealSummarySequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealRolesModel"), processor, DealRolesModel.DealRolesModelBuilder.class, this.getDealRolesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealSummarySequence"), processor, DealSummarySequence.DealSummarySequenceBuilder.class, this.getDealSummarySequence(), new AttributeMeta[0]);
        }

        @Override
        public DealSummaryBuilder prune();
    }

    public static class DealSummaryImpl
    extends DealIdentifier.DealIdentifierImpl
    implements DealSummary {
        private final DealRolesModel dealRolesModel;
        private final ZonedDateTime creditAgreementDate;
        private final Currency currency;
        private final DealSummarySequence dealSummarySequence;

        protected DealSummaryImpl(DealSummaryBuilder builder) {
            super(builder);
            this.dealRolesModel = Optional.ofNullable(builder.getDealRolesModel()).map(f -> f.build()).orElse(null);
            this.creditAgreementDate = builder.getCreditAgreementDate();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.dealSummarySequence = Optional.ofNullable(builder.getDealSummarySequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealRolesModel", isRequired=true)
        @RuneAttribute(value="dealRolesModel", isRequired=true)
        public DealRolesModel getDealRolesModel() {
            return this.dealRolesModel;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate", isRequired=true)
        @RuneAttribute(value="creditAgreementDate", isRequired=true)
        public ZonedDateTime getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="dealSummarySequence")
        @RuneAttribute(value="dealSummarySequence")
        public DealSummarySequence getDealSummarySequence() {
            return this.dealSummarySequence;
        }

        @Override
        public DealSummary build() {
            return this;
        }

        @Override
        public DealSummaryBuilder toBuilder() {
            DealSummaryBuilder builder = DealSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DealSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDealRolesModel()).ifPresent(builder::setDealRolesModel);
            Optional.ofNullable(this.getCreditAgreementDate()).ifPresent(builder::setCreditAgreementDate);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getDealSummarySequence()).ifPresent(builder::setDealSummarySequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DealSummary _that = (DealSummary)this.getType().cast(o);
            if (!Objects.equals(this.dealRolesModel, _that.getDealRolesModel())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.dealSummarySequence, _that.getDealSummarySequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealRolesModel != null ? this.dealRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.dealSummarySequence != null ? this.dealSummarySequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DealSummary {dealRolesModel=" + String.valueOf(this.dealRolesModel) + ", creditAgreementDate=" + String.valueOf(this.creditAgreementDate) + ", currency=" + String.valueOf(this.currency) + ", dealSummarySequence=" + String.valueOf(this.dealSummarySequence) + "} " + super.toString();
        }
    }
}

