/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.CovenantObligationId;
import fpml.consolidated.loan.CovenantObligationIdentifier;
import fpml.consolidated.loan.VersionedCovenantObligationId;
import fpml.consolidated.loan.meta.CovenantObligationSummaryMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CovenantObligationSummary", builder=CovenantObligationSummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CovenantObligationSummary", model="fpml", builder=CovenantObligationSummaryBuilderImpl.class, version="1.2.2")
public interface CovenantObligationSummary
extends CovenantObligationIdentifier {
    public static final CovenantObligationSummaryMeta metaData = new CovenantObligationSummaryMeta();

    public ZonedDateTime getEffectiveDate();

    public PartyReference getObligatedParty();

    @Override
    public CovenantObligationSummary build();

    @Override
    public CovenantObligationSummaryBuilder toBuilder();

    public static CovenantObligationSummaryBuilder builder() {
        return new CovenantObligationSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends CovenantObligationSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CovenantObligationSummary> getType() {
        return CovenantObligationSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.class, this.getCovenantObligationId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.class, this.getObligatedParty(), new AttributeMeta[0]);
    }

    public static class CovenantObligationSummaryBuilderImpl
    extends CovenantObligationIdentifier.CovenantObligationIdentifierBuilderImpl
    implements CovenantObligationSummaryBuilder {
        protected ZonedDateTime effectiveDate;
        protected PartyReference.PartyReferenceBuilder obligatedParty;

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public PartyReference.PartyReferenceBuilder getObligatedParty() {
            return this.obligatedParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateObligatedParty() {
            PartyReference.PartyReferenceBuilder result = this.obligatedParty != null ? this.obligatedParty : (this.obligatedParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public CovenantObligationSummaryBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public CovenantObligationSummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public CovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId) {
            if (_covenantObligationId != null) {
                this.covenantObligationId.add(_covenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId, int idx) {
            this.getIndex(this.covenantObligationId, idx, () -> _covenantObligationId.toBuilder());
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder addCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            if (covenantObligationIds != null) {
                for (CovenantObligationId covenantObligationId : covenantObligationIds) {
                    this.covenantObligationId.add(covenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationId")
        public CovenantObligationSummaryBuilder setCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            this.covenantObligationId = covenantObligationIds == null ? new ArrayList() : (List)covenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId) {
            if (_versionedCovenantObligationId != null) {
                this.versionedCovenantObligationId.add(_versionedCovenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId, int idx) {
            this.getIndex(this.versionedCovenantObligationId, idx, () -> _versionedCovenantObligationId.toBuilder());
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            if (versionedCovenantObligationIds != null) {
                for (VersionedCovenantObligationId versionedCovenantObligationId : versionedCovenantObligationIds) {
                    this.versionedCovenantObligationId.add(versionedCovenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedCovenantObligationId")
        public CovenantObligationSummaryBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            this.versionedCovenantObligationId = versionedCovenantObligationIds == null ? new ArrayList() : (List)versionedCovenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CovenantObligationSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public CovenantObligationSummaryBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public CovenantObligationSummaryBuilder setObligatedParty(PartyReference _obligatedParty) {
            this.obligatedParty = _obligatedParty == null ? null : _obligatedParty.toBuilder();
            return this;
        }

        @Override
        public CovenantObligationSummary build() {
            return new CovenantObligationSummaryImpl(this);
        }

        @Override
        public CovenantObligationSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder prune() {
            super.prune();
            if (this.obligatedParty != null && !this.obligatedParty.prune().hasData()) {
                this.obligatedParty = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getObligatedParty() != null && this.getObligatedParty().hasData();
        }

        @Override
        public CovenantObligationSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CovenantObligationSummaryBuilder o = (CovenantObligationSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObligatedParty(), (RosettaModelObjectBuilder)o.getObligatedParty(), this::setObligatedParty);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CovenantObligationSummary _that = (CovenantObligationSummary)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.obligatedParty, _that.getObligatedParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.obligatedParty != null ? this.obligatedParty.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CovenantObligationSummaryBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", obligatedParty=" + String.valueOf(this.obligatedParty) + "} " + super.toString();
        }
    }

    public static interface CovenantObligationSummaryBuilder
    extends CovenantObligationSummary,
    CovenantObligationIdentifier.CovenantObligationIdentifierBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateObligatedParty();

        @Override
        public PartyReference.PartyReferenceBuilder getObligatedParty();

        @Override
        public CovenantObligationSummaryBuilder setName(String var1);

        @Override
        public CovenantObligationSummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public CovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId var1);

        @Override
        public CovenantObligationSummaryBuilder addCovenantObligationId(CovenantObligationId var1, int var2);

        @Override
        public CovenantObligationSummaryBuilder addCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public CovenantObligationSummaryBuilder setCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1);

        @Override
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1, int var2);

        @Override
        public CovenantObligationSummaryBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public CovenantObligationSummaryBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public CovenantObligationSummaryBuilder setId(String var1);

        public CovenantObligationSummaryBuilder setEffectiveDate(ZonedDateTime var1);

        public CovenantObligationSummaryBuilder setObligatedParty(PartyReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.CovenantObligationIdBuilder.class, this.getCovenantObligationId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getObligatedParty(), new AttributeMeta[0]);
        }

        @Override
        public CovenantObligationSummaryBuilder prune();
    }

    public static class CovenantObligationSummaryImpl
    extends CovenantObligationIdentifier.CovenantObligationIdentifierImpl
    implements CovenantObligationSummary {
        private final ZonedDateTime effectiveDate;
        private final PartyReference obligatedParty;

        protected CovenantObligationSummaryImpl(CovenantObligationSummaryBuilder builder) {
            super(builder);
            this.effectiveDate = builder.getEffectiveDate();
            this.obligatedParty = Optional.ofNullable(builder.getObligatedParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public PartyReference getObligatedParty() {
            return this.obligatedParty;
        }

        @Override
        public CovenantObligationSummary build() {
            return this;
        }

        @Override
        public CovenantObligationSummaryBuilder toBuilder() {
            CovenantObligationSummaryBuilder builder = CovenantObligationSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CovenantObligationSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getObligatedParty()).ifPresent(builder::setObligatedParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CovenantObligationSummary _that = (CovenantObligationSummary)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.obligatedParty, _that.getObligatedParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.obligatedParty != null ? this.obligatedParty.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CovenantObligationSummary {effectiveDate=" + String.valueOf(this.effectiveDate) + ", obligatedParty=" + String.valueOf(this.obligatedParty) + "} " + super.toString();
        }
    }
}

