/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.CovenantObligationId;
import fpml.consolidated.loan.VersionedCovenantObligationId;
import fpml.consolidated.loan.meta.CovenantObligationIdentifierMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CovenantObligationIdentifier", builder=CovenantObligationIdentifierBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CovenantObligationIdentifier", model="fpml", builder=CovenantObligationIdentifierBuilderImpl.class, version="1.2.2")
public interface CovenantObligationIdentifier
extends RosettaModelObject {
    public static final CovenantObligationIdentifierMeta metaData = new CovenantObligationIdentifierMeta();

    public String getName();

    public PartyReference getPartyReference();

    public List<? extends CovenantObligationId> getCovenantObligationId();

    public List<? extends VersionedCovenantObligationId> getVersionedCovenantObligationId();

    public String getId();

    public CovenantObligationIdentifier build();

    public CovenantObligationIdentifierBuilder toBuilder();

    public static CovenantObligationIdentifierBuilder builder() {
        return new CovenantObligationIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends CovenantObligationIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CovenantObligationIdentifier> getType() {
        return CovenantObligationIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.class, this.getCovenantObligationId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CovenantObligationIdentifierBuilderImpl
    implements CovenantObligationIdentifierBuilder {
        protected String name;
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<CovenantObligationId.CovenantObligationIdBuilder> covenantObligationId = new ArrayList<CovenantObligationId.CovenantObligationIdBuilder>();
        protected List<VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder> versionedCovenantObligationId = new ArrayList<VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public List<? extends CovenantObligationId.CovenantObligationIdBuilder> getCovenantObligationId() {
            return this.covenantObligationId;
        }

        @Override
        public CovenantObligationId.CovenantObligationIdBuilder getOrCreateCovenantObligationId(int index) {
            if (this.covenantObligationId == null) {
                this.covenantObligationId = new ArrayList<CovenantObligationId.CovenantObligationIdBuilder>();
            }
            return (CovenantObligationId.CovenantObligationIdBuilder)this.getIndex(this.covenantObligationId, index, () -> {
                CovenantObligationId.CovenantObligationIdBuilder newCovenantObligationId = CovenantObligationId.builder();
                return newCovenantObligationId;
            });
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public List<? extends VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder> getVersionedCovenantObligationId() {
            return this.versionedCovenantObligationId;
        }

        @Override
        public VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder getOrCreateVersionedCovenantObligationId(int index) {
            if (this.versionedCovenantObligationId == null) {
                this.versionedCovenantObligationId = new ArrayList<VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder>();
            }
            return (VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder)this.getIndex(this.versionedCovenantObligationId, index, () -> {
                VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder newVersionedCovenantObligationId = VersionedCovenantObligationId.builder();
                return newVersionedCovenantObligationId;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public CovenantObligationIdentifierBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public CovenantObligationIdentifierBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public CovenantObligationIdentifierBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId) {
            if (_covenantObligationId != null) {
                this.covenantObligationId.add(_covenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId, int idx) {
            this.getIndex(this.covenantObligationId, idx, () -> _covenantObligationId.toBuilder());
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder addCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            if (covenantObligationIds != null) {
                for (CovenantObligationId covenantObligationId : covenantObligationIds) {
                    this.covenantObligationId.add(covenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationId")
        public CovenantObligationIdentifierBuilder setCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            this.covenantObligationId = covenantObligationIds == null ? new ArrayList<CovenantObligationId.CovenantObligationIdBuilder>() : (List)covenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId) {
            if (_versionedCovenantObligationId != null) {
                this.versionedCovenantObligationId.add(_versionedCovenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId, int idx) {
            this.getIndex(this.versionedCovenantObligationId, idx, () -> _versionedCovenantObligationId.toBuilder());
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            if (versionedCovenantObligationIds != null) {
                for (VersionedCovenantObligationId versionedCovenantObligationId : versionedCovenantObligationIds) {
                    this.versionedCovenantObligationId.add(versionedCovenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedCovenantObligationId")
        public CovenantObligationIdentifierBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            this.versionedCovenantObligationId = versionedCovenantObligationIds == null ? new ArrayList<VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder>() : (List)versionedCovenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CovenantObligationIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CovenantObligationIdentifier build() {
            return new CovenantObligationIdentifierImpl(this);
        }

        @Override
        public CovenantObligationIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.covenantObligationId = this.covenantObligationId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.versionedCovenantObligationId = this.versionedCovenantObligationId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getCovenantObligationId() != null && this.getCovenantObligationId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getVersionedCovenantObligationId() != null && this.getVersionedCovenantObligationId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public CovenantObligationIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CovenantObligationIdentifierBuilder o = (CovenantObligationIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getCovenantObligationId(), o.getCovenantObligationId(), this::getOrCreateCovenantObligationId);
            merger.mergeRosetta(this.getVersionedCovenantObligationId(), o.getVersionedCovenantObligationId(), this::getOrCreateVersionedCovenantObligationId);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CovenantObligationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenantObligationId, _that.getCovenantObligationId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedCovenantObligationId, _that.getVersionedCovenantObligationId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.covenantObligationId != null ? this.covenantObligationId.hashCode() : 0);
            _result = 31 * _result + (this.versionedCovenantObligationId != null ? this.versionedCovenantObligationId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CovenantObligationIdentifierBuilder {name=" + this.name + ", partyReference=" + String.valueOf(this.partyReference) + ", covenantObligationId=" + String.valueOf(this.covenantObligationId) + ", versionedCovenantObligationId=" + String.valueOf(this.versionedCovenantObligationId) + ", id=" + this.id + "}";
        }
    }

    public static interface CovenantObligationIdentifierBuilder
    extends CovenantObligationIdentifier,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public CovenantObligationId.CovenantObligationIdBuilder getOrCreateCovenantObligationId(int var1);

        public List<? extends CovenantObligationId.CovenantObligationIdBuilder> getCovenantObligationId();

        public VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder getOrCreateVersionedCovenantObligationId(int var1);

        public List<? extends VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder> getVersionedCovenantObligationId();

        public CovenantObligationIdentifierBuilder setName(String var1);

        public CovenantObligationIdentifierBuilder setPartyReference(PartyReference var1);

        public CovenantObligationIdentifierBuilder addCovenantObligationId(CovenantObligationId var1);

        public CovenantObligationIdentifierBuilder addCovenantObligationId(CovenantObligationId var1, int var2);

        public CovenantObligationIdentifierBuilder addCovenantObligationId(List<? extends CovenantObligationId> var1);

        public CovenantObligationIdentifierBuilder setCovenantObligationId(List<? extends CovenantObligationId> var1);

        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1);

        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1, int var2);

        public CovenantObligationIdentifierBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        public CovenantObligationIdentifierBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        public CovenantObligationIdentifierBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.CovenantObligationIdBuilder.class, this.getCovenantObligationId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CovenantObligationIdentifierBuilder prune();
    }

    public static class CovenantObligationIdentifierImpl
    implements CovenantObligationIdentifier {
        private final String name;
        private final PartyReference partyReference;
        private final List<? extends CovenantObligationId> covenantObligationId;
        private final List<? extends VersionedCovenantObligationId> versionedCovenantObligationId;
        private final String id;

        protected CovenantObligationIdentifierImpl(CovenantObligationIdentifierBuilder builder) {
            this.name = builder.getName();
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.covenantObligationId = Optional.ofNullable(builder.getCovenantObligationId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.versionedCovenantObligationId = Optional.ofNullable(builder.getVersionedCovenantObligationId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public List<? extends CovenantObligationId> getCovenantObligationId() {
            return this.covenantObligationId;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public List<? extends VersionedCovenantObligationId> getVersionedCovenantObligationId() {
            return this.versionedCovenantObligationId;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CovenantObligationIdentifier build() {
            return this;
        }

        @Override
        public CovenantObligationIdentifierBuilder toBuilder() {
            CovenantObligationIdentifierBuilder builder = CovenantObligationIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CovenantObligationIdentifierBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getCovenantObligationId()).ifPresent(builder::setCovenantObligationId);
            Optional.ofNullable(this.getVersionedCovenantObligationId()).ifPresent(builder::setVersionedCovenantObligationId);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CovenantObligationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenantObligationId, _that.getCovenantObligationId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.versionedCovenantObligationId, _that.getVersionedCovenantObligationId())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.covenantObligationId != null ? this.covenantObligationId.hashCode() : 0);
            _result = 31 * _result + (this.versionedCovenantObligationId != null ? this.versionedCovenantObligationId.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CovenantObligationIdentifier {name=" + this.name + ", partyReference=" + String.valueOf(this.partyReference) + ", covenantObligationId=" + String.valueOf(this.covenantObligationId) + ", versionedCovenantObligationId=" + String.valueOf(this.versionedCovenantObligationId) + ", id=" + this.id + "}";
        }
    }
}

