/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.FacilityType;
import fpml.consolidated.loan.DealIdentifier;
import fpml.consolidated.loan.FacilityIdentifier;
import fpml.consolidated.loan.meta.ApplicableAssetsChoiceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ApplicableAssetsChoice", builder=ApplicableAssetsChoiceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ApplicableAssetsChoice", model="fpml", builder=ApplicableAssetsChoiceBuilderImpl.class, version="1.2.2")
public interface ApplicableAssetsChoice
extends RosettaModelObject {
    public static final ApplicableAssetsChoiceMeta metaData = new ApplicableAssetsChoiceMeta();

    public List<? extends DealIdentifier> getDealIdentifier();

    public List<? extends FacilityIdentifier> getFacilityIdentifier();

    public List<? extends FacilityType> getFacilityType();

    public ApplicableAssetsChoice build();

    public ApplicableAssetsChoiceBuilder toBuilder();

    public static ApplicableAssetsChoiceBuilder builder() {
        return new ApplicableAssetsChoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends ApplicableAssetsChoice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ApplicableAssetsChoice> getType() {
        return ApplicableAssetsChoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dealIdentifier"), processor, DealIdentifier.class, this.getDealIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityIdentifier"), processor, FacilityIdentifier.class, this.getFacilityIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityType"), processor, FacilityType.class, this.getFacilityType(), new AttributeMeta[0]);
    }

    public static class ApplicableAssetsChoiceBuilderImpl
    implements ApplicableAssetsChoiceBuilder {
        protected List<DealIdentifier.DealIdentifierBuilder> dealIdentifier = new ArrayList<DealIdentifier.DealIdentifierBuilder>();
        protected List<FacilityIdentifier.FacilityIdentifierBuilder> facilityIdentifier = new ArrayList<FacilityIdentifier.FacilityIdentifierBuilder>();
        protected List<FacilityType.FacilityTypeBuilder> facilityType = new ArrayList<FacilityType.FacilityTypeBuilder>();

        @Override
        @RosettaAttribute(value="dealIdentifier")
        @RuneAttribute(value="dealIdentifier")
        public List<? extends DealIdentifier.DealIdentifierBuilder> getDealIdentifier() {
            return this.dealIdentifier;
        }

        @Override
        public DealIdentifier.DealIdentifierBuilder getOrCreateDealIdentifier(int index) {
            if (this.dealIdentifier == null) {
                this.dealIdentifier = new ArrayList<DealIdentifier.DealIdentifierBuilder>();
            }
            return (DealIdentifier.DealIdentifierBuilder)this.getIndex(this.dealIdentifier, index, () -> {
                DealIdentifier.DealIdentifierBuilder newDealIdentifier = DealIdentifier.builder();
                return newDealIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier")
        @RuneAttribute(value="facilityIdentifier")
        public List<? extends FacilityIdentifier.FacilityIdentifierBuilder> getFacilityIdentifier() {
            return this.facilityIdentifier;
        }

        @Override
        public FacilityIdentifier.FacilityIdentifierBuilder getOrCreateFacilityIdentifier(int index) {
            if (this.facilityIdentifier == null) {
                this.facilityIdentifier = new ArrayList<FacilityIdentifier.FacilityIdentifierBuilder>();
            }
            return (FacilityIdentifier.FacilityIdentifierBuilder)this.getIndex(this.facilityIdentifier, index, () -> {
                FacilityIdentifier.FacilityIdentifierBuilder newFacilityIdentifier = FacilityIdentifier.builder();
                return newFacilityIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public List<? extends FacilityType.FacilityTypeBuilder> getFacilityType() {
            return this.facilityType;
        }

        @Override
        public FacilityType.FacilityTypeBuilder getOrCreateFacilityType(int index) {
            if (this.facilityType == null) {
                this.facilityType = new ArrayList<FacilityType.FacilityTypeBuilder>();
            }
            return (FacilityType.FacilityTypeBuilder)this.getIndex(this.facilityType, index, () -> {
                FacilityType.FacilityTypeBuilder newFacilityType = FacilityType.builder();
                return newFacilityType;
            });
        }

        @Override
        @RosettaAttribute(value="dealIdentifier")
        @RuneAttribute(value="dealIdentifier")
        public ApplicableAssetsChoiceBuilder addDealIdentifier(DealIdentifier _dealIdentifier) {
            if (_dealIdentifier != null) {
                this.dealIdentifier.add(_dealIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addDealIdentifier(DealIdentifier _dealIdentifier, int idx) {
            this.getIndex(this.dealIdentifier, idx, () -> _dealIdentifier.toBuilder());
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addDealIdentifier(List<? extends DealIdentifier> dealIdentifiers) {
            if (dealIdentifiers != null) {
                for (DealIdentifier dealIdentifier : dealIdentifiers) {
                    this.dealIdentifier.add(dealIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dealIdentifier")
        public ApplicableAssetsChoiceBuilder setDealIdentifier(List<? extends DealIdentifier> dealIdentifiers) {
            this.dealIdentifier = dealIdentifiers == null ? new ArrayList<DealIdentifier.DealIdentifierBuilder>() : (List)dealIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier")
        @RuneAttribute(value="facilityIdentifier")
        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(FacilityIdentifier _facilityIdentifier) {
            if (_facilityIdentifier != null) {
                this.facilityIdentifier.add(_facilityIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(FacilityIdentifier _facilityIdentifier, int idx) {
            this.getIndex(this.facilityIdentifier, idx, () -> _facilityIdentifier.toBuilder());
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(List<? extends FacilityIdentifier> facilityIdentifiers) {
            if (facilityIdentifiers != null) {
                for (FacilityIdentifier facilityIdentifier : facilityIdentifiers) {
                    this.facilityIdentifier.add(facilityIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityIdentifier")
        public ApplicableAssetsChoiceBuilder setFacilityIdentifier(List<? extends FacilityIdentifier> facilityIdentifiers) {
            this.facilityIdentifier = facilityIdentifiers == null ? new ArrayList<FacilityIdentifier.FacilityIdentifierBuilder>() : (List)facilityIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public ApplicableAssetsChoiceBuilder addFacilityType(FacilityType _facilityType) {
            if (_facilityType != null) {
                this.facilityType.add(_facilityType.toBuilder());
            }
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addFacilityType(FacilityType _facilityType, int idx) {
            this.getIndex(this.facilityType, idx, () -> _facilityType.toBuilder());
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder addFacilityType(List<? extends FacilityType> facilityTypes) {
            if (facilityTypes != null) {
                for (FacilityType facilityType : facilityTypes) {
                    this.facilityType.add(facilityType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityType")
        public ApplicableAssetsChoiceBuilder setFacilityType(List<? extends FacilityType> facilityTypes) {
            this.facilityType = facilityTypes == null ? new ArrayList<FacilityType.FacilityTypeBuilder>() : (List)facilityTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ApplicableAssetsChoice build() {
            return new ApplicableAssetsChoiceImpl(this);
        }

        @Override
        public ApplicableAssetsChoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder prune() {
            this.dealIdentifier = this.dealIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.facilityIdentifier = this.facilityIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.facilityType = this.facilityType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDealIdentifier() != null && this.getDealIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFacilityIdentifier() != null && this.getFacilityIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFacilityType() != null && this.getFacilityType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ApplicableAssetsChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ApplicableAssetsChoiceBuilder o = (ApplicableAssetsChoiceBuilder)other;
            merger.mergeRosetta(this.getDealIdentifier(), o.getDealIdentifier(), this::getOrCreateDealIdentifier);
            merger.mergeRosetta(this.getFacilityIdentifier(), o.getFacilityIdentifier(), this::getOrCreateFacilityIdentifier);
            merger.mergeRosetta(this.getFacilityType(), o.getFacilityType(), this::getOrCreateFacilityType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ApplicableAssetsChoice _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.dealIdentifier, _that.getDealIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityIdentifier, _that.getFacilityIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityType, _that.getFacilityType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealIdentifier != null ? this.dealIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.facilityIdentifier != null ? this.facilityIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ApplicableAssetsChoiceBuilder {dealIdentifier=" + String.valueOf(this.dealIdentifier) + ", facilityIdentifier=" + String.valueOf(this.facilityIdentifier) + ", facilityType=" + String.valueOf(this.facilityType) + "}";
        }
    }

    public static interface ApplicableAssetsChoiceBuilder
    extends ApplicableAssetsChoice,
    RosettaModelObjectBuilder {
        public DealIdentifier.DealIdentifierBuilder getOrCreateDealIdentifier(int var1);

        public List<? extends DealIdentifier.DealIdentifierBuilder> getDealIdentifier();

        public FacilityIdentifier.FacilityIdentifierBuilder getOrCreateFacilityIdentifier(int var1);

        public List<? extends FacilityIdentifier.FacilityIdentifierBuilder> getFacilityIdentifier();

        public FacilityType.FacilityTypeBuilder getOrCreateFacilityType(int var1);

        public List<? extends FacilityType.FacilityTypeBuilder> getFacilityType();

        public ApplicableAssetsChoiceBuilder addDealIdentifier(DealIdentifier var1);

        public ApplicableAssetsChoiceBuilder addDealIdentifier(DealIdentifier var1, int var2);

        public ApplicableAssetsChoiceBuilder addDealIdentifier(List<? extends DealIdentifier> var1);

        public ApplicableAssetsChoiceBuilder setDealIdentifier(List<? extends DealIdentifier> var1);

        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(FacilityIdentifier var1);

        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(FacilityIdentifier var1, int var2);

        public ApplicableAssetsChoiceBuilder addFacilityIdentifier(List<? extends FacilityIdentifier> var1);

        public ApplicableAssetsChoiceBuilder setFacilityIdentifier(List<? extends FacilityIdentifier> var1);

        public ApplicableAssetsChoiceBuilder addFacilityType(FacilityType var1);

        public ApplicableAssetsChoiceBuilder addFacilityType(FacilityType var1, int var2);

        public ApplicableAssetsChoiceBuilder addFacilityType(List<? extends FacilityType> var1);

        public ApplicableAssetsChoiceBuilder setFacilityType(List<? extends FacilityType> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dealIdentifier"), processor, DealIdentifier.DealIdentifierBuilder.class, this.getDealIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityIdentifier"), processor, FacilityIdentifier.FacilityIdentifierBuilder.class, this.getFacilityIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityType"), processor, FacilityType.FacilityTypeBuilder.class, this.getFacilityType(), new AttributeMeta[0]);
        }

        public ApplicableAssetsChoiceBuilder prune();
    }

    public static class ApplicableAssetsChoiceImpl
    implements ApplicableAssetsChoice {
        private final List<? extends DealIdentifier> dealIdentifier;
        private final List<? extends FacilityIdentifier> facilityIdentifier;
        private final List<? extends FacilityType> facilityType;

        protected ApplicableAssetsChoiceImpl(ApplicableAssetsChoiceBuilder builder) {
            this.dealIdentifier = Optional.ofNullable(builder.getDealIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.facilityIdentifier = Optional.ofNullable(builder.getFacilityIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.facilityType = Optional.ofNullable(builder.getFacilityType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealIdentifier")
        @RuneAttribute(value="dealIdentifier")
        public List<? extends DealIdentifier> getDealIdentifier() {
            return this.dealIdentifier;
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier")
        @RuneAttribute(value="facilityIdentifier")
        public List<? extends FacilityIdentifier> getFacilityIdentifier() {
            return this.facilityIdentifier;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public List<? extends FacilityType> getFacilityType() {
            return this.facilityType;
        }

        @Override
        public ApplicableAssetsChoice build() {
            return this;
        }

        @Override
        public ApplicableAssetsChoiceBuilder toBuilder() {
            ApplicableAssetsChoiceBuilder builder = ApplicableAssetsChoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ApplicableAssetsChoiceBuilder builder) {
            Optional.ofNullable(this.getDealIdentifier()).ifPresent(builder::setDealIdentifier);
            Optional.ofNullable(this.getFacilityIdentifier()).ifPresent(builder::setFacilityIdentifier);
            Optional.ofNullable(this.getFacilityType()).ifPresent(builder::setFacilityType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ApplicableAssetsChoice _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.dealIdentifier, _that.getDealIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityIdentifier, _that.getFacilityIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityType, _that.getFacilityType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealIdentifier != null ? this.dealIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.facilityIdentifier != null ? this.facilityIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ApplicableAssetsChoice {dealIdentifier=" + String.valueOf(this.dealIdentifier) + ", facilityIdentifier=" + String.valueOf(this.facilityIdentifier) + ", facilityType=" + String.valueOf(this.facilityType) + "}";
        }
    }
}

