/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.AccrualPeriod;
import fpml.consolidated.loan.PaymentProjection;
import fpml.consolidated.loan.meta.AccruingFeePaymentSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AccruingFeePaymentSequence", builder=AccruingFeePaymentSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AccruingFeePaymentSequence", model="fpml", builder=AccruingFeePaymentSequenceBuilderImpl.class, version="1.2.2")
public interface AccruingFeePaymentSequence
extends RosettaModelObject {
    public static final AccruingFeePaymentSequenceMeta metaData = new AccruingFeePaymentSequenceMeta();

    public List<? extends AccrualPeriod> getAccrualSchedule();

    public PaymentProjection getProjection();

    public AccruingFeePaymentSequence build();

    public AccruingFeePaymentSequenceBuilder toBuilder();

    public static AccruingFeePaymentSequenceBuilder builder() {
        return new AccruingFeePaymentSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends AccruingFeePaymentSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccruingFeePaymentSequence> getType() {
        return AccruingFeePaymentSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.class, this.getAccrualSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("projection"), processor, PaymentProjection.class, this.getProjection(), new AttributeMeta[0]);
    }

    public static class AccruingFeePaymentSequenceBuilderImpl
    implements AccruingFeePaymentSequenceBuilder {
        protected List<AccrualPeriod.AccrualPeriodBuilder> accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
        protected PaymentProjection.PaymentProjectionBuilder projection;

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int index) {
            if (this.accrualSchedule == null) {
                this.accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
            }
            return (AccrualPeriod.AccrualPeriodBuilder)this.getIndex(this.accrualSchedule, index, () -> {
                AccrualPeriod.AccrualPeriodBuilder newAccrualSchedule = AccrualPeriod.builder();
                return newAccrualSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public PaymentProjection.PaymentProjectionBuilder getProjection() {
            return this.projection;
        }

        @Override
        public PaymentProjection.PaymentProjectionBuilder getOrCreateProjection() {
            PaymentProjection.PaymentProjectionBuilder result = this.projection != null ? this.projection : (this.projection = PaymentProjection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule) {
            if (_accrualSchedule != null) {
                this.accrualSchedule.add(_accrualSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule, int idx) {
            this.getIndex(this.accrualSchedule, idx, () -> _accrualSchedule.toBuilder());
            return this;
        }

        @Override
        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            if (accrualSchedules != null) {
                for (AccrualPeriod accrualPeriod : accrualSchedules) {
                    this.accrualSchedule.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualSchedule")
        public AccruingFeePaymentSequenceBuilder setAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            this.accrualSchedule = accrualSchedules == null ? new ArrayList<AccrualPeriod.AccrualPeriodBuilder>() : (List)accrualSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public AccruingFeePaymentSequenceBuilder setProjection(PaymentProjection _projection) {
            this.projection = _projection == null ? null : _projection.toBuilder();
            return this;
        }

        @Override
        public AccruingFeePaymentSequence build() {
            return new AccruingFeePaymentSequenceImpl(this);
        }

        @Override
        public AccruingFeePaymentSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public AccruingFeePaymentSequenceBuilder prune() {
            this.accrualSchedule = this.accrualSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.projection != null && !this.projection.prune().hasData()) {
                this.projection = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccrualSchedule() != null && this.getAccrualSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getProjection() != null && this.getProjection().hasData();
        }

        public AccruingFeePaymentSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccruingFeePaymentSequenceBuilder o = (AccruingFeePaymentSequenceBuilder)other;
            merger.mergeRosetta(this.getAccrualSchedule(), o.getAccrualSchedule(), this::getOrCreateAccrualSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProjection(), (RosettaModelObjectBuilder)o.getProjection(), this::setProjection);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccruingFeePaymentSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule())) {
                return false;
            }
            return Objects.equals(this.projection, _that.getProjection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            _result = 31 * _result + (this.projection != null ? this.projection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccruingFeePaymentSequenceBuilder {accrualSchedule=" + String.valueOf(this.accrualSchedule) + ", projection=" + String.valueOf(this.projection) + "}";
        }
    }

    public static interface AccruingFeePaymentSequenceBuilder
    extends AccruingFeePaymentSequence,
    RosettaModelObjectBuilder {
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int var1);

        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule();

        public PaymentProjection.PaymentProjectionBuilder getOrCreateProjection();

        @Override
        public PaymentProjection.PaymentProjectionBuilder getProjection();

        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(AccrualPeriod var1);

        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(AccrualPeriod var1, int var2);

        public AccruingFeePaymentSequenceBuilder addAccrualSchedule(List<? extends AccrualPeriod> var1);

        public AccruingFeePaymentSequenceBuilder setAccrualSchedule(List<? extends AccrualPeriod> var1);

        public AccruingFeePaymentSequenceBuilder setProjection(PaymentProjection var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("projection"), processor, PaymentProjection.PaymentProjectionBuilder.class, this.getProjection(), new AttributeMeta[0]);
        }

        public AccruingFeePaymentSequenceBuilder prune();
    }

    public static class AccruingFeePaymentSequenceImpl
    implements AccruingFeePaymentSequence {
        private final List<? extends AccrualPeriod> accrualSchedule;
        private final PaymentProjection projection;

        protected AccruingFeePaymentSequenceImpl(AccruingFeePaymentSequenceBuilder builder) {
            this.accrualSchedule = Optional.ofNullable(builder.getAccrualSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.projection = Optional.ofNullable(builder.getProjection()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public PaymentProjection getProjection() {
            return this.projection;
        }

        @Override
        public AccruingFeePaymentSequence build() {
            return this;
        }

        @Override
        public AccruingFeePaymentSequenceBuilder toBuilder() {
            AccruingFeePaymentSequenceBuilder builder = AccruingFeePaymentSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccruingFeePaymentSequenceBuilder builder) {
            Optional.ofNullable(this.getAccrualSchedule()).ifPresent(builder::setAccrualSchedule);
            Optional.ofNullable(this.getProjection()).ifPresent(builder::setProjection);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccruingFeePaymentSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule())) {
                return false;
            }
            return Objects.equals(this.projection, _that.getProjection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            _result = 31 * _result + (this.projection != null ? this.projection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccruingFeePaymentSequence {accrualSchedule=" + String.valueOf(this.accrualSchedule) + ", projection=" + String.valueOf(this.projection) + "}";
        }
    }
}

