/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.AccruingFeeType;
import fpml.consolidated.loan.FeeRateOptionBase;
import fpml.consolidated.loan.PeriodOptionalEndModel;
import fpml.consolidated.loan.meta.AccruingFeeOptionMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AccruingFeeOption", builder=AccruingFeeOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AccruingFeeOption", model="fpml", builder=AccruingFeeOptionBuilderImpl.class, version="1.2.2")
public interface AccruingFeeOption
extends FeeRateOptionBase {
    public static final AccruingFeeOptionMeta metaData = new AccruingFeeOptionMeta();

    public AccruingFeeType _getType();

    public PeriodOptionalEndModel getPeriodOptionalEndModel();

    public String getCalculationDefinition();

    @Override
    public AccruingFeeOption build();

    @Override
    public AccruingFeeOptionBuilder toBuilder();

    public static AccruingFeeOptionBuilder builder() {
        return new AccruingFeeOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends AccruingFeeOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccruingFeeOption> getType() {
        return AccruingFeeOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("type"), processor, AccruingFeeType.class, this._getType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodOptionalEndModel"), processor, PeriodOptionalEndModel.class, this.getPeriodOptionalEndModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationDefinition"), String.class, (Object)this.getCalculationDefinition(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AccruingFeeOptionBuilderImpl
    extends FeeRateOptionBase.FeeRateOptionBaseBuilderImpl
    implements AccruingFeeOptionBuilder {
        protected AccruingFeeType.AccruingFeeTypeBuilder type;
        protected PeriodOptionalEndModel.PeriodOptionalEndModelBuilder periodOptionalEndModel;
        protected String calculationDefinition;

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public AccruingFeeType.AccruingFeeTypeBuilder _getType() {
            return this.type;
        }

        @Override
        public AccruingFeeType.AccruingFeeTypeBuilder getOrCreateType() {
            AccruingFeeType.AccruingFeeTypeBuilder result = this.type != null ? this.type : (this.type = AccruingFeeType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodOptionalEndModel", isRequired=true)
        @RuneAttribute(value="periodOptionalEndModel", isRequired=true)
        public PeriodOptionalEndModel.PeriodOptionalEndModelBuilder getPeriodOptionalEndModel() {
            return this.periodOptionalEndModel;
        }

        @Override
        public PeriodOptionalEndModel.PeriodOptionalEndModelBuilder getOrCreatePeriodOptionalEndModel() {
            PeriodOptionalEndModel.PeriodOptionalEndModelBuilder result = this.periodOptionalEndModel != null ? this.periodOptionalEndModel : (this.periodOptionalEndModel = PeriodOptionalEndModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDefinition")
        @RuneAttribute(value="calculationDefinition")
        public String getCalculationDefinition() {
            return this.calculationDefinition;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AccruingFeeOptionBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public AccruingFeeOptionBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public AccruingFeeOptionBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AccruingFeeOptionBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public AccruingFeeOptionBuilder setType(AccruingFeeType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodOptionalEndModel", isRequired=true)
        @RuneAttribute(value="periodOptionalEndModel", isRequired=true)
        public AccruingFeeOptionBuilder setPeriodOptionalEndModel(PeriodOptionalEndModel _periodOptionalEndModel) {
            this.periodOptionalEndModel = _periodOptionalEndModel == null ? null : _periodOptionalEndModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationDefinition")
        @RuneAttribute(value="calculationDefinition")
        public AccruingFeeOptionBuilder setCalculationDefinition(String _calculationDefinition) {
            this.calculationDefinition = _calculationDefinition == null ? null : _calculationDefinition;
            return this;
        }

        @Override
        public AccruingFeeOption build() {
            return new AccruingFeeOptionImpl(this);
        }

        @Override
        public AccruingFeeOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public AccruingFeeOptionBuilder prune() {
            super.prune();
            if (this.type != null && !this.type.prune().hasData()) {
                this.type = null;
            }
            if (this.periodOptionalEndModel != null && !this.periodOptionalEndModel.prune().hasData()) {
                this.periodOptionalEndModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this._getType() != null && this._getType().hasData()) {
                return true;
            }
            if (this.getPeriodOptionalEndModel() != null && this.getPeriodOptionalEndModel().hasData()) {
                return true;
            }
            return this.getCalculationDefinition() != null;
        }

        @Override
        public AccruingFeeOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AccruingFeeOptionBuilder o = (AccruingFeeOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this._getType(), (RosettaModelObjectBuilder)o._getType(), this::setType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodOptionalEndModel(), (RosettaModelObjectBuilder)o.getPeriodOptionalEndModel(), this::setPeriodOptionalEndModel);
            merger.mergeBasic((Object)this.getCalculationDefinition(), (Object)o.getCalculationDefinition(), this::setCalculationDefinition, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingFeeOption _that = (AccruingFeeOption)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.periodOptionalEndModel, _that.getPeriodOptionalEndModel())) {
                return false;
            }
            return Objects.equals(this.calculationDefinition, _that.getCalculationDefinition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.periodOptionalEndModel != null ? this.periodOptionalEndModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationDefinition != null ? this.calculationDefinition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingFeeOptionBuilder {type=" + String.valueOf(this.type) + ", periodOptionalEndModel=" + String.valueOf(this.periodOptionalEndModel) + ", calculationDefinition=" + this.calculationDefinition + "} " + super.toString();
        }
    }

    public static interface AccruingFeeOptionBuilder
    extends AccruingFeeOption,
    FeeRateOptionBase.FeeRateOptionBaseBuilder {
        public AccruingFeeType.AccruingFeeTypeBuilder getOrCreateType();

        @Override
        public AccruingFeeType.AccruingFeeTypeBuilder _getType();

        public PeriodOptionalEndModel.PeriodOptionalEndModelBuilder getOrCreatePeriodOptionalEndModel();

        @Override
        public PeriodOptionalEndModel.PeriodOptionalEndModelBuilder getPeriodOptionalEndModel();

        @Override
        public AccruingFeeOptionBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public AccruingFeeOptionBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public AccruingFeeOptionBuilder setPaymentFrequency(Period var1);

        @Override
        public AccruingFeeOptionBuilder setRate(BigDecimal var1);

        public AccruingFeeOptionBuilder setType(AccruingFeeType var1);

        public AccruingFeeOptionBuilder setPeriodOptionalEndModel(PeriodOptionalEndModel var1);

        public AccruingFeeOptionBuilder setCalculationDefinition(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("type"), processor, AccruingFeeType.AccruingFeeTypeBuilder.class, this._getType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodOptionalEndModel"), processor, PeriodOptionalEndModel.PeriodOptionalEndModelBuilder.class, this.getPeriodOptionalEndModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationDefinition"), String.class, (Object)this.getCalculationDefinition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public AccruingFeeOptionBuilder prune();
    }

    public static class AccruingFeeOptionImpl
    extends FeeRateOptionBase.FeeRateOptionBaseImpl
    implements AccruingFeeOption {
        private final AccruingFeeType type;
        private final PeriodOptionalEndModel periodOptionalEndModel;
        private final String calculationDefinition;

        protected AccruingFeeOptionImpl(AccruingFeeOptionBuilder builder) {
            super(builder);
            this.type = Optional.ofNullable(builder._getType()).map(f -> f.build()).orElse(null);
            this.periodOptionalEndModel = Optional.ofNullable(builder.getPeriodOptionalEndModel()).map(f -> f.build()).orElse(null);
            this.calculationDefinition = builder.getCalculationDefinition();
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public AccruingFeeType _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="periodOptionalEndModel", isRequired=true)
        @RuneAttribute(value="periodOptionalEndModel", isRequired=true)
        public PeriodOptionalEndModel getPeriodOptionalEndModel() {
            return this.periodOptionalEndModel;
        }

        @Override
        @RosettaAttribute(value="calculationDefinition")
        @RuneAttribute(value="calculationDefinition")
        public String getCalculationDefinition() {
            return this.calculationDefinition;
        }

        @Override
        public AccruingFeeOption build() {
            return this;
        }

        @Override
        public AccruingFeeOptionBuilder toBuilder() {
            AccruingFeeOptionBuilder builder = AccruingFeeOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccruingFeeOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getPeriodOptionalEndModel()).ifPresent(builder::setPeriodOptionalEndModel);
            Optional.ofNullable(this.getCalculationDefinition()).ifPresent(builder::setCalculationDefinition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingFeeOption _that = (AccruingFeeOption)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.periodOptionalEndModel, _that.getPeriodOptionalEndModel())) {
                return false;
            }
            return Objects.equals(this.calculationDefinition, _that.getCalculationDefinition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.periodOptionalEndModel != null ? this.periodOptionalEndModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationDefinition != null ? this.calculationDefinition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingFeeOption {type=" + String.valueOf(this.type) + ", periodOptionalEndModel=" + String.valueOf(this.periodOptionalEndModel) + ", calculationDefinition=" + this.calculationDefinition + "} " + super.toString();
        }
    }
}

