/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AbstractLoanServicingEvent;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.AbstractLoanContractEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanContractEvent", builder=AbstractLoanContractEventBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractLoanContractEvent", model="fpml", builder=AbstractLoanContractEventBuilderImpl.class, version="1.2.2")
public interface AbstractLoanContractEvent
extends AbstractLoanServicingEvent {
    public static final AbstractLoanContractEventMeta metaData = new AbstractLoanContractEventMeta();

    public LoanContractReference getLoanContractReference();

    @Override
    public AbstractLoanContractEvent build();

    @Override
    public AbstractLoanContractEventBuilder toBuilder();

    public static AbstractLoanContractEventBuilder builder() {
        return new AbstractLoanContractEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanContractEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanContractEvent> getType() {
        return AbstractLoanContractEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
    }

    public static class AbstractLoanContractEventBuilderImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventBuilderImpl
    implements AbstractLoanContractEventBuilder {
        protected LoanContractReference.LoanContractReferenceBuilder loanContractReference;

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference() {
            LoanContractReference.LoanContractReferenceBuilder result = this.loanContractReference != null ? this.loanContractReference : (this.loanContractReference = LoanContractReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLoanContractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanContractEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanContractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLoanContractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanContractEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLoanContractEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLoanContractEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractLoanContractEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractLoanContractEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractLoanContractEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public AbstractLoanContractEventBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        public AbstractLoanContractEvent build() {
            return new AbstractLoanContractEventImpl(this);
        }

        @Override
        public AbstractLoanContractEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanContractEventBuilder prune() {
            super.prune();
            if (this.loanContractReference != null && !this.loanContractReference.prune().hasData()) {
                this.loanContractReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLoanContractReference() != null && this.getLoanContractReference().hasData();
        }

        @Override
        public AbstractLoanContractEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanContractEventBuilder o = (AbstractLoanContractEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanContractReference(), (RosettaModelObjectBuilder)o.getLoanContractReference(), this::setLoanContractReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanContractEvent _that = (AbstractLoanContractEvent)this.getType().cast(o);
            return Objects.equals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanContractEventBuilder {loanContractReference=" + String.valueOf(this.loanContractReference) + "} " + super.toString();
        }
    }

    public static interface AbstractLoanContractEventBuilder
    extends AbstractLoanContractEvent,
    AbstractLoanServicingEvent.AbstractLoanServicingEventBuilder {
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference();

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference();

        @Override
        public AbstractLoanContractEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractLoanContractEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractLoanContractEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanContractEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanContractEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractLoanContractEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractLoanContractEventBuilder setComment(String var1);

        @Override
        public AbstractLoanContractEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AbstractLoanContractEventBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractLoanContractEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        public AbstractLoanContractEventBuilder setLoanContractReference(LoanContractReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanContractEventBuilder prune();
    }

    public static class AbstractLoanContractEventImpl
    extends AbstractLoanServicingEvent.AbstractLoanServicingEventImpl
    implements AbstractLoanContractEvent {
        private final LoanContractReference loanContractReference;

        protected AbstractLoanContractEventImpl(AbstractLoanContractEventBuilder builder) {
            super(builder);
            this.loanContractReference = Optional.ofNullable(builder.getLoanContractReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractReference getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public AbstractLoanContractEvent build() {
            return this;
        }

        @Override
        public AbstractLoanContractEventBuilder toBuilder() {
            AbstractLoanContractEventBuilder builder = AbstractLoanContractEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanContractEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanContractReference()).ifPresent(builder::setLoanContractReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanContractEvent _that = (AbstractLoanContractEvent)this.getType().cast(o);
            return Objects.equals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanContractEvent {loanContractReference=" + String.valueOf(this.loanContractReference) + "} " + super.toString();
        }
    }
}

