/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.ApprovalVotes;
import fpml.consolidated.loan.meta.AbstractApprovalMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbstractApproval", builder=AbstractApprovalBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractApproval", model="fpml", builder=AbstractApprovalBuilderImpl.class, version="1.2.2")
public interface AbstractApproval
extends RosettaModelObject {
    public static final AbstractApprovalMeta metaData = new AbstractApprovalMeta();

    public ZonedDateTime getEffectiveDate();

    public ApprovalVotes getApprovalVotes();

    public ZonedDateTime getFinalApprovalDate();

    public String getId();

    public AbstractApproval build();

    public AbstractApprovalBuilder toBuilder();

    public static AbstractApprovalBuilder builder() {
        return new AbstractApprovalBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractApproval> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractApproval> getType() {
        return AbstractApproval.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvalVotes"), processor, ApprovalVotes.class, this.getApprovalVotes(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalApprovalDate"), ZonedDateTime.class, (Object)this.getFinalApprovalDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AbstractApprovalBuilderImpl
    implements AbstractApprovalBuilder {
        protected ZonedDateTime effectiveDate;
        protected ApprovalVotes.ApprovalVotesBuilder approvalVotes;
        protected ZonedDateTime finalApprovalDate;
        protected String id;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="approvalVotes", isRequired=true)
        @RuneAttribute(value="approvalVotes", isRequired=true)
        public ApprovalVotes.ApprovalVotesBuilder getApprovalVotes() {
            return this.approvalVotes;
        }

        @Override
        public ApprovalVotes.ApprovalVotesBuilder getOrCreateApprovalVotes() {
            ApprovalVotes.ApprovalVotesBuilder result = this.approvalVotes != null ? this.approvalVotes : (this.approvalVotes = ApprovalVotes.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalApprovalDate")
        @RuneAttribute(value="finalApprovalDate")
        public ZonedDateTime getFinalApprovalDate() {
            return this.finalApprovalDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AbstractApprovalBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="approvalVotes", isRequired=true)
        @RuneAttribute(value="approvalVotes", isRequired=true)
        public AbstractApprovalBuilder setApprovalVotes(ApprovalVotes _approvalVotes) {
            this.approvalVotes = _approvalVotes == null ? null : _approvalVotes.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalApprovalDate")
        @RuneAttribute(value="finalApprovalDate")
        public AbstractApprovalBuilder setFinalApprovalDate(ZonedDateTime _finalApprovalDate) {
            this.finalApprovalDate = _finalApprovalDate == null ? null : _finalApprovalDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AbstractApprovalBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public AbstractApproval build() {
            return new AbstractApprovalImpl(this);
        }

        @Override
        public AbstractApprovalBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractApprovalBuilder prune() {
            if (this.approvalVotes != null && !this.approvalVotes.prune().hasData()) {
                this.approvalVotes = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getApprovalVotes() != null && this.getApprovalVotes().hasData()) {
                return true;
            }
            if (this.getFinalApprovalDate() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public AbstractApprovalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractApprovalBuilder o = (AbstractApprovalBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovalVotes(), (RosettaModelObjectBuilder)o.getApprovalVotes(), this::setApprovalVotes);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalApprovalDate(), (Object)o.getFinalApprovalDate(), this::setFinalApprovalDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractApproval _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.approvalVotes, _that.getApprovalVotes())) {
                return false;
            }
            if (!Objects.equals(this.finalApprovalDate, _that.getFinalApprovalDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.approvalVotes != null ? this.approvalVotes.hashCode() : 0);
            _result = 31 * _result + (this.finalApprovalDate != null ? this.finalApprovalDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractApprovalBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", approvalVotes=" + String.valueOf(this.approvalVotes) + ", finalApprovalDate=" + String.valueOf(this.finalApprovalDate) + ", id=" + this.id + "}";
        }
    }

    public static interface AbstractApprovalBuilder
    extends AbstractApproval,
    RosettaModelObjectBuilder {
        public ApprovalVotes.ApprovalVotesBuilder getOrCreateApprovalVotes();

        @Override
        public ApprovalVotes.ApprovalVotesBuilder getApprovalVotes();

        public AbstractApprovalBuilder setEffectiveDate(ZonedDateTime var1);

        public AbstractApprovalBuilder setApprovalVotes(ApprovalVotes var1);

        public AbstractApprovalBuilder setFinalApprovalDate(ZonedDateTime var1);

        public AbstractApprovalBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvalVotes"), processor, ApprovalVotes.ApprovalVotesBuilder.class, this.getApprovalVotes(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalApprovalDate"), ZonedDateTime.class, (Object)this.getFinalApprovalDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AbstractApprovalBuilder prune();
    }

    public static class AbstractApprovalImpl
    implements AbstractApproval {
        private final ZonedDateTime effectiveDate;
        private final ApprovalVotes approvalVotes;
        private final ZonedDateTime finalApprovalDate;
        private final String id;

        protected AbstractApprovalImpl(AbstractApprovalBuilder builder) {
            this.effectiveDate = builder.getEffectiveDate();
            this.approvalVotes = Optional.ofNullable(builder.getApprovalVotes()).map(f -> f.build()).orElse(null);
            this.finalApprovalDate = builder.getFinalApprovalDate();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="approvalVotes", isRequired=true)
        @RuneAttribute(value="approvalVotes", isRequired=true)
        public ApprovalVotes getApprovalVotes() {
            return this.approvalVotes;
        }

        @Override
        @RosettaAttribute(value="finalApprovalDate")
        @RuneAttribute(value="finalApprovalDate")
        public ZonedDateTime getFinalApprovalDate() {
            return this.finalApprovalDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public AbstractApproval build() {
            return this;
        }

        @Override
        public AbstractApprovalBuilder toBuilder() {
            AbstractApprovalBuilder builder = AbstractApproval.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractApprovalBuilder builder) {
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getApprovalVotes()).ifPresent(builder::setApprovalVotes);
            Optional.ofNullable(this.getFinalApprovalDate()).ifPresent(builder::setFinalApprovalDate);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractApproval _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.approvalVotes, _that.getApprovalVotes())) {
                return false;
            }
            if (!Objects.equals(this.finalApprovalDate, _that.getFinalApprovalDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.approvalVotes != null ? this.approvalVotes.hashCode() : 0);
            _result = 31 * _result + (this.finalApprovalDate != null ? this.finalApprovalDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractApproval {effectiveDate=" + String.valueOf(this.effectiveDate) + ", approvalVotes=" + String.valueOf(this.approvalVotes) + ", finalApprovalDate=" + String.valueOf(this.finalApprovalDate) + ", id=" + this.id + "}";
        }
    }
}

