/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.ird.EarlyTerminationProvision;
import fpml.consolidated.ird.InterestRateStream;
import fpml.consolidated.ird.meta.CapFloorMeta;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CapFloor", builder=CapFloorBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CapFloor", model="fpml", builder=CapFloorBuilderImpl.class, version="1.2.2")
public interface CapFloor
extends Product {
    public static final CapFloorMeta metaData = new CapFloorMeta();

    public InterestRateStream getCapFloorStream();

    public List<? extends Payment> getPremium();

    public List<? extends Payment> getAdditionalPayment();

    public EarlyTerminationProvision getEarlyTerminationProvision();

    @Override
    public CapFloor build();

    @Override
    public CapFloorBuilder toBuilder();

    public static CapFloorBuilder builder() {
        return new CapFloorBuilderImpl();
    }

    default public RosettaMetaData<? extends CapFloor> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CapFloor> getType() {
        return CapFloor.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capFloorStream"), processor, InterestRateStream.class, this.getCapFloorStream(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, Payment.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
    }

    public static class CapFloorBuilderImpl
    extends Product.ProductBuilderImpl
    implements CapFloorBuilder {
        protected InterestRateStream.InterestRateStreamBuilder capFloorStream;
        protected List<Payment.PaymentBuilder> premium = new ArrayList<Payment.PaymentBuilder>();
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();
        protected EarlyTerminationProvision.EarlyTerminationProvisionBuilder earlyTerminationProvision;

        @Override
        @RosettaAttribute(value="capFloorStream", isRequired=true)
        @RuneAttribute(value="capFloorStream", isRequired=true)
        public InterestRateStream.InterestRateStreamBuilder getCapFloorStream() {
            return this.capFloorStream;
        }

        @Override
        public InterestRateStream.InterestRateStreamBuilder getOrCreateCapFloorStream() {
            InterestRateStream.InterestRateStreamBuilder result = this.capFloorStream != null ? this.capFloorStream : (this.capFloorStream = InterestRateStream.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends Payment.PaymentBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public Payment.PaymentBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.premium, index, () -> {
                Payment.PaymentBuilder newPremium = Payment.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision() {
            EarlyTerminationProvision.EarlyTerminationProvisionBuilder result = this.earlyTerminationProvision != null ? this.earlyTerminationProvision : (this.earlyTerminationProvision = EarlyTerminationProvision.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CapFloorBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CapFloorBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="capFloorStream", isRequired=true)
        @RuneAttribute(value="capFloorStream", isRequired=true)
        public CapFloorBuilder setCapFloorStream(InterestRateStream _capFloorStream) {
            this.capFloorStream = _capFloorStream == null ? null : _capFloorStream.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CapFloorBuilder addPremium(Payment _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public CapFloorBuilder addPremium(Payment _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public CapFloorBuilder addPremium(List<? extends Payment> premiums) {
            if (premiums != null) {
                for (Payment payment : premiums) {
                    this.premium.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public CapFloorBuilder setPremium(List<? extends Payment> premiums) {
            this.premium = premiums == null ? new ArrayList<Payment.PaymentBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public CapFloorBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public CapFloorBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public CapFloorBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public CapFloorBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public CapFloorBuilder setEarlyTerminationProvision(EarlyTerminationProvision _earlyTerminationProvision) {
            this.earlyTerminationProvision = _earlyTerminationProvision == null ? null : _earlyTerminationProvision.toBuilder();
            return this;
        }

        @Override
        public CapFloor build() {
            return new CapFloorImpl(this);
        }

        @Override
        public CapFloorBuilder toBuilder() {
            return this;
        }

        @Override
        public CapFloorBuilder prune() {
            super.prune();
            if (this.capFloorStream != null && !this.capFloorStream.prune().hasData()) {
                this.capFloorStream = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.earlyTerminationProvision != null && !this.earlyTerminationProvision.prune().hasData()) {
                this.earlyTerminationProvision = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCapFloorStream() != null && this.getCapFloorStream().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getEarlyTerminationProvision() != null && this.getEarlyTerminationProvision().hasData();
        }

        @Override
        public CapFloorBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CapFloorBuilder o = (CapFloorBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCapFloorStream(), (RosettaModelObjectBuilder)o.getCapFloorStream(), this::setCapFloorStream);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyTerminationProvision(), (RosettaModelObjectBuilder)o.getEarlyTerminationProvision(), this::setEarlyTerminationProvision);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CapFloor _that = (CapFloor)this.getType().cast(o);
            if (!Objects.equals(this.capFloorStream, _that.getCapFloorStream())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.capFloorStream != null ? this.capFloorStream.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CapFloorBuilder {capFloorStream=" + String.valueOf(this.capFloorStream) + ", premium=" + String.valueOf(this.premium) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + ", earlyTerminationProvision=" + String.valueOf(this.earlyTerminationProvision) + "} " + super.toString();
        }
    }

    public static interface CapFloorBuilder
    extends CapFloor,
    Product.ProductBuilder {
        public InterestRateStream.InterestRateStreamBuilder getOrCreateCapFloorStream();

        @Override
        public InterestRateStream.InterestRateStreamBuilder getCapFloorStream();

        public Payment.PaymentBuilder getOrCreatePremium(int var1);

        public List<? extends Payment.PaymentBuilder> getPremium();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision();

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision();

        @Override
        public CapFloorBuilder setProductModel(ProductModel var1);

        @Override
        public CapFloorBuilder setId(String var1);

        public CapFloorBuilder setCapFloorStream(InterestRateStream var1);

        public CapFloorBuilder addPremium(Payment var1);

        public CapFloorBuilder addPremium(Payment var1, int var2);

        public CapFloorBuilder addPremium(List<? extends Payment> var1);

        public CapFloorBuilder setPremium(List<? extends Payment> var1);

        public CapFloorBuilder addAdditionalPayment(Payment var1);

        public CapFloorBuilder addAdditionalPayment(Payment var1, int var2);

        public CapFloorBuilder addAdditionalPayment(List<? extends Payment> var1);

        public CapFloorBuilder setAdditionalPayment(List<? extends Payment> var1);

        public CapFloorBuilder setEarlyTerminationProvision(EarlyTerminationProvision var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capFloorStream"), processor, InterestRateStream.InterestRateStreamBuilder.class, this.getCapFloorStream(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, Payment.PaymentBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.EarlyTerminationProvisionBuilder.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
        }

        @Override
        public CapFloorBuilder prune();
    }

    public static class CapFloorImpl
    extends Product.ProductImpl
    implements CapFloor {
        private final InterestRateStream capFloorStream;
        private final List<? extends Payment> premium;
        private final List<? extends Payment> additionalPayment;
        private final EarlyTerminationProvision earlyTerminationProvision;

        protected CapFloorImpl(CapFloorBuilder builder) {
            super(builder);
            this.capFloorStream = Optional.ofNullable(builder.getCapFloorStream()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.earlyTerminationProvision = Optional.ofNullable(builder.getEarlyTerminationProvision()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="capFloorStream", isRequired=true)
        @RuneAttribute(value="capFloorStream", isRequired=true)
        public InterestRateStream getCapFloorStream() {
            return this.capFloorStream;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends Payment> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        public CapFloor build() {
            return this;
        }

        @Override
        public CapFloorBuilder toBuilder() {
            CapFloorBuilder builder = CapFloor.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CapFloorBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCapFloorStream()).ifPresent(builder::setCapFloorStream);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getEarlyTerminationProvision()).ifPresent(builder::setEarlyTerminationProvision);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CapFloor _that = (CapFloor)this.getType().cast(o);
            if (!Objects.equals(this.capFloorStream, _that.getCapFloorStream())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.capFloorStream != null ? this.capFloorStream.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CapFloor {capFloorStream=" + String.valueOf(this.capFloorStream) + ", premium=" + String.valueOf(this.premium) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + ", earlyTerminationProvision=" + String.valueOf(this.earlyTerminationProvision) + "} " + super.toString();
        }
    }
}

