/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.ird.meta.BulletPaymentMeta;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BulletPayment", builder=BulletPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="BulletPayment", model="fpml", builder=BulletPaymentBuilderImpl.class, version="1.2.2")
public interface BulletPayment
extends Product {
    public static final BulletPaymentMeta metaData = new BulletPaymentMeta();

    public Payment getPayment();

    @Override
    public BulletPayment build();

    @Override
    public BulletPaymentBuilder toBuilder();

    public static BulletPaymentBuilder builder() {
        return new BulletPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends BulletPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BulletPayment> getType() {
        return BulletPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, Payment.class, this.getPayment(), new AttributeMeta[0]);
    }

    public static class BulletPaymentBuilderImpl
    extends Product.ProductBuilderImpl
    implements BulletPaymentBuilder {
        protected Payment.PaymentBuilder payment;

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public Payment.PaymentBuilder getPayment() {
            return this.payment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreatePayment() {
            Payment.PaymentBuilder result = this.payment != null ? this.payment : (this.payment = Payment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public BulletPaymentBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BulletPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public BulletPaymentBuilder setPayment(Payment _payment) {
            this.payment = _payment == null ? null : _payment.toBuilder();
            return this;
        }

        @Override
        public BulletPayment build() {
            return new BulletPaymentImpl(this);
        }

        @Override
        public BulletPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public BulletPaymentBuilder prune() {
            super.prune();
            if (this.payment != null && !this.payment.prune().hasData()) {
                this.payment = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPayment() != null && this.getPayment().hasData();
        }

        @Override
        public BulletPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BulletPaymentBuilder o = (BulletPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayment(), (RosettaModelObjectBuilder)o.getPayment(), this::setPayment);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BulletPayment _that = (BulletPayment)this.getType().cast(o);
            return Objects.equals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BulletPaymentBuilder {payment=" + String.valueOf(this.payment) + "} " + super.toString();
        }
    }

    public static interface BulletPaymentBuilder
    extends BulletPayment,
    Product.ProductBuilder {
        public Payment.PaymentBuilder getOrCreatePayment();

        @Override
        public Payment.PaymentBuilder getPayment();

        @Override
        public BulletPaymentBuilder setProductModel(ProductModel var1);

        @Override
        public BulletPaymentBuilder setId(String var1);

        public BulletPaymentBuilder setPayment(Payment var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, Payment.PaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
        }

        @Override
        public BulletPaymentBuilder prune();
    }

    public static class BulletPaymentImpl
    extends Product.ProductImpl
    implements BulletPayment {
        private final Payment payment;

        protected BulletPaymentImpl(BulletPaymentBuilder builder) {
            super(builder);
            this.payment = Optional.ofNullable(builder.getPayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public Payment getPayment() {
            return this.payment;
        }

        @Override
        public BulletPayment build() {
            return this;
        }

        @Override
        public BulletPaymentBuilder toBuilder() {
            BulletPaymentBuilder builder = BulletPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BulletPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BulletPayment _that = (BulletPayment)this.getType().cast(o);
            return Objects.equals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BulletPayment {payment=" + String.valueOf(this.payment) + "} " + super.toString();
        }
    }
}

